/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.el.coordinator.core.common.utils.UUIDUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitesland.inv.dto.invTro.InvTroPayRpcDTO;
import com.elitesland.pur.dto.po.PurPoPayRpcDTO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartSaveVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderSubmitMqParam;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppPayOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppRelateOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpOrderPayRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDMgmtRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSubmitVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSubmitVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.app.AppDemandOrderService;
import com.elitesland.scp.application.service.cart.ScpStoreCartService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.order.ScpDemandOrderDService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderConvert;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiPurRpcService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.MessageDelyQueueService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.scp.utils.TransactionCommitHandler;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.tenpay.business.entpay.mse.sdk.api.Payment;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AppDemandOrderServiceImpl
implements AppDemandOrderService {
    private static final Logger log = LoggerFactory.getLogger(AppDemandOrderServiceImpl.class);
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpDemandOrderDService scpDemandOrderDService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final RmiItemService rmiItemService;
    private final CartRedisUtil cartRedisUtil;
    private final SysAreaRpcService sysAreaRpcService;
    private final RmiSysUDCService rmiSysUDCService;
    private final ScpStoreCartService scpStoreCartService;
    private final CommonPriceService commonPriceService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final RmiPurRpcService rmiPurRpcService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final RedisUtils redisUtils;
    private final MessageDelyQueueService messageDelyQueueService;
    private final TransactionCommitHandler transactionCommitHandler;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;
    private final TransactionTemplate transactionTemplate;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long submit(ScpDemandOrderSubmitVO saveVO) {
        List<ScpDemandOrderDSubmitVO> itemList = saveVO.getItemList();
        if (CollUtil.isEmpty(itemList)) {
            throw new BusinessException("\u8ba2\u8d27\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrgStoreDetailRpcDTO orgStore = Optional.ofNullable(this.orgStoreRpcService.getByCode(saveVO.getDemandWhStCode())).orElseThrow(() -> new BusinessException("\u95e8\u5e97\u4e0d\u5b58\u5728"));
        saveVO.setStoreLevel(orgStore.getStoreLevel());
        saveVO.setStoreType2(orgStore.getStoreType2());
        String itemCode = SysUtils.getOrderItemSetting();
        List<ScpDemandOrderDSaveVO> saveItemList = AppDemandOrderServiceImpl.buildSaveItemList(itemList, itemCode);
        Long id = this.scpDemandOrderService.saveDemandOrder(ScpDemandOrderConvert.INSTANCE.submitVoToSaveVO(saveVO));
        this.scpDemandOrderDService.batchSaveDemandOrderD(id, "MG", saveItemList);
        this.clearCheckedStoreCartItems(saveVO, saveItemList);
        String orderSetting = SysUtils.getOrderSetting();
        if ("0".equals(orderSetting)) {
            return id;
        }
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        log.info("\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)currentUserDTO));
        if (ObjectUtils.isEmpty((Object)currentUserDTO) || currentUserDTO.getDetail() == null) {
            throw new BusinessException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u7528\u6237\u5931\u8d25");
        }
        this.transactionCommitHandler.handle(() -> {
            ScpOrderSubmitMqParam orderSubmitMqParam = new ScpOrderSubmitMqParam();
            orderSubmitMqParam.setDemandOrderId(id);
            orderSubmitMqParam.setAgentEmpId(currentUserDTO.getDetail().getEmployeeId());
            orderSubmitMqParam.setBusinessKey("scp_demand_order_submit");
            orderSubmitMqParam.setDemandWhStCode(saveVO.getDemandWhStCode());
            List<Long> activityIds = saveItemList.stream().map(ScpDemandOrderDSaveVO::getActivityId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            orderSubmitMqParam.setActivityIds(activityIds);
            this.messageQueueTemplate.publishMessageSync("yst-suplan", "scp_demand_order_submit", (Serializable)orderSubmitMqParam);
        });
        return id;
    }

    private static List<ScpDemandOrderDSaveVO> buildSaveItemList(List<ScpDemandOrderDSubmitVO> itemList, String itemCode) {
        List<ScpDemandOrderDSaveVO> saveItemList = itemList.stream().flatMap(item -> item.getItemSpecObjectVOS().stream().flatMap(row -> {
            String uuid = UUIDUtil.getUUID();
            return row.getWhAllocObjects().stream().map(wh -> AppDemandOrderServiceImpl.buildScpDemandOrderDVO(item, row, wh, uuid, itemCode));
        })).collect(Collectors.toList());
        return saveItemList;
    }

    private void clearCheckedStoreCartItems(ScpDemandOrderSubmitVO saveVO, List<ScpDemandOrderDSaveVO> saveItemList) {
        for (ScpDemandOrderDSaveVO item2 : saveItemList) {
            this.cartRedisUtil.clearCheckedStoreCartItems(saveVO.getDemandWhStCode(), UserService.currentUserId(), saveVO.getDocType(), SysUtils.getItemKey(item2.getCombineItemCode(), item2.getItemCode()));
        }
        for (ScpDemandOrderDSaveVO scpDemandOrderDSaveVO : saveItemList.stream().filter(item -> StringUtils.hasLength((String)item.getCombineItemCode())).toList()) {
            this.cartRedisUtil.clearCheckedStoreCartItems(saveVO.getDemandWhStCode(), UserService.currentUserId(), saveVO.getDocType(), SysUtils.getItemKey("", scpDemandOrderDSaveVO.getCombineItemCode()));
        }
    }

    private static ScpDemandOrderDSaveVO buildScpDemandOrderDVO(ScpDemandOrderDSubmitVO item, ScpDemandOrderDSubmitVO.ItemSpecObjectVO row, ScpDemandOrderDSubmitVO.WhAllocObject wh, String uuid, String freightItemCode) {
        ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = new ScpDemandOrderDSaveVO();
        scpDemandOrderDSaveVO.setAllocationDeQuantity(wh.getQty());
        scpDemandOrderDSaveVO.setRatio(wh.getRatio());
        scpDemandOrderDSaveVO.setSupplyType(wh.getSupplyType());
        scpDemandOrderDSaveVO.setSuppWhId(wh.getSupplyWhId());
        scpDemandOrderDSaveVO.setSuppWhCode(wh.getSupplyWhCode());
        scpDemandOrderDSaveVO.setSuppWhName(wh.getSupplyWhName());
        scpDemandOrderDSaveVO.setSpuItemCode(item.getSpuCode());
        scpDemandOrderDSaveVO.setSpuItemName(item.getSpuName());
        scpDemandOrderDSaveVO.setItemId(row.getItemId());
        scpDemandOrderDSaveVO.setItemCode(row.getItemCode());
        scpDemandOrderDSaveVO.setItemName(row.getItemName());
        scpDemandOrderDSaveVO.setDemandQuantity(row.getDemandQuantity());
        scpDemandOrderDSaveVO.setUnit(row.getUom());
        scpDemandOrderDSaveVO.setUnitName(row.getUomName());
        scpDemandOrderDSaveVO.setPrice(wh.getItemPrice());
        scpDemandOrderDSaveVO.setOuId(wh.getOuId());
        scpDemandOrderDSaveVO.setOuCode(wh.getOuCode());
        scpDemandOrderDSaveVO.setOuName(wh.getOuName());
        scpDemandOrderDSaveVO.setIsCalculated(Boolean.FALSE);
        scpDemandOrderDSaveVO.setIsPushed(Boolean.FALSE);
        scpDemandOrderDSaveVO.setUom2(row.getUom2());
        scpDemandOrderDSaveVO.setUom2Name(row.getUom2Name());
        scpDemandOrderDSaveVO.setUomRatio(row.getUomRatio());
        if (row.getUomRatio() != null) {
            scpDemandOrderDSaveVO.setQty2(wh.getQty().multiply(row.getUomRatio()).setScale((int)row.getDecimalPlaces(), RoundingMode.HALF_UP));
        }
        if (wh.getItemPrice() != null) {
            scpDemandOrderDSaveVO.setDemandAmt(SysUtils.processAmtScale(row.getDemandQuantity().multiply(wh.getItemPrice())));
        }
        scpDemandOrderDSaveVO.setFreightFlag(wh.getFreightFlag());
        scpDemandOrderDSaveVO.setFreightRatio(wh.getFreightRatio());
        scpDemandOrderDSaveVO.setSaleCustCode(wh.getSaleCustCode());
        scpDemandOrderDSaveVO.setSaleOuCode(wh.getSaleOuCode());
        scpDemandOrderDSaveVO.setSaleOuName(wh.getSaleOuName());
        scpDemandOrderDSaveVO.setItemType(row.getItemType());
        scpDemandOrderDSaveVO.setPreRootUuid(uuid);
        scpDemandOrderDSaveVO.setImgUrl(item.getUrl());
        scpDemandOrderDSaveVO.setFreightLineFlag(freightItemCode.equals(row.getItemCode()));
        scpDemandOrderDSaveVO.setActivityId(row.getActivityId());
        scpDemandOrderDSaveVO.setActivityCode(row.getActivityCode());
        scpDemandOrderDSaveVO.setMinNum(row.getMinNum());
        scpDemandOrderDSaveVO.setCombineItemCode(item.getCombineItemCode());
        scpDemandOrderDSaveVO.setCombineItemName(item.getCombineItemName());
        return scpDemandOrderDSaveVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveDemandOrderD(List<ScpDemandOrderDSaveVO> saveVOS) {
        BigDecimal maxLineNo = this.scpDemandOrderDDomainService.findMaxLineNoPushedByMasId(saveVOS.get(0).getMasId());
        AtomicInteger lineNo = new AtomicInteger(maxLineNo.add(BigDecimal.ONE).intValue());
        for (ScpDemandOrderDSaveVO saveVO : saveVOS) {
            if (saveVO.getId() == null) continue;
            saveVO.setLineNo(BigDecimal.valueOf(lineNo.getAndIncrement()));
        }
        this.scpDemandOrderDDomainService.batchSave(saveVOS, lineNo);
    }

    @Override
    public void addCart(Long id) {
        ScpDemandOrderRespVO demandOrder = this.scpDemandOrderService.findDemandOrderById(id).orElseThrow(new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728"));
        List<ScpDemandOrderDMgmtRespVO> demandItemList = this.scpDemandOrderDService.findDemandOrderDByMasId(id);
        if (CollUtil.isEmpty(demandItemList)) {
            return;
        }
        String storeCode = demandOrder.getDemandWhStCode();
        String docType = demandOrder.getDocType();
        ArrayList<StoreCartSaveVO> cartSaveVOS = new ArrayList<StoreCartSaveVO>();
        String orderItemSetting = SysUtils.getOrderItemSetting();
        List itemIds = demandItemList.stream().map(ScpDemandOrderDMgmtRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ItmItemScpBaseRpcParam itmItemScpBaseRpcParam = new ItmItemScpBaseRpcParam();
        itmItemScpBaseRpcParam.setItemIds(itemIds);
        List<ItmItemScpBaseRpcDTO> itemList = this.rmiItemService.findItemScpBaseRpcDtoByParam(itmItemScpBaseRpcParam);
        Map itemMap = itemList.stream().collect(Collectors.toMap(ItmItemScpBaseRpcDTO::getId, Function.identity()));
        for (ScpDemandOrderDMgmtRespVO item : demandItemList) {
            if (orderItemSetting.equals(item.getItemCode())) continue;
            StoreCartSaveVO cartSaveVO = new StoreCartSaveVO();
            ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = (ItmItemScpBaseRpcDTO)itemMap.get(item.getItemId());
            cartSaveVO.setDemandWhStCode(storeCode);
            cartSaveVO.setCartType(docType);
            cartSaveVO.setItemId(item.getItemId());
            cartSaveVO.setItemCode(item.getItemCode());
            cartSaveVO.setItemName(itmItemScpBaseRpcDTO.getItemName());
            cartSaveVO.setUom(item.getUnit());
            cartSaveVO.setUomName(item.getUnitName());
            cartSaveVO.setSpuId(itmItemScpBaseRpcDTO.getSpuId());
            cartSaveVO.setSpuCode(itmItemScpBaseRpcDTO.getSpuCode());
            cartSaveVO.setSpuName(itmItemScpBaseRpcDTO.getSpuName());
            cartSaveVO.setQty(item.getDemandQuantity());
            cartSaveVO.setSpec(itmItemScpBaseRpcDTO.getSpec());
            List skuAttchmentList = itmItemScpBaseRpcDTO.getSkuAttchmentList();
            List spuAttchmentList = itmItemScpBaseRpcDTO.getSpuAttchmentList();
            if (CollUtil.isNotEmpty((Collection)skuAttchmentList)) {
                first = skuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                cartSaveVO.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)skuAttchmentList.get(0)).getUrl() : first.get().getUrl());
            } else if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                cartSaveVO.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
            }
            cartSaveVO.setItemCateCode(itmItemScpBaseRpcDTO.getItemCateCode());
            cartSaveVO.setItemCateName(itmItemScpBaseRpcDTO.getItemCateName());
            cartSaveVOS.add(cartSaveVO);
        }
        ScpOrderSettingRespVO orderSetting = this.scpOrderSettingDomainService.findCacheByDocType(docType, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        List<AppItemActivityItemPriceParamVO> priceParamVOS = cartSaveVOS.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getItemId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
            priceParamVO.setUom(row.getUom());
            return priceParamVO;
        }).collect(Collectors.toList());
        Map<String, List<PriPriceRpcDTO>> priceMap = this.commonPriceService.getPriceAndStockDetails(priceParamVOS, storeCode, orderSetting, demandOrder.getType());
        cartSaveVOS.forEach(row -> {
            if (priceMap.containsKey(row.getItemCode())) {
                row.setItemPrice(SysUtils.processPriceScale(((PriPriceRpcDTO)((List)priceMap.get(row.getItemCode())).get(0)).getPrice()));
            }
        });
        this.scpStoreCartService.batchSaveCart(storeCode, docType, cartSaveVOS);
    }

    @Override
    @SysCodeProc
    public ScpDemandOrderRespVO findDemandOrderById(Long id) {
        ScpDemandOrderRespVO orderRespVO = this.scpDemandOrderService.findDemandOrderById(id).get();
        Map<String, String> areaMap = this.buildAddr(orderRespVO.getRecvProvince(), orderRespVO.getRecvCity(), orderRespVO.getRecvCounty());
        if (CollUtil.isNotEmpty(areaMap)) {
            orderRespVO.setRecvProvinceName(areaMap.get(orderRespVO.getRecvProvince()));
            orderRespVO.setRecvCityName(areaMap.get(orderRespVO.getRecvCity()));
            orderRespVO.setRecvCountyName(areaMap.get(orderRespVO.getRecvCounty()));
        }
        List<ScpDemandOrderDDTO> demandOrderD = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(id);
        AtomicReference<BigDecimal> itemTotalCount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> amt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> noPayAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> freightAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        for (ScpDemandOrderDDTO row : demandOrderD) {
            if (row.getPlanQuantity() != null) {
                itemTotalCount.updateAndGet(v -> v.add(row.getPlanQuantity()));
            }
            if (row.getPlanAmt() == null) continue;
            amt.updateAndGet(v -> v.add(row.getPlanAmt()));
            if (row.getPayStatus() != null && ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode().equals(row.getPayStatus())) {
                noPayAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
            }
            if (row.getFreightLineFlag().booleanValue()) {
                freightAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
                continue;
            }
            goodAmt.updateAndGet(v -> v.add(row.getPlanAmt()));
        }
        orderRespVO.setItemTotalCount(itemTotalCount.get());
        orderRespVO.setAmt(amt.get());
        orderRespVO.setNoPayAmt(noPayAmt.get());
        orderRespVO.setGoodAmt(goodAmt.get());
        orderRespVO.setFreightAmt(freightAmt.get());
        return orderRespVO;
    }

    @Override
    @SysCodeProc
    public AppPayOrderRespVO findPayOrderById(Long srcDocId) {
        AppPayOrderRespVO appPayOrderRespVO = this.scpDemandOrderDomainService.payOrderById(srcDocId);
        ScpDemandOrderDTO scpDemandOrderDTO = this.scpDemandOrderDomainService.findDemandOrderById(appPayOrderRespVO.getDocId()).get();
        appPayOrderRespVO.setDocCode(scpDemandOrderDTO.getDocCode());
        appPayOrderRespVO.setDocType(scpDemandOrderDTO.getDocType());
        appPayOrderRespVO.setCreateTime(scpDemandOrderDTO.getCreateTime());
        appPayOrderRespVO.setRecvContactName(scpDemandOrderDTO.getRecvContactName());
        appPayOrderRespVO.setRecvContactTel(scpDemandOrderDTO.getRecvContactTel());
        String payStatus = this.queryWqfAndUpdatePayStatus(appPayOrderRespVO.getSrcDocNo(), appPayOrderRespVO.getPayStatus(), appPayOrderRespVO.getOnlinePayFlag());
        appPayOrderRespVO.setPayStatus(payStatus);
        Map<String, String> stringStringMap = this.buildAddr(scpDemandOrderDTO.getRecvProvince(), scpDemandOrderDTO.getRecvCity(), scpDemandOrderDTO.getRecvCounty());
        if (CollUtil.isNotEmpty(stringStringMap)) {
            appPayOrderRespVO.setRecvProvinceName(stringStringMap.get(scpDemandOrderDTO.getRecvProvince()));
            appPayOrderRespVO.setRecvCityName(stringStringMap.get(scpDemandOrderDTO.getRecvCity()));
            appPayOrderRespVO.setRecvCountyName(stringStringMap.get(scpDemandOrderDTO.getRecvCounty()));
        }
        if (!this.redisUtils.hasKey("SCP_ONLINE_PAY:" + appPayOrderRespVO.getSrcDocNo())) {
            return appPayOrderRespVO;
        }
        appPayOrderRespVO.setCountdown(this.messageDelyQueueService.getOrderExpireTime("SCP_ONLINE_PAY:" + appPayOrderRespVO.getSrcDocNo()));
        return appPayOrderRespVO;
    }

    private String queryWqfAndUpdatePayStatus(String srcDocNo, String payStatus, Boolean onlinePayFlag) {
        if (!onlinePayFlag.booleanValue() || ScpUdcEnum.PAY_STATUS_PAYED.getValueCode().equals(payStatus)) {
            return payStatus;
        }
        try {
            Payment payment = Payment.retrieveByOutPaymentId((String)srcDocNo);
            List<String> payStatusList = List.of("CLOSED", "PROCESSING");
            if (payStatusList.contains(payment.getPayStatus())) {
                return payStatus;
            }
            String updatePayStatus = "SUCCEEDED".equals(payment.getPayStatus()) ? ScpUdcEnum.PAY_STATUS_PAYED.getValueCode() : ScpUdcEnum.PAY_STATUS_PAYING.getValueCode();
            this.transactionTemplate.setPropagationBehavior(3);
            this.transactionTemplate.execute(transactionStatus -> {
                try {
                    this.scpDemandOrderDRepoProc.updatePayStatusBySrcDocId(srcDocNo, updatePayStatus);
                    return "ok";
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u8ba2\u8d27\u5355\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                    transactionStatus.setRollbackOnly();
                    return "ok";
                }
            });
            return updatePayStatus;
        }
        catch (EntpayException e) {
            log.error("\u67e5\u8be2\u94f6\u884c\u4fe1\u606f\u5931\u8d25:{}", (Throwable)e);
            return payStatus;
        }
    }

    @Override
    public AppPayOrderItemRespVO findPayOrderItemById(Long srcDocId) {
        AppPayOrderItemRespVO result = new AppPayOrderItemRespVO();
        List<ScpDemandOrderDDTO> demandOrderDDTOS = this.scpDemandOrderDDomainService.findDemandOrderDBySrcDocId(srcDocId);
        if (CollUtil.isEmpty(demandOrderDDTOS)) {
            throw new BusinessException("\u8ba2\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        Map<String, String> uomCodeMap = this.rmiSysUDCService.getCodeMap("yst-supp", "UOM");
        List<Long> itemIds = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getItemId).distinct().collect(Collectors.toList());
        Map<Long, ItmItemScpBaseRpcDTO> scpItemMap = this.rmiItemService.findScpItemMap(itemIds);
        List combineItemCodes = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getCombineItemCode).collect(Collectors.toList());
        ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
        param.setItemCodes(combineItemCodes);
        List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam = this.rmiItemService.findItemScpBaseRpcDtoByParam(param);
        BigDecimal totalNum = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getPlanQuantity).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amt = demandOrderDDTOS.stream().map(ScpDemandOrderDDTO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        result.setAmt(amt);
        result.setTotalNum(totalNum);
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> freightAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        for (ScpDemandOrderDDTO row2 : demandOrderDDTOS) {
            if (row2.getPlanAmt() == null) continue;
            if (row2.getFreightLineFlag().booleanValue()) {
                freightAmt.updateAndGet(v -> v.add(row2.getPlanAmt()));
                continue;
            }
            goodAmt.updateAndGet(v -> v.add(row2.getPlanAmt()));
        }
        result.setGoodAmt(goodAmt.get());
        result.setFreightAmt(freightAmt.get());
        result.setCateNum(demandOrderDDTOS.size());
        List subItemList = demandOrderDDTOS.stream().filter(row -> StringUtils.hasLength((String)row.getCombineItemCode())).collect(Collectors.toList());
        Map<Object, Object> subItemMap = new HashMap();
        if (CollUtil.isNotEmpty(subItemList)) {
            demandOrderDDTOS.removeAll(subItemList);
            subItemMap = subItemList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getCombineItemCode));
        }
        ArrayList<AppPayOrderItemRespVO.ItemSpecObjectVO> itemSpecObjectVOList = new ArrayList<AppPayOrderItemRespVO.ItemSpecObjectVO>();
        List itemList = demandOrderDDTOS.stream().map(row -> {
            AppPayOrderItemRespVO.ItemSpecObjectVO specObj = new AppPayOrderItemRespVO.ItemSpecObjectVO();
            specObj.setItemCode(row.getItemCode());
            specObj.setItemName(row.getItemName());
            specObj.setUom(row.getUnit());
            if (uomCodeMap.containsKey(row.getUnit())) {
                specObj.setUomName((String)uomCodeMap.get(row.getUnit()));
            }
            if (scpItemMap.containsKey(row.getItemId())) {
                ItmItemScpBaseRpcDTO item = (ItmItemScpBaseRpcDTO)scpItemMap.get(row.getItemId());
                specObj.setItemAttrName(StrUtil.isBlank((CharSequence)item.getItemAttrName()) ? item.getSpec() : item.getItemAttrName());
                specObj.setAnotherName(item.getAnotherName());
                List spuAttchmentList = item.getSpuAttchmentList();
                if (CollUtil.isNotEmpty((Collection)item.getSkuAttchmentList())) {
                    Optional<ItmItemAttachmentRpcDTO> first = item.getSkuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                    String url = first.isPresent() ? first.get().getUrl() : ((ItmItemAttachmentRpcDTO)item.getSkuAttchmentList().get(0)).getUrl();
                    specObj.setUrl(url);
                } else if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                    Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                    specObj.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                }
            }
            specObj.setAmt(row.getPlanAmt());
            specObj.setQty(row.getPlanQuantity());
            return specObj;
        }).collect(Collectors.toList());
        if (!subItemMap.isEmpty()) {
            subItemMap.forEach((combineItemCode, values) -> {
                AppPayOrderItemRespVO.ItemSpecObjectVO mainItem = new AppPayOrderItemRespVO.ItemSpecObjectVO();
                mainItem.setItemCode((String)combineItemCode);
                mainItem.setItemName(((ScpDemandOrderDDTO)values.get(0)).getCombineItemName());
                itemRpcDtoByParam.stream().filter(row -> combineItemCode.equals(row.getItemCode())).findFirst().ifPresent(row -> {
                    mainItem.setUom(row.getUom2());
                    if (CollUtil.isNotEmpty((Collection)row.getSkuAttchmentList())) {
                        first = row.getSkuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                        String url = first.isPresent() ? first.get().getUrl() : ((ItmItemAttachmentRpcDTO)row.getSkuAttchmentList().get(0)).getUrl();
                        mainItem.setUrl(url);
                    } else if (CollUtil.isNotEmpty((Collection)row.getSpuAttchmentList())) {
                        first = row.getSpuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                        mainItem.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)row.getSpuAttchmentList().get(0)).getUrl() : first.get().getUrl());
                    }
                    mainItem.setItemAttrName(row.getItemAttrName());
                    mainItem.setAnotherName(row.getAnotherName());
                    mainItem.setAmt(values.stream().map(ScpDemandOrderDDTO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                    ScpDemandOrderDDTO scpDemandOrderDDTO = (ScpDemandOrderDDTO)values.get(0);
                    row.getSubItems().stream().filter(a -> a.getId().equals(scpDemandOrderDDTO.getItemId())).findFirst().ifPresent(b -> mainItem.setQty(scpDemandOrderDDTO.getPlanQuantity().divide(b.getBomQty(), 0, RoundingMode.FLOOR)));
                });
                if (uomCodeMap.containsKey(mainItem.getUom())) {
                    mainItem.setUomName((String)uomCodeMap.get(mainItem.getUom()));
                }
                List<AppPayOrderItemRespVO.ItemSpecObjectVO> itemList2 = values.stream().map(row -> {
                    AppPayOrderItemRespVO.ItemSpecObjectVO specObj = new AppPayOrderItemRespVO.ItemSpecObjectVO();
                    specObj.setItemCode(row.getItemCode());
                    specObj.setItemName(row.getItemName());
                    specObj.setUom(row.getUnit());
                    if (uomCodeMap.containsKey(row.getUnit())) {
                        specObj.setUomName((String)uomCodeMap.get(row.getUnit()));
                    }
                    if (scpItemMap.containsKey(row.getItemId())) {
                        ItmItemScpBaseRpcDTO item = (ItmItemScpBaseRpcDTO)scpItemMap.get(row.getItemId());
                        specObj.setItemAttrName(StrUtil.isBlank((CharSequence)item.getItemAttrName()) ? item.getSpec() : item.getItemAttrName());
                        specObj.setAnotherName(item.getAnotherName());
                        List spuAttchmentList = item.getSpuAttchmentList();
                        if (CollUtil.isNotEmpty((Collection)item.getSkuAttchmentList())) {
                            Optional<ItmItemAttachmentRpcDTO> first = item.getSkuAttchmentList().stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                            String url = first.isPresent() ? first.get().getUrl() : ((ItmItemAttachmentRpcDTO)item.getSkuAttchmentList().get(0)).getUrl();
                            specObj.setUrl(url);
                        } else if (CollUtil.isNotEmpty((Collection)spuAttchmentList)) {
                            Optional<ItmItemAttachmentRpcDTO> first = spuAttchmentList.stream().filter(ItmItemAttachmentRpcDTO::getMajor).findFirst();
                            specObj.setUrl(first.isEmpty() ? ((ItmItemAttachmentRpcDTO)spuAttchmentList.get(0)).getUrl() : first.get().getUrl());
                        }
                    }
                    specObj.setAmt(row.getPlanAmt());
                    specObj.setQty(row.getPlanQuantity());
                    return specObj;
                }).collect(Collectors.toList());
                mainItem.setItemList(itemList2);
                itemSpecObjectVOList.add(mainItem);
            });
        }
        itemSpecObjectVOList.addAll(itemList);
        result.setItemList(itemSpecObjectVOList);
        return result;
    }

    @Override
    @SysCodeProc
    public List<AppRelateOrderRespVO> findRelateOrderById(Long id) {
        ArrayList<AppRelateOrderRespVO> result = new ArrayList<AppRelateOrderRespVO>();
        List<ScpDemandOrderDDTO> orderDDTOList = this.scpDemandOrderDDomainService.findDemandOrderDByMasId(id);
        if (CollUtil.isEmpty(orderDDTOList)) {
            throw new BusinessException("\u5173\u8054\u5355\u636e\u4e0d\u5b58\u5728");
        }
        Map<String, String> uomCodeMap = this.rmiSysUDCService.getCodeMap("yst-supp", "UOM");
        Map<String, List<ScpDemandOrderDDTO>> orderMap = orderDDTOList.stream().filter(row -> row.getSrcDocId() != null).collect(Collectors.groupingBy(row -> row.getSrcDocNo() + "@" + row.getSaleOuCode()));
        for (Map.Entry<String, List<ScpDemandOrderDDTO>> entry : orderMap.entrySet()) {
            String srcDocNo = entry.getKey().split("@")[0];
            AppRelateOrderRespVO appRelateOrderRespVO = new AppRelateOrderRespVO();
            List<ScpDemandOrderDDTO> value = entry.getValue();
            BigDecimal amt = value.stream().map(ScpDemandOrderDDTO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            List combineItemCodes = value.stream().map(ScpDemandOrderDDTO::getCombineItemCode).collect(Collectors.toList());
            ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
            param.setItemCodes(combineItemCodes);
            List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam = this.rmiItemService.findItemScpBaseRpcDtoByParam(param);
            Map<Object, Object> subItemMap = new HashMap();
            List subItemList = value.stream().filter(row -> StringUtils.hasLength((String)row.getCombineItemCode())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(subItemList)) {
                value.removeAll(subItemList);
                subItemMap = subItemList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDTO::getCombineItemCode));
            }
            ArrayList<AppRelateOrderRespVO.ItemRespVO> allItemList = new ArrayList<AppRelateOrderRespVO.ItemRespVO>();
            List inItemList = value.stream().map(row -> {
                AppRelateOrderRespVO.ItemRespVO itemRespVO = new AppRelateOrderRespVO.ItemRespVO();
                itemRespVO.setItemCode(row.getItemCode());
                itemRespVO.setItemName(row.getItemName());
                itemRespVO.setQty(row.getPlanQuantity());
                itemRespVO.setAmt(row.getPlanAmt());
                itemRespVO.setUom(row.getUnit());
                if (uomCodeMap.containsKey(row.getUnit())) {
                    itemRespVO.setUomName((String)uomCodeMap.get(row.getUnit()));
                }
                return itemRespVO;
            }).collect(Collectors.toList());
            if (!subItemMap.isEmpty()) {
                for (Map.Entry<Object, Object> subItemEntry : subItemMap.entrySet()) {
                    List<AppRelateOrderRespVO.ItemRespVO> subItemRespVOList = ((List)subItemEntry.getValue()).stream().map(row -> {
                        AppRelateOrderRespVO.ItemRespVO itemRespVO = new AppRelateOrderRespVO.ItemRespVO();
                        itemRespVO.setItemCode(row.getItemCode());
                        itemRespVO.setItemName(row.getItemName());
                        itemRespVO.setQty(row.getPlanQuantity());
                        itemRespVO.setAmt(row.getPlanAmt());
                        itemRespVO.setUom(row.getUnit());
                        if (uomCodeMap.containsKey(row.getUnit())) {
                            itemRespVO.setUomName((String)uomCodeMap.get(row.getUnit()));
                        }
                        return itemRespVO;
                    }).collect(Collectors.toList());
                    AppRelateOrderRespVO.ItemRespVO itemRespVO = new AppRelateOrderRespVO.ItemRespVO();
                    List value1 = (List)subItemEntry.getValue();
                    itemRespVO.setItemCode((String)subItemEntry.getKey());
                    itemRespVO.setItemName(((ScpDemandOrderDDTO)value1.get(0)).getCombineItemName());
                    itemRpcDtoByParam.stream().filter(row -> ((String)subItemEntry.getKey()).equals(row.getItemCode())).findFirst().ifPresent(row -> {
                        itemRespVO.setUom(row.getUom());
                        itemRespVO.setAmt(((List)subItemEntry.getValue()).stream().map(ScpDemandOrderDDTO::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                        ItmItemScpBaseRpcDTO itmItemScpBaseRpcDTO = (ItmItemScpBaseRpcDTO)row.getSubItems().get(0);
                        ((List)subItemEntry.getValue()).stream().filter(a -> a.getItemId().equals(itmItemScpBaseRpcDTO.getId())).findFirst().ifPresent(b -> itemRespVO.setQty(b.getPlanQuantity().divide(itmItemScpBaseRpcDTO.getBomQty(), 0, RoundingMode.FLOOR)));
                    });
                    itemRespVO.setItemList(subItemRespVOList);
                    allItemList.add(itemRespVO);
                }
            }
            allItemList.addAll(inItemList);
            appRelateOrderRespVO.setItemList(allItemList);
            ScpDemandOrderDDTO scpDemandOrderDDTO = entry.getValue().get(0);
            String payStatus = this.queryWqfAndUpdatePayStatus(srcDocNo, scpDemandOrderDDTO.getPayStatus(), scpDemandOrderDDTO.getOnlinePayFlag());
            appRelateOrderRespVO.setPayStatus(payStatus);
            appRelateOrderRespVO.setSrcDocNo(srcDocNo);
            appRelateOrderRespVO.setSrcDocId(scpDemandOrderDDTO.getSrcDocId());
            appRelateOrderRespVO.setSrcDocCls(scpDemandOrderDDTO.getSrcDocCls());
            appRelateOrderRespVO.setSaleOuName(scpDemandOrderDDTO.getSaleOuName());
            appRelateOrderRespVO.setSaleOuCode(scpDemandOrderDDTO.getSaleOuCode());
            appRelateOrderRespVO.setCreateTime(scpDemandOrderDDTO.getCreateTime());
            appRelateOrderRespVO.setAmt(amt);
            appRelateOrderRespVO.setPayerName(scpDemandOrderDDTO.getPayerName());
            result.add(appRelateOrderRespVO);
        }
        return result;
    }

    @Override
    public ScpOrderPayRespVO payInfo(String docCls, Long id) {
        List<PurPoPayRpcDTO> purPoPayList;
        List<ScpOrderPayRespVO.PayItem> payItems;
        BigDecimal totalAmt;
        List<InvTroPayRpcDTO> invTroPayList;
        ScpOrderPayRespVO scpOrderPayRespVO = new ScpOrderPayRespVO();
        LocalDateTime createTime = this.scpDemandOrderDDomainService.findDocCreateTimeBySrcDocId(id);
        if (createTime == null) {
            throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        scpOrderPayRespVO.setDocDateTime(createTime);
        if ("STKTRO".equals(docCls) && CollUtil.isNotEmpty(invTroPayList = this.rmiInvStkRpcService.payInfo(id))) {
            totalAmt = invTroPayList.stream().map(InvTroPayRpcDTO::getReceiptAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            payItems = ScpDemandOrderConvert.INSTANCE.troDtosToRespVOS(invTroPayList);
            scpOrderPayRespVO.setItemList(payItems);
            scpOrderPayRespVO.setAmt(totalAmt);
            scpOrderPayRespVO.setPayDateTime(invTroPayList.get(0).getReceiptDate());
        }
        if ("PO".equals(docCls) && CollUtil.isNotEmpty(purPoPayList = this.rmiPurRpcService.payInfo(id))) {
            totalAmt = purPoPayList.stream().map(PurPoPayRpcDTO::getReceiptAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            payItems = ScpDemandOrderConvert.INSTANCE.purDtosToRespVOS(purPoPayList);
            scpOrderPayRespVO.setItemList(payItems);
            scpOrderPayRespVO.setAmt(totalAmt);
            scpOrderPayRespVO.setPayDateTime(purPoPayList.get(0).getReceiptDate());
        }
        return scpOrderPayRespVO;
    }

    private Map<String, String> buildAddr(String province, String city, String county) {
        HashSet<String> areaCodes = new HashSet<String>();
        areaCodes.add(province);
        areaCodes.add(city);
        areaCodes.add(county);
        SysAreaQueryDTO comCityCodeRpcDtoParam = new SysAreaQueryDTO();
        comCityCodeRpcDtoParam.setAreaCodes(areaCodes);
        List rpcDtos = (List)this.sysAreaRpcService.queryList(comCityCodeRpcDtoParam).getData();
        if (CollUtil.isNotEmpty((Collection)rpcDtos)) {
            return rpcDtos.stream().collect(Collectors.toMap(t -> t.getAreaCode(), t -> t.getAreaName(), (t1, t2) -> t1));
        }
        return new HashMap<String, String>();
    }

    public AppDemandOrderServiceImpl(OrgStoreRpcService orgStoreRpcService, ScpDemandOrderService scpDemandOrderService, ScpDemandOrderDService scpDemandOrderDService, ScpDemandOrderDDomainService scpDemandOrderDDomainService, RmiItemService rmiItemService, CartRedisUtil cartRedisUtil, SysAreaRpcService sysAreaRpcService, RmiSysUDCService rmiSysUDCService, ScpStoreCartService scpStoreCartService, CommonPriceService commonPriceService, RmiInvStkRpcService rmiInvStkRpcService, RmiPurRpcService rmiPurRpcService, MessageQueueTemplate messageQueueTemplate, ScpOrderSettingDomainService scpOrderSettingDomainService, ScpDemandOrderDomainService scpDemandOrderDomainService, RedisUtils redisUtils, MessageDelyQueueService messageDelyQueueService, TransactionCommitHandler transactionCommitHandler, ScpDemandOrderDRepoProc scpDemandOrderDRepoProc, TransactionTemplate transactionTemplate) {
        this.orgStoreRpcService = orgStoreRpcService;
        this.scpDemandOrderService = scpDemandOrderService;
        this.scpDemandOrderDService = scpDemandOrderDService;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
        this.rmiItemService = rmiItemService;
        this.cartRedisUtil = cartRedisUtil;
        this.sysAreaRpcService = sysAreaRpcService;
        this.rmiSysUDCService = rmiSysUDCService;
        this.scpStoreCartService = scpStoreCartService;
        this.commonPriceService = commonPriceService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.rmiPurRpcService = rmiPurRpcService;
        this.messageQueueTemplate = messageQueueTemplate;
        this.scpOrderSettingDomainService = scpOrderSettingDomainService;
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.redisUtils = redisUtils;
        this.messageDelyQueueService = messageDelyQueueService;
        this.transactionCommitHandler = transactionCommitHandler;
        this.scpDemandOrderDRepoProc = scpDemandOrderDRepoProc;
        this.transactionTemplate = transactionTemplate;
    }
}

