/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.stock;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockDownLoadParam;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockDownloadVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageParam;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockSaveVO;
import com.elitesland.scp.application.service.stock.ScpSafetyTargetStockService;
import com.elitesland.scp.utils.excel.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5b89\u5168\u5e93\u5b58&&\u76ee\u6807\u5e93\u5b58"})
@RestController
@RequestMapping(value={"/safetyTarget/stock"}, produces={"application/json"})
@Validated
public class ScpSafetyTargetStockController {
    private static final Logger log = LoggerFactory.getLogger(ScpSafetyTargetStockController.class);
    private final ScpSafetyTargetStockService scpSafetyTargetStockService;

    @ApiOperation(value="\u5b89\u5168\u5e93\u5b58&&\u76ee\u6807\u5e93\u5b58-\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<ScpSafetyTargetStockPageVO>> page(@RequestBody ScpSafetyTargetStockPageParam param) {
        return ApiResult.ok(this.scpSafetyTargetStockService.searchPage(param));
    }

    @ApiOperation(value="\u5b89\u5168\u5e93\u5b58&&\u76ee\u6807\u5e93\u5b58-\u65b0\u589e/\u7f16\u8f91")
    @PostMapping(value={"/save"})
    public ApiResult<String> save(@Valid @RequestBody ScpSafetyTargetStockSaveVO param) {
        return ApiResult.ok((Object)this.scpSafetyTargetStockService.saveSafetyTargetStock(param));
    }

    @ApiOperation(value="\u5b89\u5168\u5e93\u5b58&&\u76ee\u6807\u5e93\u5b58-\u6279\u91cf\u65b0\u589e/\u7f16\u8f91")
    @PostMapping(value={"/batchSave"})
    public ApiResult<?> saveBatch(@Valid @RequestBody List<ScpSafetyTargetStockSaveVO> param) {
        this.scpSafetyTargetStockService.batchSaveSafetyTargetStock(param);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u5b89\u5168\u5e93\u5b58&&\u76ee\u6807\u5e93\u5b58-\u5220\u9664")
    @PostMapping(value={"/delete"})
    public ApiResult<?> delete(@RequestBody List<Long> ids) {
        this.scpSafetyTargetStockService.delete(ids);
        return ApiResult.ok();
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u5bfc\u5165\u6a21\u7248\u4e0b\u8f7d\u5bfc\u51fa")
    public void download(HttpServletResponse response, @RequestBody ScpSafetyTargetStockDownLoadParam param) throws IOException {
        List<ScpSafetyTargetStockDownloadVO> ret = this.scpSafetyTargetStockService.downloadTmplFile(param);
        log.info("mrp\u6807\u51c6\u5e93\u5b58\u4e0b\u8f7d\u6a21\u7248\u6210\u529f\uff0c\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(ret));
        ExcelWriteUtil.autoAliasExcelWrite(response, ret, ScpSafetyTargetStockDownloadVO.class, "\u5b89\u5168\u5e93\u5b58&\u76ee\u7684\u5e93\u5b58\u5bfc\u5165\u6a21\u7248", "\u5b89\u5168\u5e93\u5b58&\u76ee\u7684\u5e93\u5b58\u5bfc\u5165\u6a21\u7248");
    }

    public ScpSafetyTargetStockController(ScpSafetyTargetStockService scpSafetyTargetStockService) {
        this.scpSafetyTargetStockService = scpSafetyTargetStockService;
    }
}

