/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.lakalapay.utils;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.scp.domain.entity.lakalapay.LakalaPayRecordDO;
import com.elitesland.scp.infr.repo.lakalapay.LakalaPayRecordRepo;
import com.elitesland.scp.lakalapay.vo.BalanceResponseVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderParamVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderResponseVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderResultResponseVO;
import com.elitesland.scp.lakalapay.vo.QueryAccountDtlParamVO;
import com.elitesland.scp.lakalapay.vo.QueryBalanceParamVO;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class TcslPay {
    private static final Logger log = LoggerFactory.getLogger(TcslPay.class);
    String host = "http://open-test.tcsl.com.cn/api/";
    String methodName = "yzj/wuuxiangcloudfunds/third/external/payment/checkoutPay";
    String methodName2 = "yzj/wuuxiangcloudfunds/third/external/account/accountDetails";
    String methodName3 = "yzj/wuuxiangcloudfunds/third/external/account/balance/query";
    String methodName4 = "yzj/wuuxiangcloudfunds/third/external/payment/checkoutPay/query";
    String appSecret = "****";
    String appKey = "*****";
    private final LakalaPayRecordRepo lakalaPayRecordRepo;

    @Retryable(value={Exception.class}, maxAttempts=3, backoff=@Backoff(delay=1000L))
    public OnlineLklPayOrderResponseVO pay(OnlineLklPayOrderParamVO payOrderParamVO) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("channelCode", "LklSmb");
        paramsMap.put("outTradeNo", payOrderParamVO.getDocNo());
        paramsMap.put("outTradeTime", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        paramsMap.put("payerAccountNo", payOrderParamVO.getPayerNo());
        paramsMap.put("payerName", payOrderParamVO.getPayerName());
        paramsMap.put("remark", payOrderParamVO.getRemark());
        paramsMap.put("payeeList", payOrderParamVO.getPayeeInfo());
        LakalaPayRecordDO lakalaPayRecordDO = new LakalaPayRecordDO();
        lakalaPayRecordDO.setOutTradeNo(payOrderParamVO.getDocNo());
        lakalaPayRecordDO.setOutTradeTime(LocalDateTime.now());
        lakalaPayRecordDO.setChannelCode("LklSmb");
        lakalaPayRecordDO.setPayResult(false);
        lakalaPayRecordDO.setPayerAccountNo(payOrderParamVO.getPayerNo());
        lakalaPayRecordDO.setPayerName(payOrderParamVO.getPayerName());
        lakalaPayRecordDO.setRemark(payOrderParamVO.getRemark());
        lakalaPayRecordDO.setPayeeList(JSONObject.toJSONString(payOrderParamVO.getPayeeInfo()));
        JSONObject send = this.send(JSONObject.toJSONString(paramsMap), this.methodName);
        lakalaPayRecordDO.setTraceId(send.getString("traceID"));
        lakalaPayRecordDO.setResponseParam(JSONObject.toJSONString((Object)send));
        this.lakalaPayRecordRepo.save(lakalaPayRecordDO);
        return (OnlineLklPayOrderResponseVO)JSONObject.parseObject((String)send.toJSONString(), OnlineLklPayOrderResponseVO.class);
    }

    public JSONObject send(String params, String methodName) {
        this.appSecret = "acwf56s21w75l2mwedhlekbyq6xkd7ek";
        this.appKey = "lyq6zg4tosmk2rjrwngbwlzdbbei9kaq";
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("groupID", "G301705");
        headerMap.put("traceID", UUID.randomUUID().toString());
        headerMap.put("Proxy-Client-IP", "192.168.28.30");
        HashMap<String, String> systemParamsMap = new HashMap<String, String>();
        systemParamsMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        systemParamsMap.put("appKey", this.appKey);
        systemParamsMap.put("version", "1");
        systemParamsMap.put("charset", "UTF-8");
        HashMap<String, String> bizParamsMap = new HashMap<String, String>();
        bizParamsMap.put("biz", params);
        try {
            String urlForGenSig = this.genUrlForGenSig(this.host, methodName, systemParamsMap, bizParamsMap);
            log.info("\u5b8c\u6574url\u8def\u5f84: " + urlForGenSig);
            String sig = this.getSig(this.appSecret, urlForGenSig);
            log.info("Request Body : " + JSONObject.toJSONString((Object)params));
            String response = this.sendRequest(urlForGenSig, sig, headerMap, bizParamsMap);
            log.info("Response Body : " + response);
            JSONObject jsonObject = JSONObject.parseObject((String)response);
            String code = jsonObject.getString("code");
            if (code == null || !code.equals("0")) {
                throw new BusinessException("\u83b7\u53d6\u652f\u4ed8\u94fe\u63a5\u5931\u8d25\uff01" + response);
            }
            JSONObject data = jsonObject.getJSONObject("data");
            Integer returnCode = data.getInteger("returnCode");
            String errorCode = data.getString("errorCode");
            if (returnCode == null || errorCode == null) {
                throw new BusinessException("\u83b7\u53d6\u652f\u4ed8\u94fe\u63a5\u5931\u8d25\uff01" + response);
            }
            if (returnCode != 1 || !errorCode.equals("200")) {
                throw new BusinessException("\u83b7\u53d6\u652f\u4ed8\u94fe\u63a5\u5931\u8d25\uff01" + jsonObject.getString("errMsg"));
            }
            JSONObject data1 = data.getJSONObject("data");
            data1.put("traceID", headerMap.get("traceID"));
            return data1;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public OnlineLklPayOrderResultResponseVO queryResult(String docNo) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("outTradeNo", docNo);
        JSONObject send = this.send(JSONObject.toJSONString(paramsMap), this.methodName4);
        return (OnlineLklPayOrderResultResponseVO)JSONObject.parseObject((String)send.toJSONString(), OnlineLklPayOrderResultResponseVO.class);
    }

    public BalanceResponseVO queryBalance(QueryBalanceParamVO param) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("brandId", param.getBrandId());
        paramsMap.put("accountNo", param.getAccountNo());
        JSONObject send = this.send(JSONObject.toJSONString(paramsMap), this.methodName3);
        return (BalanceResponseVO)JSONObject.parseObject((String)send.toJSONString(), BalanceResponseVO.class);
    }

    public JSONObject queryAccountDtl(QueryAccountDtlParamVO param) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("brandId", param.getBrandId());
        paramsMap.put("accountNo", param.getAccountNo());
        paramsMap.put("startTime", param.getStartTime());
        paramsMap.put("endTime", param.getEndTime());
        JSONObject send = this.send(JSONObject.toJSONString(paramsMap), this.methodName2);
        return send;
    }

    private String sendRequest(String url, String sig, Map<String, String> headersMap, Map<String, String> paramsMap) throws RuntimeException {
        String requestUrl = url + "&sig=" + sig;
        HttpPost httpPost = new HttpPost(requestUrl);
        CloseableHttpResponse response = null;
        try {
            headersMap.forEach((k, v) -> httpPost.addHeader(k, v));
            CloseableHttpClient httpClient = HttpClients.createDefault();
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("Accept", "application/json");
            String requestBody = paramsMap.get("biz");
            httpPost.setEntity((HttpEntity)new StringEntity(requestBody, StandardCharsets.UTF_8));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            httpPost.releaseConnection();
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public String getSig(String appSecret, String baseUrl) {
        try {
            Mac hs256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(appSecret.getBytes("UTF-8"), "HmacSHA256");
            hs256.init(secretKey);
            byte[] bytes = hs256.doFinal(baseUrl.getBytes("UTF-8"));
            return this.toHex(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301HmacSHA256\u7b97\u6cd5", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301utf8\u7f16\u7801", e);
        }
        catch (Exception e) {
            throw new RuntimeException("hs256\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public String toHex(byte[] bytes) {
        StringBuffer hexstr = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() < 2) {
                hexstr.append(0);
            }
            hexstr.append(b);
        }
        return hexstr.toString();
    }

    public String genUrlForGenSig(String host, String methodName, Map<String, String> systemParamsMap, Map<String, String> applicationParamsMap) throws UnsupportedEncodingException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.putAll(systemParamsMap);
        if (applicationParamsMap != null) {
            paramMap.putAll(applicationParamsMap);
        }
        return host + methodName + "?" + this.getSortedParamStr(paramMap);
    }

    public String getSortedParamStr(Map<String, String> params) throws UnsupportedEncodingException {
        TreeSet<String> sortedParams = new TreeSet<String>(params.keySet());
        StringBuilder sortedParamStr = new StringBuilder();
        for (String key : sortedParams) {
            String value = params.get(key);
            if (null == value || "".equals(value) || "sig".equalsIgnoreCase(key) || "biz".equalsIgnoreCase(key)) continue;
            sortedParamStr.append(key + "=" + URLEncoder.encode(value, "UTF-8") + "&");
        }
        return sortedParamStr.substring(0, sortedParamStr.length() - 1);
    }

    public List<BasicNameValuePair> convertToEntity(Map<String, String> applicationParamsMap) throws RuntimeException {
        ArrayList<BasicNameValuePair> formParam = new ArrayList<BasicNameValuePair>();
        try {
            if (applicationParamsMap != null) {
                for (Map.Entry<String, String> entry : applicationParamsMap.entrySet()) {
                    BasicNameValuePair nameValuePair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                    formParam.add(nameValuePair);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("1");
        }
        return formParam;
    }

    public TcslPay(LakalaPayRecordRepo lakalaPayRecordRepo) {
        this.lakalaPayRecordRepo = lakalaPayRecordRepo;
    }
}

