package com.elitesland.scp.application.facade.vo.resp.collect;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("收藏夹返回")
public class ScpUserCollectRespVO implements Serializable {
    private static final long serialVersionUID = -1623254442864140424L;

    @ApiModelProperty("商品SPU-ID编码")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty("商品SPU编码")
    private String spuCode;

    @ApiModelProperty("商品SPU名称")
    private String spuName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("sku商品详情")
    private List<ScpUserCollectRespVO.ItemSpecObjectVO> itemSpecObjectVOS;

    @Data
    public static class ItemSpecObjectVO {

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("单位名称")
        private String uomName;

        @ApiModelProperty("商品ID")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long itemId;

        @ApiModelProperty("商品规格编码(SKU编码)")
        private String itemCode;

        @ApiModelProperty("商品规格名称(SKU名称)")
        private String itemName;

        @ApiModelProperty("箱规")
        private String itemAttrName;

        @ApiModelProperty("含税单价")
        private BigDecimal itemPrice;

        @ApiModelProperty("数量")
        private BigDecimal qty;

        @ApiModelProperty("基本单位")
        private String uom2;
        @ApiModelProperty(value = "基本单位名称")
        private String uom2Name;

        @ApiModelProperty("单位转换系数")
        private BigDecimal uomRatio;

        @ApiModelProperty("有效位数")
        private Integer decimalPlaces;

        @ApiModelProperty(value = "商品分类")
        private String itemType;

        @ApiModelProperty(value = "最小起订量")
        private BigDecimal moq;
    }

    @ApiModelProperty("spu规格型号")
    private String spec;

    @ApiModelProperty("图片url")
    private String url;

    @ApiModelProperty("商品品类编码")
    private String itemCateCode;

    @ApiModelProperty("商品品类名称")
    private String itemCateName;
}
