package com.elitesland.scp.application.facade.vo.resp.order;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("订货集分页返回")
public class ScpDemandOrderPageRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -4607660124307291057L;

    @ApiModelProperty("唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long uniqueId;

    @ApiModelProperty("订货集ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long demandId;

    @ApiModelProperty("订货集编码")
    private String demandCode;

    @ApiModelProperty("订货集名称")
    private String demandName;

    @ApiModelProperty("订货单编码")
    private String docCode;

    @ApiModelProperty("单据类别")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_CLS")
    private String docCls;
    private String docClsName;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-suplan", mod = "DEO_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-suplan", mod = "DEMAND_SET_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("付款状态")
    @SysCode(sys = "yst-suplan", mod = "PAY_STATUS")
    private String payStatus;
    private String payStatusName;

    @ApiModelProperty("需求仓库id/门店id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long demandWhStId;

    @ApiModelProperty("需求仓库编码/门店编码")
    private String demandWhStCode;

    @ApiModelProperty("需求仓库名称/门店名称")
    private String demandWhStName;

    @ApiModelProperty("需求日期")
    private LocalDateTime demandDate;

    @ApiModelProperty("经营性质")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE2")
    private String storeType2;
    private String storeType2Name;

    @ApiModelProperty("订货单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long detailId;

    @ApiModelProperty("来源明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long sourceId;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-suplan", mod = "SUPPLY_DEMAND_TYPE")
    private String supplyType;
    private String supplyTypeName;

    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("需求数量")
    private BigDecimal demandQuantity;

    @ApiModelProperty("汇总需求数量")
    private BigDecimal demandSumQuantity;

    @ApiModelProperty("拆分需求数量")
    private BigDecimal allocationDeQuantity;

    @ApiModelProperty("基本单位")
    private String unit;
    private String unitName;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("汇总含税金额")
    private BigDecimal demandSumAmt;

    @ApiModelProperty("币种，默认CNY")
    private String currency;

    @ApiModelProperty("分配数量")
    private BigDecimal allocationQuantity;

    @ApiModelProperty("计划数量")
    private BigDecimal planQuantity;

    @ApiModelProperty("供应仓库id、供应商id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppWhId;

    @ApiModelProperty("供应仓库编码、供应商编码")
    private String suppWhCode;

    @ApiModelProperty("供应仓库名称、供应商名称")
    private String suppWhName;

    @ApiModelProperty("采购公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("采购公司编码")
    private String ouCode;

    @ApiModelProperty("采购公司名称")
    private String ouName;

    @ApiModelProperty("分配单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;

    @ApiModelProperty("分配单据编码")
    private String srcDocNo;

    @ApiModelProperty("分配单据类别")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String srcDocCls;
    private String srcDocClsName;

    @ApiModelProperty("分配单据明细行号")
    private String srcDocLineNo;

    @ApiModelProperty("发货数量")
    private BigDecimal quantity;

    @ApiModelProperty("是否已分配，true:是，false:否")
    private Boolean isCalculated;

    @ApiModelProperty("是否已推送, true:是，false:是")
    private Boolean isPushed;

    @ApiModelProperty("推送订单信息")
    private String syncMsg;

    @ApiModelProperty("明细备注")
    private String ddRemark;

    @ApiModelProperty("基本单位")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("基本单位数量")
    private BigDecimal qty2;

    @ApiModelProperty("销售公司编码")
    private String saleOuCode;

    @ApiModelProperty("销售公司名称")
    private String saleOuName;

    @ApiModelProperty("是否已评价，true：已评价，false：未评价")
    private Boolean replyFlag;

    @ApiModelProperty("商品图片集合")
    private List<String> itemImgUrls;

}
