package com.elitesland.scp.application.web.app;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreDemandCalendarRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDRespVO;
import com.elitesland.scp.application.service.calendar.ScpStoreDemandCalendarService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.AllArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 门店订货日历 前端控制器
 * </p>
 *
 * @author jeesie.jiang
 * @since 2024-03-28
 */
@RestController
@RequestMapping(value = "/app/storeCalendar", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "移动端-门店订货日历管理接口", tags = {"移动端-门店订货日历管理接口"})
@AllArgsConstructor
public class AppStoreDemandCalendarController {

    private ScpStoreDemandCalendarService scpStoreDemandCalendarService;

    @ApiOperation("订货日历 - 订货日历(小程序端)")
    @PostMapping("/detail/list")
    public ApiResult<List<ScpStoreDemandCalendarRespVO>> page(@RequestBody ScpStoreDemandCalendarParam param) {
        return ApiResult.ok(scpStoreDemandCalendarService.listCalendarVOs(param));
    }


}
