package com.elitesland.scp.domain.entity.order;

import com.elitescloud.boot.jpa.common.PartitionField;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "scp_demand_order")
@org.hibernate.annotations.Table(appliesTo = "scp_demand_order", comment = "订货订单")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "订货订单", description = "订货订单")
@Where(clause = "delete_flag = 0")
public class ScpDemandOrderDO extends BaseModel implements Serializable {

    @ApiModelProperty("订货集ID")
    @Comment("订货集ID")
    @Column()
    private Long demandId;

    @ApiModelProperty("订货集编码")
    @Comment("订货集编码")
    @Column()
    private String demandCode;

    @ApiModelProperty("订货集名称")
    @Comment("订货集名称")
    @Column()
    private String demandName;

    @ApiModelProperty("订货单编码")
    @Comment("订货单编码")
    @Column()
    private String docCode;

    @ApiModelProperty("单据类别")
    @Comment("单据类别")
    @Column()
    private String docCls;

    @ApiModelProperty("单据状态")
    @Comment("单据状态")
    @Column()
    private String docStatus;

    @ApiModelProperty("类型")
    @Comment("类型")
    @Column()
    private String type;

    @ApiModelProperty("需求仓库id/门店id")
    @Comment("需求仓库id/门店id")
    @Column()
    private Long demandWhStId;

    @ApiModelProperty("需求仓库编码/门店编码")
    @Comment("需求仓库编码/门店编码")
    @Column()
    private String demandWhStCode;

    @ApiModelProperty("需求仓库名称/门店名称")
    @Comment("需求仓库名称/门店名称")
    @Column()
    private String demandWhStName;

    @ApiModelProperty("需求日期")
    @Comment("需求日期")
    @Column()
    private LocalDateTime demandDate;

    @ApiModelProperty("经营性质")
    @Comment("经营性质")
    @Column()
    private String storeType2;

    @ApiModelProperty("店面等级")
    @Comment("店面等级")
    @Column()
    private String storeLevel;

    @ApiModelProperty("付款状态")
    @Comment("付款状态")
    @Column()
    private String payStatus;

    @ApiModelProperty("单据类型")
    @Comment("单据类型")
    @Column()
    private String docType;

    @ApiModelProperty("是否已计算")
    @Comment("是否已计算")
    @Column()
    private Boolean isCalculated;

    @ApiModelProperty("是否已推送")
    @Comment("是否已推送")
    @Column()
    private Boolean isPushed;

    @ApiModelProperty("收货地址号")
    @Comment("收货地址号")
    @Column()
    private Long recvAddrNo;

    @ApiModelProperty("收货联系人")
    @Comment("收货联系人")
    @Column()
    private String recvContactName;

    @ApiModelProperty("收货联系电话")
    @Comment("收货联系电话")
    @Column()
    private String recvContactTel;

    @ApiModelProperty("收货国家")
    @Comment("收货国家")
    @Column()
    private String recvCountry;

    @ApiModelProperty("收货省")
    @Comment("收货省")
    @Column()
    private String recvProvince;

    @ApiModelProperty("收货市")
    @Comment("收货市")
    @Column()
    private String recvCity;

    @ApiModelProperty("收货区县")
    @Comment("收货区县")
    @Column()
    private String recvCounty;

    @ApiModelProperty("收货详细地址")
    @Comment("收货详细地址")
    @Column()
    private String recvDetailaddr;

    @ApiModelProperty("是否评价，true已评价，false未评价")
    @Comment("是否评价，true已评价，false未评价")
    @Column()
    private Boolean replyFlag;

    @ApiModelProperty("表分区字段：月")
    @Comment("表分区字段：月")
    @Column(updatable = false)
    @PartitionField(PartitionField.PartitionType.YEAR_MONTH)
    private Integer ym;
}
