/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.mrp;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invIo.InvIoCalcParamRpcDTO;
import com.elitesland.inv.dto.invIo.InvIoCalcRpcDTO;
import com.elitesland.pur.dto.po.PurPoDSaveDTO;
import com.elitesland.pur.dto.po.PurPoRouteParamDTO;
import com.elitesland.pur.dto.po.PurPoRouteRpcDTO;
import com.elitesland.pur.dto.po.PurPoSaveDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitesland.pur.dto.supp.PurSuppBaseRpcParam;
import com.elitesland.pur.provider.PurPoProvider;
import com.elitesland.pur.provider.PurSuppProvider;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpDetailRespVO;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpRespVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.mrp.ScpMrpService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDDO;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDO;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDPlanDO;
import com.elitesland.scp.domain.entity.stock.ScpPredictStStockCalcDO;
import com.elitesland.scp.domain.entity.supalloc.ScpSupplyAllocationDO;
import com.elitesland.scp.domain.service.mrp.ScpMrpDDomainService;
import com.elitesland.scp.domain.service.mrp.ScpMrpDPlanDomainService;
import com.elitesland.scp.domain.service.mrp.ScpMrpDomainService;
import com.elitesland.scp.domain.service.supalloc.ScpSupplyAllocationDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.stock.ScpPredictStStockCalcRepo;
import com.elitesland.scp.infr.repo.stock.ScpPredictStStockRepoProc;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgOuService;
import com.elitesland.scp.rmi.RmiSysUserRpcService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.scp.utils.TransactionCommitHandler;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemUomConvRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.param.ItmItemBusinessRpcDtoParam;
import com.elitesland.support.provider.item.param.ItmItemUomConvRpcDtoParam;
import com.elitesland.support.provider.item.param.ItmItemUomConvRpcOtherParam;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ObjectUtils;

@Service
public class ScpMrpServiceImpl
implements ScpMrpService {
    private static final Logger log = LoggerFactory.getLogger(ScpMrpServiceImpl.class);
    private final ScpMrpDomainService scpMrpDomainService;
    private final ScpMrpDDomainService scpMrpDDomainService;
    private final ScpMrpDPlanDomainService scpMrpDPlanDomainService;
    private final PurPoProvider purPoProvider;
    private final RmiOrgOuService rmiOrgOuService;
    private final ScpPredictStStockCalcRepo scpPredictStStockCalcRepo;
    private final ScpPredictStStockRepoProc scpPredictStStockRepoProc;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final RmiItemService rmiItemService;
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final TransactionCommitHandler transactionCommitHandler;
    private final ScpSupplyAllocationDomainService scpSupplyAllocationDomainService;
    private final TransactionTemplate transactionTemplate;
    private final UdcProvider udcProvider;
    private final PurSuppProvider purSuppProvider;
    @Autowired
    @Qualifier(value="cloudt_taskExecutor")
    private TaskExecutor taskExecutor;

    @Override
    public PagingVO<ScpMrpRespVO> page(ScpMrpPageParam param) {
        List<Long> ids;
        List<ScpMrpDRespVO> scpMrpDRespVOList;
        PagingVO<ScpMrpRespVO> pagingVO = this.scpMrpDomainService.searchPage(param);
        if (pagingVO.isNotEmpty() && CollectionUtil.isNotEmpty(scpMrpDRespVOList = this.scpMrpDDomainService.findByMasIds(ids = pagingVO.getRecords().stream().map(BaseViewModel::getId).collect(Collectors.toList())))) {
            Map<Long, List<ScpMrpDRespVO>> mrpDMap = scpMrpDRespVOList.stream().collect(Collectors.groupingBy(ScpMrpDRespVO::getMasId));
            pagingVO.getRecords().forEach(record -> {
                List scpMrpDRespVOS = (List)mrpDMap.get(record.getId());
                if (CollectionUtil.isNotEmpty((Collection)scpMrpDRespVOS)) {
                    record.setOuName(scpMrpDRespVOS.stream().map(ScpMrpDRespVO::getOuName).distinct().collect(Collectors.joining("\uff1b")));
                }
            });
        }
        return pagingVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            throw new BusinessException("ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ScpMrpDO> scpMrpDOList = this.scpMrpDomainService.findByIds(ids);
        if (CollectionUtil.isEmpty(scpMrpDOList)) {
            throw new BusinessException("MRP\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        List wrongMrpLotNos = scpMrpDOList.stream().filter(mrp -> !ScpUdcEnum.MRP_PUSH_STATUS_NOT.getValueCode().equals(mrp.getPushStatus())).map(ScpMrpDO::getMrpLotNo).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(wrongMrpLotNos)) {
            throw new BusinessException("\u53ea\u80fd\u5220\u9664\u672a\u63a8\u9001\u7684MRP\u8ba1\u5212\uff0c\u8bf7\u68c0\u67e5\uff1a" + String.join((CharSequence)",", wrongMrpLotNos));
        }
        this.scpMrpDomainService.deleteByIds(ids);
        List<ScpMrpDRespVO> scpMrpDRespVOList = this.scpMrpDDomainService.findByMasIds(ids);
        if (CollectionUtil.isNotEmpty(scpMrpDRespVOList)) {
            List<Long> mrpDIds = scpMrpDRespVOList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            List<Long> predIds = scpMrpDRespVOList.stream().map(ScpMrpDRespVO::getRelateDocDid).collect(Collectors.toList());
            this.scpMrpDDomainService.deleteByMasIds(ids);
            if (CollectionUtil.isNotEmpty(mrpDIds)) {
                this.scpMrpDPlanDomainService.deleteByMasIds(mrpDIds);
            }
            this.scpPredictStStockRepoProc.updateMrpFlag(predIds, Boolean.FALSE);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void pushPo(Long id) {
        List resultList;
        if (id == null) {
            throw new BusinessException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ScpMrpDO scpMrpDO = this.scpMrpDomainService.findById(id);
        if (scpMrpDO == null) {
            throw new BusinessException("MRP\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        if (ScpUdcEnum.MRP_PUSH_STATUS_COMPLETE.getValueCode().equals(scpMrpDO.getPushStatus())) {
            throw new BusinessException("MRP\u8ba1\u5212" + scpMrpDO.getMrpLotNo() + "\u5df2\u63a8\u9001\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001");
        }
        List<ScpMrpDetailRespVO> mrpDetailRespVOS = this.scpMrpDDomainService.findDetailByMasId(id);
        if (CollectionUtil.isEmpty(mrpDetailRespVOS)) {
            throw new BusinessException("MRP\u8ba1\u5212" + scpMrpDO.getMrpLotNo() + "\u91c7\u8d2d\u8ba1\u5212\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (CollectionUtil.isEmpty(mrpDetailRespVOS = mrpDetailRespVOS.stream().filter(d -> ScpUdcEnum.MRP_D_PUSH_STATUS_NOT.getValueCode().equals(d.getPushStatus()) || ScpUdcEnum.MRP_D_PUSH_STATUS_FAIL.getValueCode().equals(d.getPushStatus())).collect(Collectors.toList()))) {
            throw new BusinessException("MRP\u8ba1\u5212" + scpMrpDO.getMrpLotNo() + "\u5df2\u63a8\u9001\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001");
        }
        Collection<List<ScpMrpDetailRespVO>> mrpDetailGroup = mrpDetailRespVOS.stream().collect(Collectors.groupingBy(d -> d.getPurOuCode() + d.getSuppCode() + d.getWhCode())).values();
        List<String> purOuCodes = mrpDetailRespVOS.stream().map(ScpMrpDetailRespVO::getPurOuCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouCodeBuIdMap = this.rmiOrgOuService.findOuDtoMapByOuCodes(purOuCodes);
        List suppCodes = mrpDetailRespVOS.stream().map(ScpMrpDetailRespVO::getSuppCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        PurSuppBaseRpcParam purSuppBaseRpcParam = new PurSuppBaseRpcParam();
        purSuppBaseRpcParam.setSuppCodes(suppCodes);
        Map<String, PurSuppBaseRpcDTO> suppMap = ((List)this.purSuppProvider.findBaseRpcDtoByParam(purSuppBaseRpcParam).getData()).stream().collect(Collectors.toMap(PurSuppBaseRpcDTO::getSuppCode, s -> s));
        ArrayList purPoSaveDTOList = new ArrayList();
        mrpDetailGroup.forEach(group -> {
            Collection<List<ScpMrpDetailRespVO>> mrpPlanMap = group.stream().collect(Collectors.groupingBy(ScpMrpDetailRespVO::getItemCode)).values();
            ScpMrpDetailRespVO scpMrpDetailRespVO = (ScpMrpDetailRespVO)group.get(0);
            PurPoSaveDTO purPoSaveDTO = new PurPoSaveDTO();
            purPoSaveDTO.setOuCode(scpMrpDetailRespVO.getPurOuCode());
            purPoSaveDTO.setWhCode(scpMrpDetailRespVO.getWhCode());
            purPoSaveDTO.setSuppCode(scpMrpDetailRespVO.getSuppCode());
            purPoSaveDTO.setPoSource(UdcEnum.PUR_PO_GEN_TYPE_MRP.getValueCode());
            purPoSaveDTO.setSceneTypeCode("001");
            purPoSaveDTO.setBuId(((OrgOuRpcSimpleDTO)ouCodeBuIdMap.get(scpMrpDetailRespVO.getPurOuCode())).getBuId());
            purPoSaveDTO.setAgentEmpId(this.getEmployeeId());
            purPoSaveDTO.setDocStatus("CF");
            purPoSaveDTO.setRelateDocId(scpMrpDetailRespVO.getMasId());
            purPoSaveDTO.setRelateDocNo(scpMrpDetailRespVO.getMrpLotNo());
            purPoSaveDTO.setPaymentStatus("45");
            purPoSaveDTO.setRelateDocCls("MRP");
            PurSuppBaseRpcDTO suppDTO = (PurSuppBaseRpcDTO)suppMap.get(scpMrpDetailRespVO.getSuppCode());
            if (suppDTO == null) {
                throw new BusinessException("\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff1a" + scpMrpDetailRespVO.getSuppCode());
            }
            List purPoDSaveDTOList = mrpPlanMap.stream().map(planList -> {
                PurPoDSaveDTO purPoDSaveDTO = new PurPoDSaveDTO();
                ScpMrpDetailRespVO planVO = (ScpMrpDetailRespVO)planList.get(0);
                purPoDSaveDTO.setItemCode(planVO.getItemCode());
                purPoDSaveDTO.setItemId(planVO.getItemId());
                purPoDSaveDTO.setOuId(planVO.getPurOuId());
                purPoDSaveDTO.setSuppId(planVO.getSuppId());
                purPoDSaveDTO.setCurrCode(suppDTO.getCurrCode());
                purPoDSaveDTO.setQty(planList.stream().map(ScpMrpDetailRespVO::getPurQty).reduce(BigDecimal.ZERO, BigDecimal::add));
                purPoDSaveDTO.setUom(planVO.getPurUom());
                purPoDSaveDTO.setRelateDocId(scpMrpDetailRespVO.getMasId());
                purPoDSaveDTO.setRelateDocNo(scpMrpDetailRespVO.getMrpLotNo());
                purPoDSaveDTO.setRelateDocDid(scpMrpDetailRespVO.getDId());
                purPoDSaveDTO.setRelateDocCls("MRP");
                return purPoDSaveDTO;
            }).collect(Collectors.toList());
            purPoSaveDTO.setPurPoDCreateParamVOList(purPoDSaveDTOList);
            purPoSaveDTOList.add(purPoSaveDTO);
        });
        try {
            ApiResult apiResult = this.purPoProvider.createBatch(purPoSaveDTOList);
            if (apiResult.isFailed() || CollectionUtil.isEmpty((Collection)((Collection)apiResult.getData()))) {
                throw new BusinessException("MRP\u8ba1\u5212\u63a8\u9001\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25\uff1a" + apiResult.getMsg());
            }
            resultList = (List)apiResult.getData();
        }
        catch (Exception e) {
            String pushFailReason = e.getMessage().length() > 100 ? e.getMessage().substring(0, 100) : e.getMessage();
            List<Long> planIds = mrpDetailRespVOS.stream().map(ScpMrpDetailRespVO::getPlanId).collect(Collectors.toList());
            this.scpMrpDPlanDomainService.updatePushStatus(planIds, ScpUdcEnum.MRP_D_PUSH_STATUS_FAIL.getValueCode(), null, null, null, pushFailReason);
            this.scpMrpDomainService.updatePushStatus(id, ScpUdcEnum.MRP_D_PUSH_STATUS_FAIL.getValueCode(), pushFailReason);
            return;
        }
        Map<String, List<ScpMrpDetailRespVO>> detailMap = mrpDetailRespVOS.stream().collect(Collectors.groupingBy(d -> d.getPurOuCode() + d.getSuppCode() + d.getWhCode() + d.getItemCode()));
        resultList.forEach(po -> po.getPurPoDCreateParamVOList().forEach(pod -> {
            List<Long> planIds = ((List)detailMap.get(po.getOuCode() + po.getSuppCode() + po.getWhCode() + pod.getItemCode())).stream().map(ScpMrpDetailRespVO::getPlanId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(planIds)) {
                this.scpMrpDPlanDomainService.updatePushStatus(planIds, ScpUdcEnum.MRP_D_PUSH_STATUS_SUCCESS.getValueCode(), po.getDocNo(), pod.getId(), pod.getLineNo(), null);
            }
        }));
        this.scpMrpDomainService.updatePushStatus(id, ScpUdcEnum.MRP_PUSH_STATUS_COMPLETE.getValueCode(), null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void compute(Long predId) {
        if (predId == null) {
            throw new BusinessException("\u9884\u6d4b\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Optional predCalcOptional = this.scpPredictStStockCalcRepo.findById(predId);
        if (predCalcOptional.isEmpty()) {
            throw new BusinessException("\u9884\u6d4b\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ScpPredictStStockCalcDO predCalcDO = (ScpPredictStStockCalcDO)predCalcOptional.get();
        List<ScpPredictStStockRespVO> predList = this.scpPredictStStockRepoProc.findByMasIdAndMrpFlag(predId, false);
        if (CollectionUtil.isEmpty(predList)) {
            throw new BusinessException("\u8be5\u9884\u6d4b\u6279\u6b21\u660e\u7ec6\u5df2\u8ba1\u7b97\u5b8c\u6210\uff0c\u8bf7\u68c0\u67e5");
        }
        String mrpLotNo = this.rmiSysUserRpcService.sysNumberRuleGenerateCode("MRP", new ArrayList<String>());
        ScpMrpDO scpMrpDO = new ScpMrpDO();
        scpMrpDO.setMrpLotNo(mrpLotNo);
        scpMrpDO.setPredLotNo(predCalcDO.getPredLotNo());
        scpMrpDO.setPushStatus(ScpUdcEnum.MRP_PUSH_STATUS_NOT.getValueCode());
        scpMrpDO.setCalcStatus(ScpUdcEnum.MRP_CALC_STATUS_PROCESS.getValueCode());
        ScpMrpDO scpMrpResult = this.scpMrpDomainService.save(scpMrpDO);
        this.transactionCommitHandler.handle(() -> CompletableFuture.runAsync(() -> {
            this.transactionTemplate.setPropagationBehavior(3);
            this.transactionTemplate.execute(transactionStatus -> {
                try {
                    this.computeAndSaveDetail(predList, scpMrpResult);
                    this.scpMrpDomainService.updateCalcStatus(List.of(scpMrpResult.getId()), ScpUdcEnum.MRP_CALC_STATUS_SUCCESS.getValueCode(), null);
                }
                catch (Exception e) {
                    log.info("MRP\u8ba1\u5212\u660e\u7ec6\u8ba1\u7b97\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    this.scpMrpDomainService.updateCalcStatus(List.of(scpMrpResult.getId()), ScpUdcEnum.MRP_CALC_STATUS_FAIL.getValueCode(), e.getMessage().length() > 100 ? e.getMessage().substring(0, 100) : e.getMessage());
                }
                return "OK";
            });
        }, (Executor)this.taskExecutor));
    }

    private void computeAndSaveDetail(List<ScpPredictStStockRespVO> predList, ScpMrpDO scpMrpDO) {
        log.info("\u8ba1\u7b97\u5e76\u4fdd\u5b58MRP\u8ba1\u5212\u660e\u7ec6\u548c\u91c7\u8d2d\u8ba1\u5212\uff0c\u9884\u6d4b\u5e93\u5b58\uff1a{}\uff0cMRP\u8ba1\u5212\uff1a{}", (Object)JSONObject.toJSONString(predList), (Object)JSONObject.toJSONString((Object)scpMrpDO));
        LocalDateTime dateTo = LocalDateTime.now();
        LocalDateTime dateFrom = dateTo.minusMonths(1L);
        Integer qtyPlace = SysUtils.getQtyPlace();
        Map uomMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
        List itemIds = predList.stream().map(ScpPredictStStockRespVO::getItemId).distinct().collect(Collectors.toList());
        ItmItemBaseRpcParam itemParam = new ItmItemBaseRpcParam();
        itemParam.setItemIds(itemIds);
        List<ItmItemBaseRpcDTO> itemList = this.rmiItemService.findItemBaseRpcDtoByParam(itemParam);
        if (CollectionUtil.isEmpty(itemList)) {
            throw new BusinessException("\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        Map<Long, ItmItemBaseRpcDTO> itemMap = itemList.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getId, c -> c));
        List ouCodes = predList.stream().map(ScpPredictStStockRespVO::getOuCode).distinct().collect(Collectors.toList());
        ItmItemBusinessRpcDtoParam businessParam = new ItmItemBusinessRpcDtoParam();
        businessParam.setItemIds(itemIds);
        businessParam.setBuCodes(ouCodes);
        Map<String, ItmItemBusinessRpcDTO> businessMap = this.rmiItemService.findItmItemBusinessByParam(businessParam).stream().collect(Collectors.toMap(t -> t.getBuCode() + t.getItemCode(), t -> t));
        Map<Long, BigDecimal> uomConvMap = this.getUomConvMap(itemList);
        Map<Long, BigDecimal> purRouteMap = this.getPurRouteMap(predList, dateFrom, dateTo);
        Map<Long, InvIoCalcRpcDTO> invIoCalcMap = this.getInvIoCalcMap(predList, dateFrom, dateTo);
        Set<String> allocationConcatKeys = predList.stream().map(pred -> pred.getWhCode() + pred.getItemCode()).collect(Collectors.toSet());
        Map<String, List<ScpSupplyAllocationDO>> allocationMap = this.scpSupplyAllocationDomainService.findByConcatKeys(allocationConcatKeys).stream().collect(Collectors.groupingBy(d -> d.getStoreWhCode() + d.getItemCode()));
        List<ScpMrpDDO> scpMrpDDOList = new ArrayList<ScpMrpDDO>();
        ArrayList<ScpMrpDPlanDO> scpMrpDPlanDOList = new ArrayList<ScpMrpDPlanDO>();
        for (ScpPredictStStockRespVO d2 : predList) {
            List<ScpSupplyAllocationDO> allocationList;
            ScpMrpDDO scpMrpDDO = new ScpMrpDDO();
            scpMrpDDO.setMasId(scpMrpDO.getId());
            scpMrpDDO.setRelateDocDid(d2.getId());
            scpMrpDDO.setOuId(d2.getOuId());
            scpMrpDDO.setOuCode(d2.getOuCode());
            scpMrpDDO.setOuName(d2.getOuName());
            scpMrpDDO.setWhId(d2.getWhId());
            scpMrpDDO.setWhCode(d2.getWhCode());
            scpMrpDDO.setWhName(d2.getWhName());
            scpMrpDDO.setItemId(d2.getItemId());
            scpMrpDDO.setItemCode(d2.getItemCode());
            scpMrpDDO.setItemName(d2.getItemName());
            scpMrpDDO.setPredSafetyQty(d2.getPredSafetyQty());
            scpMrpDDO.setPredTargetQty(d2.getPredTargetQty());
            scpMrpDDO.setUom(d2.getPlanUom());
            scpMrpDDO.setUomName((String)uomMap.get(d2.getPlanUom()));
            scpMrpDDO.setIoQty(d2.getIoQty());
            scpMrpDDO.setUomRatio(d2.getUomRatio());
            scpMrpDDO.setSalQty(d2.getIoQty().divide(d2.getUomRatio(), (int)qtyPlace, RoundingMode.HALF_UP));
            ItmItemBaseRpcDTO item = itemMap.get(d2.getItemId());
            if (item == null) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1\u4e0d\u5b58\u5728\uff1a" + d2.getItemCode());
            }
            ItmItemBusinessRpcDTO itemBusiness = businessMap.get(d2.getOuCode() + d2.getItemCode());
            if (itemBusiness == null) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ecf\u8425\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u516c\u53f8\uff1a" + d2.getOuCode() + ",\u5546\u54c1\uff1a" + d2.getItemCode());
            }
            scpMrpDDO.setPurLeadTime(BigDecimal.valueOf(itemBusiness.getPurAheadPeriod().intValue()));
            scpMrpDDO.setExpectArriveDate(dateTo.plusDays(itemBusiness.getPurAheadPeriod().intValue()));
            scpMrpDDO.setItemName(item.getItemName());
            scpMrpDDO.setStdInvTurnover(BigDecimal.valueOf(30L).divide(BigDecimal.valueOf(itemBusiness.getPurDelivPeriod().intValue()), 2, RoundingMode.HALF_UP));
            BigDecimal uomRatio = item.getUom().equals(item.getUom4()) ? BigDecimal.ONE : uomConvMap.get(d2.getItemId());
            scpMrpDDO.setMoq(itemBusiness.getMoq());
            if (uomRatio == null) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1\u5355\u4f4d\u8f6c\u5316\u7387\u4e0d\u5b58\u5728\uff1a" + d2.getItemCode());
            }
            InvIoCalcRpcDTO invIoCalcRpcDTO = invIoCalcMap.get(d2.getId());
            if (invIoCalcRpcDTO != null) {
                scpMrpDDO.setInvQty(invIoCalcRpcDTO.getInvQty().multiply(uomRatio).setScale((int)qtyPlace, RoundingMode.HALF_UP));
                scpMrpDDO.setBeforeQty(invIoCalcRpcDTO.getBeforeInvQty());
                BigDecimal avgQty = scpMrpDDO.getBeforeQty().add(invIoCalcRpcDTO.getInvQty()).divide(BigDecimal.valueOf(2L), 8, RoundingMode.HALF_UP);
                if (avgQty.compareTo(BigDecimal.ZERO) == 0) {
                    scpMrpDDO.setInvTurnover(BigDecimal.ZERO);
                } else {
                    scpMrpDDO.setInvTurnover(scpMrpDDO.getIoQty().divide(avgQty, (int)qtyPlace, RoundingMode.HALF_UP));
                }
            } else {
                scpMrpDDO.setInvQty(BigDecimal.ZERO);
                scpMrpDDO.setInvTurnover(BigDecimal.ZERO);
            }
            scpMrpDDO.setPurTransitQty(purRouteMap.getOrDefault(d2.getId(), BigDecimal.ZERO).multiply(uomRatio).setScale((int)qtyPlace, RoundingMode.HALF_UP));
            BigDecimal grossDemand = scpMrpDDO.getPredSafetyQty().add(scpMrpDDO.getPredTargetQty()).subtract(scpMrpDDO.getInvQty());
            if (grossDemand.compareTo(BigDecimal.ZERO) <= 0) {
                scpMrpDDO.setGrossDemand(BigDecimal.ZERO);
                scpMrpDDO.setNetDemand(BigDecimal.ZERO);
            } else if (scpMrpDDO.getMoq() == null) {
                scpMrpDDO.setGrossDemand(grossDemand);
                scpMrpDDO.setNetDemand(scpMrpDDO.getGrossDemand().subtract(scpMrpDDO.getPurTransitQty()));
            } else {
                scpMrpDDO.setGrossDemand(grossDemand.divide(scpMrpDDO.getMoq(), 0, RoundingMode.UP).multiply(scpMrpDDO.getMoq()).setScale((int)qtyPlace, RoundingMode.HALF_UP));
                scpMrpDDO.setNetDemand(scpMrpDDO.getGrossDemand().subtract(scpMrpDDO.getPurTransitQty()));
            }
            scpMrpDDOList.add(scpMrpDDO);
            if (scpMrpDDO.getNetDemand().compareTo(BigDecimal.ZERO) <= 0 || CollectionUtil.isEmpty(allocationList = allocationMap.get(d2.getWhCode() + d2.getItemCode()))) continue;
            allocationList.forEach(allocation -> {
                ScpMrpDPlanDO scpMrpDPlanDO = new ScpMrpDPlanDO();
                scpMrpDPlanDO.setMasId(d2.getId());
                scpMrpDPlanDO.setMrpId(scpMrpDDO.getMasId());
                scpMrpDPlanDO.setOuId(allocation.getOuId());
                scpMrpDPlanDO.setOuCode(allocation.getOuCode());
                scpMrpDPlanDO.setOuName(allocation.getOuName());
                scpMrpDPlanDO.setSuppId(allocation.getSuppId());
                scpMrpDPlanDO.setSuppCode(allocation.getSuppCode());
                scpMrpDPlanDO.setSuppName(allocation.getSuppName());
                scpMrpDPlanDO.setPushStatus(ScpUdcEnum.MRP_D_PUSH_STATUS_NOT.getValueCode());
                scpMrpDPlanDO.setQty(scpMrpDDO.getNetDemand().multiply(allocation.getAllocation().divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP)));
                scpMrpDPlanDOList.add(scpMrpDPlanDO);
            });
        }
        scpMrpDDOList = this.scpMrpDDomainService.save(scpMrpDDOList);
        if (!CollectionUtil.isEmpty(scpMrpDPlanDOList)) {
            Map<Long, Long> mrpDMap = scpMrpDDOList.stream().collect(Collectors.toMap(ScpMrpDDO::getRelateDocDid, BaseModel::getId));
            scpMrpDPlanDOList.forEach(plan -> plan.setMasId((Long)mrpDMap.get(plan.getMasId())));
            this.scpMrpDPlanDomainService.saveDO(scpMrpDPlanDOList);
        }
        this.scpPredictStStockRepoProc.updateMrpFlag(predList.stream().map(BaseViewModel::getId).collect(Collectors.toList()), Boolean.TRUE);
    }

    private Map<Long, BigDecimal> getUomConvMap(List<ItmItemBaseRpcDTO> itemList) {
        List uomConvDParams = itemList.stream().map(item -> {
            ItmItemUomConvRpcOtherParam convParam = new ItmItemUomConvRpcOtherParam();
            convParam.setItemId(item.getId());
            convParam.setFromUom(item.getUom());
            convParam.setToUom(item.getUom4());
            return convParam;
        }).collect(Collectors.toList());
        ItmItemUomConvRpcDtoParam uomConvParam = new ItmItemUomConvRpcDtoParam();
        uomConvParam.setOtherParam(uomConvDParams);
        List<ItmItemUomConvRpcDTO> uomConvList = this.rmiItemService.findItemUomConvDtoByParam(uomConvParam);
        if (CollectionUtil.isEmpty(uomConvList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1\u5355\u4f4d\u8f6c\u5316\u7387\u67e5\u8be2\u5931\u8d25");
        }
        return uomConvList.stream().collect(Collectors.toMap(ItmItemUomConvRpcDTO::getItemId, ItmItemUomConvRpcDTO::getRatio));
    }

    @NotNull
    private Map<Long, BigDecimal> getPurRouteMap(List<ScpPredictStStockRespVO> predList, LocalDateTime dateFrom, LocalDateTime dateTo) {
        List purRouteParams = predList.stream().map(pred -> {
            PurPoRouteParamDTO purPoRouteParamDTO = new PurPoRouteParamDTO();
            purPoRouteParamDTO.setId(pred.getId());
            purPoRouteParamDTO.setOuId(pred.getOuId());
            purPoRouteParamDTO.setWhId(pred.getWhId());
            purPoRouteParamDTO.setItemId(pred.getItemId());
            purPoRouteParamDTO.setDateFrom(dateFrom);
            purPoRouteParamDTO.setDateTo(dateTo);
            return purPoRouteParamDTO;
        }).collect(Collectors.toList());
        List purRouteList = this.purPoProvider.findRouteInfo(purRouteParams);
        return purRouteList.stream().collect(Collectors.toMap(PurPoRouteRpcDTO::getId, PurPoRouteRpcDTO::getRouteQty));
    }

    private Map<Long, InvIoCalcRpcDTO> getInvIoCalcMap(List<ScpPredictStStockRespVO> predList, LocalDateTime dateFrom, LocalDateTime dateTo) {
        List<InvIoCalcParamRpcDTO> invIoCalcParams = predList.stream().map(pred -> {
            InvIoCalcParamRpcDTO paramDTO = new InvIoCalcParamRpcDTO();
            paramDTO.setId(pred.getId());
            paramDTO.setOuId(pred.getOuId());
            paramDTO.setWhId(pred.getWhId());
            paramDTO.setItemId(pred.getItemId());
            paramDTO.setDateFrom(dateFrom);
            paramDTO.setDateTo(dateTo);
            paramDTO.setSceneCodes(List.of("SO_OUT", "SO_LOGIC_DELIVERY", "SO_LOGIC_RECEIPT", "SO_RETURN", "TRN003", "TRN004", "TRN008", "TRN_RELEASE _ISSUE", "TRN007"));
            return paramDTO;
        }).collect(Collectors.toList());
        List<InvIoCalcRpcDTO> invIoCalcList = this.rmiInvStkRpcService.calcIoByMrp(invIoCalcParams);
        return invIoCalcList.stream().collect(Collectors.toMap(InvIoCalcRpcDTO::getId, c -> c));
    }

    private Long getEmployeeId() {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        log.info("\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)currentUserDTO));
        if (ObjectUtils.isEmpty((Object)currentUserDTO) || currentUserDTO.getDetail() == null) {
            throw new BusinessException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u7528\u6237\u5931\u8d25");
        }
        return currentUserDTO.getDetail().getEmployeeId();
    }

    public ScpMrpServiceImpl(ScpMrpDomainService scpMrpDomainService, ScpMrpDDomainService scpMrpDDomainService, ScpMrpDPlanDomainService scpMrpDPlanDomainService, PurPoProvider purPoProvider, RmiOrgOuService rmiOrgOuService, ScpPredictStStockCalcRepo scpPredictStStockCalcRepo, ScpPredictStStockRepoProc scpPredictStStockRepoProc, RmiInvStkRpcService rmiInvStkRpcService, RmiItemService rmiItemService, RmiSysUserRpcService rmiSysUserRpcService, TransactionCommitHandler transactionCommitHandler, ScpSupplyAllocationDomainService scpSupplyAllocationDomainService, TransactionTemplate transactionTemplate, UdcProvider udcProvider, PurSuppProvider purSuppProvider) {
        this.scpMrpDomainService = scpMrpDomainService;
        this.scpMrpDDomainService = scpMrpDDomainService;
        this.scpMrpDPlanDomainService = scpMrpDPlanDomainService;
        this.purPoProvider = purPoProvider;
        this.rmiOrgOuService = rmiOrgOuService;
        this.scpPredictStStockCalcRepo = scpPredictStStockCalcRepo;
        this.scpPredictStStockRepoProc = scpPredictStStockRepoProc;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.rmiItemService = rmiItemService;
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.transactionCommitHandler = transactionCommitHandler;
        this.scpSupplyAllocationDomainService = scpSupplyAllocationDomainService;
        this.transactionTemplate = transactionTemplate;
        this.udcProvider = udcProvider;
        this.purSuppProvider = purSuppProvider;
    }
}

