package com.elitesland.scp.application.facade.vo.param.order;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Auther: Mark
 * @Date: 2024/5/10 17:02
 * @Description:
 */
@Data
@ExcelIgnoreUnannotated
public class ScpDemandOrderImportEntity implements Serializable {
    private static final long serialVersionUID = -8040142312464325406L;

    public Integer rowNo;

    @ExcelProperty(value = "序号", index = 1)
    private String seqNo;

    @ApiModelProperty("订货集名称")
    private String demandSetName;

    @ApiModelProperty("单据类型名称")
    private String docTypeName;

    @ApiModelProperty("需求仓库/门店编码")
    private String demandWhStCode;

    @ApiModelProperty("需求仓库/门店名称")
    private String demandWhStName;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("需求数量")
    private BigDecimal demandQuantity;

}
