package com.elitesland.scp.application.facade.vo.resp.authority;


import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 计划员权限分配VO
 * @author : wz
 * @date : 2024-3-18
 */
@Data
@ApiModel(value = "计划员权限分配", description = "计划员权限分配")
public class ScpManAuthorityPageRespVO implements Serializable {
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /** 计划员id */
    @ApiModelProperty(name = "计划员id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long scpsmanId ;

    /** 计划员编码 */
    @ApiModelProperty(name = "计划员编码")
    private String scpsmanNo ;

    /** 计划员姓名 */
    @ApiModelProperty(name = "计划员姓名")
    private String scpsman ;

    /** 公司id */
    @ApiModelProperty(name = "公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId ;

    /** 公司名称 */
    @ApiModelProperty(name = "公司名称")
    private String ouName ;

    /** 公司编码 */
    @ApiModelProperty(name = "公司编码")
    private String ouCode ;

    /** 启用状态 */
    @ApiModelProperty(name = "启用状态")
    private Boolean enableStatus ;

    /** 启用状态翻译*/
    @ApiModelProperty(name = "启用状态翻译")
    private String enableStatusName ;

    /** 所属租户ID */
    @ApiModelProperty(name = "所属租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId ;

    /** 所属组织ID */
    @ApiModelProperty(name = "所属组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long belongOrgId ;

    /** 租户组织ID */
    @ApiModelProperty(name = "租户组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantOrgId ;

    /** 备注 */
    @ApiModelProperty(name = "备注")
    private String remark ;

    /** 公司所属组织id */
    @ApiModelProperty(name = "公司所属组织id")
    private Long orgIdBelong ;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long detailId;

    /** 主表id */
    @ApiModelProperty(name = "主表id")
    private Long masId ;

    /** 类型 */
    @ApiModelProperty(name = "类型")
    @JsonSerialize(using = ToStringSerializer.class)
    @SysCode(sys = "yst-suplan", mod = "SCPSMAN_AUTHORITY_TYPE")
    private int type ;
    private String typeName;

    /** 门店id/仓库id */
    @ApiModelProperty(name = "门店id/仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long stWhId;

    /**
     * 门店编码/仓库编码
     */
    @ApiModelProperty(name = "门店编码/仓库编码")
    private String stWhCode;

    /**
     * 门店名称/仓库名称
     */
    @ApiModelProperty(name = "门店名称/仓库名称")
    private String stWhName;

//    @SysCode(sys = "yst-supp", mod = "REGION")
    @ApiModelProperty("区域")
    private String region;
    @ApiModelProperty("区域名称")
    private String regionName;

}