package com.elitesland.scp.application.service.stock;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.stock.*;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 02月 08日 18:22
 * @version: 1.0
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class ScpPredictStStockExportServiceImpl implements DataExport<ScpPredictStStockRespVO, ScpPredictStStockParamVO> {

    private final ScpPredictStStockService scpPredictStStockService;
    private final ScpPredictStStockCalcService scpPredictStStockCalcService;


    @Override
    public String getTmplCode() {
        return "predict_st_stock_export";
    }

    @Override
    public PagingVO<ScpPredictStStockRespVO> executeExport(ScpPredictStStockParamVO param) {
        return scpPredictStStockCalcService.stStockDetailPage(param);
    }
}
