package com.elitesland.scp.application.web.app.activity;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemSpecParamVO;
import com.elitesland.scp.application.facade.vo.param.app.CommonItemPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemActivityRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemSpecRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmSpuRespVO;
import com.elitesland.scp.application.service.app.AppItemActivityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.concurrent.ExecutionException;


@Slf4j
@Api(tags = "移动端-商品")
@RestController
@RequestMapping(value = "/app/activity", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class AppItemActivityController {

    private final AppItemActivityService appItemActivityService;

    @PostMapping("/query")
    @ApiOperation("商品橱窗 - 商品展示（我常订）")
    public ApiResult<PagingVO<AppItemActivityRespVO>> query(@RequestBody @Validated AppItemActivityParamVO paramVO) throws Exception {
        log.info("[APP-SCP-ACTIVITY] query  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(appItemActivityService.query(paramVO));
    }

    @PostMapping("/list")
    @ApiOperation("商品列表 - 商品列表")
    public ApiResult<PagingVO<AppItmItemPageVO>> queryList(@RequestBody @Validated AppItemPageParamVO paramVO) throws ExecutionException, InterruptedException {
        log.info("[APP-SCP-ITEMlIST] query  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(appItemActivityService.itemPage(paramVO));
    }

    @PostMapping("/specQuery")
    @ApiOperation("商品列表 - 多规格查询")
    public ApiResult<AppItemSpecRespVO> specQuery(@RequestBody @Validated AppItemSpecParamVO paramVO) {
        log.info("[APP-SCP-SPECQUERY] query  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(appItemActivityService.specQuery(paramVO));
    }

    @PostMapping("/findIdOne")
    @ApiOperation("商品 - 商品详情")
    public ApiResult<AppItmSpuRespVO> findIdOne(@RequestBody @Validated AppItemSpecParamVO paramVO) {
        log.info("[APP-SCP-FINDID] query  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(appItemActivityService.findIdOne(paramVO));
    }

    @PostMapping("/common/list")
    @ApiOperation("商品列表 - 公共商品列表")
    public ApiResult<PagingVO<AppItmItemPageVO>> commonItemPage(@RequestBody @Validated CommonItemPageParamVO paramVO) {
        log.info("[APP-SCP-ITEMlIST] commonItemPage  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(appItemActivityService.commonItemPage(paramVO));
    }

}
