package com.elitesland.scp.application.web.order;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderTemplatePageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpOrderTemplatePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpOrderTemplateRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpOrderTemplateSaveVO;
import com.elitesland.scp.application.service.order.ScpOrderTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Api(tags = "订货集模版接口")
@RestController
@RequestMapping(value = "/order/template", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpOrderTemplateController {
    private final ScpOrderTemplateService scpOrderTemplateService;

    @ApiOperation("增加或者更新订货集")
    @PostMapping("/addOrUpdate")
    public ApiResult<List<Long>> addOrUpdate(@RequestBody List<ScpOrderTemplateSaveVO> scpOrderTemplateSaveVOS) {
        return ApiResult.ok(scpOrderTemplateService.addOrUpdate(scpOrderTemplateSaveVOS));
    }
    @ApiOperation("删除订货集")
    @PostMapping("/delete")
    public ApiResult delete(@RequestParam Long id) {
        scpOrderTemplateService.delete(id);
        return ApiResult.ok();
    }
    @ApiOperation("查询订货集")
    @PostMapping("/query")
    public ApiResult<ScpOrderTemplateRespVO> query(@RequestBody ScpOrderTemplateSaveVO id) {
        return ApiResult.ok(scpOrderTemplateService.query(id.getId()));
    }
    @ApiOperation("分页查询")
    @PostMapping("/pageQuery")
    public ApiResult<PagingVO<ScpOrderTemplatePageRespVO>> page(@RequestBody ScpOrderTemplatePageParamVO scpOrderTemplatePageParamVO) {
        return ApiResult.ok(scpOrderTemplateService.page(scpOrderTemplatePageParamVO));
    }
}
