package com.elitesland.scp.domain.convert.order;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.scp.application.facade.vo.cart.OrderConfirmRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDMgmtRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDMgmtSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.dto.order.ScpDemandOrderDRpcDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2024/03/18
 */
@Mapper(config = BaseMapperConfig.class)
public interface ScpDemandOrderDConvert {
    ScpDemandOrderDConvert INSTANCE = Mappers.getMapper(ScpDemandOrderDConvert.class);

    ScpDemandOrderDRespVO dtoToRespVO(ScpDemandOrderDDTO orderDDTO);

    List<ScpDemandOrderDRespVO> doToRespVO(List<ScpDemandOrderDDO> orderDDOS);

    ScpDemandOrderDDO saveVoToDO(ScpDemandOrderDSaveVO saveVO);

    List<ScpDemandOrderDDO> saveVoListToDOList(List<ScpDemandOrderDSaveVO> saveVOList);

    ScpDemandOrderDSaveVO rpcDtoToSaveVO(ScpDemandOrderDRpcDTO rpcDTO);

    ScpDemandOrderDDTO doToDto(ScpDemandOrderDDO orderDO);

    ScpDemandOrderDMgmtRespVO.SupplyItem dtoToSupplyItem(ScpDemandOrderDDTO orderDDTO);

    ScpDemandOrderDMgmtRespVO dtoToMgmtRespVO(ScpDemandOrderDDTO orderDDTO);

    List<ScpDemandOrderDMgmtRespVO> dtosToMgmtRespVOS(List<ScpDemandOrderDDTO> orderDDTOS);

    ScpDemandOrderDSaveVO mgmtSaveVoToSaveVo(ScpDemandOrderDMgmtSaveVO.SupplyItem mgmtSaveVO);

    ScpDemandOrderDSaveVO respVoToSaveVo(ScpDemandOrderDRespVO respVO);

    List<ScpDemandOrderDSaveVO> respsVosToSaveVos(List<ScpDemandOrderDRespVO> respVOS);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void copySaveParamToDo(ScpDemandOrderDSaveVO saveVO, @MappingTarget ScpDemandOrderDDO intentDO);

}
