package com.elitesland.scp.application.facade.vo.save.order;

import com.el.coordinator.core.common.jpa.entiry.Comment;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;

@Data
@ApiModel("订货集模版保存参数")
public class ScpOrderTemplateSaveVO implements Serializable {
    @ApiModelProperty("主表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("模板类型")
    private String type;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("应用门店代码")
    private String storeCode;

    @ApiModelProperty("应用门店名称")
    private String storeName;

    @ApiModelProperty("所属区域")
    private String regionCode;

    @ApiModelProperty("订单截至时间点")
    private LocalTime deadlineTime;

    @ApiModelProperty("开始日期")
    private LocalDate startDate;

    @ApiModelProperty("结束日期")
    private LocalDate endDate;

    @ApiModelProperty("是否启用")
    private Integer isActive;

}
