package com.elitesland.scp.application.service.collect;

import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectCancelVO;
import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectParamVO;
import com.elitesland.scp.application.facade.vo.resp.collect.ScpUserCollectRespVO;
import com.elitesland.scp.application.facade.vo.save.collect.ScpUserCollectSaveVO;

import java.util.List;

public interface ScpUserCollectService {

    /**
     * 获取收藏列表
     * @param paramVO
     * @return
     */
    List<ScpUserCollectRespVO> getUserList(ScpUserCollectParamVO paramVO);

    /**
     * 添加收藏
     * @param saveVO 收藏参数
     */
    Long add(ScpUserCollectSaveVO saveVO);

    /**
     * 根据spuId取消收藏
     * @param cancelVO
     * @return Boolean
     */
    Boolean deleteBySpuIdAndUid(ScpUserCollectCancelVO cancelVO);
}
