package com.elitesland.scp.infr.repo.mrp;

import com.elitesland.scp.domain.entity.mrp.ScpMrpDPlanDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface ScpMrpDPlanRepo extends JpaRepository<ScpMrpDPlanDO, Long>, QuerydslPredicateExecutor<ScpMrpDPlanDO> {

    List<ScpMrpDPlanDO> findByMasId(Long masId);

    List<ScpMrpDPlanDO> findByMasIdIn(List<Long> masIds);

    @Modifying(clearAutomatically = true)
    @Transactional(rollbackFor = Exception.class)
    @Query(value = "delete from scp_mrp_d_plan where mas_id in ?1 ", nativeQuery = true)
    void deleteByMasIds(List<Long> masIds);
}
