package com.elitesland.scp.pay.controller;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.pay.service.AccountBatchBindService;
import com.elitesland.scp.pay.vo.AccountBindParamVO;
import com.tenpay.business.entpay.mse.sdk.api.AccountBatchBind;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@Slf4j
@RestController
@RequestMapping("/bind")
@RequiredArgsConstructor
public class AccountBatchBindController {

    private final AccountBatchBindService accountBatchBindService;

    @ApiOperation(value = "批量绑定微企付账户")
    @PostMapping("/create")
    @BusinessObjectOperation(operationType = OperationTypeEnum.ELSE, operationDescription = "批量绑定微企付账户", allowRepeatRequest = false)
    public ApiResult<Object> createAccountBind(HttpServletRequest request, @RequestBody @Validated AccountBindParamVO param) {
        log.info("批量绑定微企付账户请求参数：{}", JSONUtil.toJsonStr(param));
        accountBatchBindService.accountBind(param);
        return ApiResult.ok();
    }

    @ApiOperation(value = "查询批量账号绑定申请结果(外单号)")
    @GetMapping(value = "/out-request-no/{outRequestNo}")
    public ApiResult<AccountBatchBind> bingExternalQuery(@PathVariable("outRequestNo") String outRequestNo) throws EntpayException {
        log.debug("查询批量账号绑定申请结果(外单号)请求参数：{}", outRequestNo);
        return ApiResult.ok(AccountBatchBind.retrieveByOutRequestNo(outRequestNo));
    }
}
