/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.lakalapay.service;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayParamDTO;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayRpcDTO;
import com.elitesland.pur.dto.po.PurPoOnlinePayParamDTO;
import com.elitesland.pur.dto.po.PurPoOnlinePayRpcDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderPayMqParam;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderUpdatePayStatusMqParam;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountRepoProc;
import com.elitesland.scp.lakalapay.service.LklPaymentService;
import com.elitesland.scp.lakalapay.service.SignManager;
import com.elitesland.scp.lakalapay.utils.SignType;
import com.elitesland.scp.lakalapay.utils.SignUtil;
import com.elitesland.scp.lakalapay.utils.TcslPay;
import com.elitesland.scp.lakalapay.vo.BalanceResponseVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderParamVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderResponseVO;
import com.elitesland.scp.lakalapay.vo.OnlineLklPayOrderResultResponseVO;
import com.elitesland.scp.lakalapay.vo.QueryAccountDtlParamVO;
import com.elitesland.scp.lakalapay.vo.QueryBalanceParamVO;
import com.elitesland.scp.pay.service.AccountLinkService;
import com.elitesland.scp.pay.service.NotifyVerifyService;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiPurRpcService;
import com.elitesland.scp.utils.MessageDelyQueueService;
import com.elitesland.support.provider.org.dto.OrgBankRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuBankRpcDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class LklPaymentServiceImpl
implements LklPaymentService {
    private static final Logger log = LoggerFactory.getLogger(LklPaymentServiceImpl.class);
    private final NotifyVerifyService notifyVerifyService;
    private final RedisWrapper redisWrapper;
    private final RedisUtils redisUtils;
    private final RmiPurRpcService rmiPurRpcService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final AccountLinkService accountLinkService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc;
    private final MessageDelyQueueService messageDelyQueueService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final OrgOuRpcService orgOuRpcService;
    private final TenantDataIsolateProvider tenantDataIsolateProvider;
    private final TransactionTemplate transactionTemplate;
    private final RedisTemplate<Object, Object> redisTemplate;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;
    private final TcslPay tcslPay;

    @Override
    public OnlineLklPayOrderResponseVO createMpPayOnline(OnlineLklPayOrderParamVO param) {
        try {
            String docCls = param.getDocNo().substring(0, 2);
            String docNo = param.getDocNo();
            OnlineLklPayOrderResultResponseVO onlineLklPayOrderResultResponseVO = this.tcslPay.queryResult(docNo);
            if (onlineLklPayOrderResultResponseVO != null && onlineLklPayOrderResultResponseVO.getResultCode().equals("0") && onlineLklPayOrderResultResponseVO.getPayState().equals("success")) {
                throw new BusinessException("\u8ba2\u5355\u5df2\u652f\u4ed8");
            }
            OnlineLklPayOrderResponseVO onlineLklPayOrderResponseVO = this.buildPayItems(param, docCls);
            if (onlineLklPayOrderResponseVO != null) {
                return onlineLklPayOrderResponseVO;
            }
            this.buildPaymentMapParam(param);
            OnlineLklPayOrderResponseVO pay = this.tcslPay.pay(param);
            if (pay == null || pay.getPayUrl() == null) {
                throw new BusinessException("\u83b7\u53d6\u652f\u4ed8\u94fe\u63a5\u5931\u8d25");
            }
            ScpOrderUpdatePayStatusMqParam updateParamVO = new ScpOrderUpdatePayStatusMqParam();
            updateParamVO.setBusinessKey("scp_order_update_pay_status");
            updateParamVO.setDocNo(param.getDocNo());
            updateParamVO.setPaymentId(pay.getTradeNo());
            updateParamVO.setAmt(param.getAmt());
            updateParamVO.setPayerName(param.getPayerName());
            updateParamVO.setDocCls(docCls);
            this.messageQueueTemplate.publishMessageSync("yst-suplan", "scp_order_update_pay_status", (Serializable)updateParamVO);
            this.redisUtils.set("SCP_ONLINE_PAY:" + docNo, (Object)JSONUtil.toJsonStr((Object)pay), 25L, TimeUnit.HOURS);
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime expireTime = now.plusDays(1L);
            Duration duration = Duration.between(now, expireTime);
            this.messageDelyQueueService.resettingOrderExpireTime("SCP_ONLINE_PAY:" + docNo, duration.toMillis());
            return pay;
        }
        catch (Exception e) {
            throw new BusinessException("\u62c9\u5361\u62c9\u652f\u4ed8\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public BalanceResponseVO queryBalance(QueryBalanceParamVO param) {
        try {
            List bankByStoreCode = this.orgStoreRpcService.findBankByStoreCode(param.getStoreCode());
            if (bankByStoreCode == null || bankByStoreCode.isEmpty()) {
                throw new BusinessException("\u95e8\u5e97[" + param.getStoreCode() + "]\u672a\u7ed1\u5b9a\u94f6\u884c\u4fe1\u606f");
            }
            Optional<OrgBankRpcDTO> orgBankRpcDTO = bankByStoreCode.stream().filter(bank -> bank.getOpenBank().equals("\u62c9\u5361\u62c9")).findAny();
            if (orgBankRpcDTO.isEmpty()) {
                throw new BusinessException("\u95e8\u5e97[" + param.getStoreCode() + "]\u672a\u7ed1\u5b9a\u62c9\u5361\u62c9\u94f6\u884c\u4fe1\u606f");
            }
            OrgBankRpcDTO orgBankRpcDTO1 = orgBankRpcDTO.get();
            param.setAccountNo(orgBankRpcDTO1.getCardNo());
            param.setBrandId(10L);
            return this.tcslPay.queryBalance(param);
        }
        catch (Exception e) {
            throw new BusinessException("\u62c9\u5361\u62c9\u4f59\u989d\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
    }

    @Override
    public JSONObject queryAccountDtl(QueryAccountDtlParamVO param) {
        try {
            param.setAccountNo("2600100100000159478");
            param.setBrandId(10L);
            return this.tcslPay.queryAccountDtl(param);
        }
        catch (Exception e) {
            throw new BusinessException("\u62c9\u5361\u62c9\u8d22\u52a1\u660e\u7ec6\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
    }

    private OnlineLklPayOrderResponseVO buildPayItems(OnlineLklPayOrderParamVO param, String docCls) {
        OnlineLklPayOrderResponseVO onlineLklPayOrderResponseVO = new OnlineLklPayOrderResponseVO();
        Object obj = this.redisUtils.get("SCP_ONLINE_PAY:" + param.getDocNo());
        OnlineLklPayOrderParamVO.PayeeInfoVO payeeInfoVO = new OnlineLklPayOrderParamVO.PayeeInfoVO();
        payeeInfoVO.setSubTradeAmount("" + param.getAmt().setScale(2, RoundingMode.HALF_UP));
        List ouBank = this.orgOuRpcService.findOuBank(param.getOuId());
        if (ouBank == null || ouBank.isEmpty()) {
            throw new BusinessException("\u9500\u552e\u65b9\u672a\u7ed1\u5b9a\u94f6\u884c\u5361");
        }
        Optional<OrgOuBankRpcDTO> in = ouBank.stream().filter(a -> a.getAccType().equals("IN")).findAny();
        if (in.isEmpty()) {
            throw new BusinessException("\u9500\u552e\u65b9\u672a\u7ed1\u5b9a\u94f6\u884c\u5361");
        }
        OrgOuBankRpcDTO orgOuBankRpcDTO = in.get();
        payeeInfoVO.setPayeeAccountNo(orgOuBankRpcDTO.getBankAcc());
        payeeInfoVO.setPayeeName(orgOuBankRpcDTO.getHolderName());
        payeeInfoVO.setSubOutTradeNo(param.getDocNo());
        param.setPayeeInfo(List.of(payeeInfoVO));
        if ("PO".equals(docCls)) {
            PurPoOnlinePayRpcDTO onlinePayInfo = this.rmiPurRpcService.findOnlinePayInfo(param.getDocId());
            if (onlinePayInfo == null) {
                throw new BusinessException("\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                throw new BusinessException("\u8ba2\u5355\u5df2\u652f\u4ed8");
            }
            if (obj != null && !onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                onlineLklPayOrderResponseVO = (OnlineLklPayOrderResponseVO)JSONObject.parseObject((String)((String)obj), OnlineLklPayOrderResponseVO.class);
                return onlineLklPayOrderResponseVO;
            }
        } else {
            InvTroOnlinePayRpcDTO onlinePayInfo = this.rmiInvStkRpcService.findOnlinePayInfo(param.getDocId());
            if (onlinePayInfo == null) {
                throw new BusinessException("\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                throw new BusinessException("\u8ba2\u5355\u5df2\u652f\u4ed8");
            }
            if (obj != null && !onlinePayInfo.getOnlinePayFlag().booleanValue()) {
                onlineLklPayOrderResponseVO = (OnlineLklPayOrderResponseVO)JSONObject.parseObject((String)((String)obj), OnlineLklPayOrderResponseVO.class);
                return onlineLklPayOrderResponseVO;
            }
        }
        return null;
    }

    private void buildPaymentMapParam(OnlineLklPayOrderParamVO param) {
        List bankByStoreCode = this.orgStoreRpcService.findBankByStoreCode(param.getStoreCode());
        if (bankByStoreCode == null || bankByStoreCode.isEmpty()) {
            throw new BusinessException("\u95e8\u5e97[" + param.getStoreCode() + "]\u672a\u7ed1\u5b9a\u94f6\u884c\u4fe1\u606f");
        }
        Optional<OrgBankRpcDTO> orgBankRpcDTO = bankByStoreCode.stream().filter(bank -> bank.getOpenBank().equals("\u62c9\u5361\u62c9")).findAny();
        if (orgBankRpcDTO.isEmpty()) {
            throw new BusinessException("\u95e8\u5e97[" + param.getStoreCode() + "]\u672a\u7ed1\u5b9a\u62c9\u5361\u62c9\u94f6\u884c\u4fe1\u606f");
        }
        OrgBankRpcDTO orgBankRpcDTO1 = orgBankRpcDTO.get();
        param.setPayerName(orgBankRpcDTO1.getName());
        param.setPayerNo(orgBankRpcDTO1.getCardNo());
        param.setPayerType(orgBankRpcDTO1.getType());
    }

    @Override
    public String paymentNotify(String bytes) throws JSONException {
        log.info("\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u6570\u636e\uff1a{}", (Object)JSONUtil.toJsonStr((Object)bytes));
        byte[] bytes1 = Base64.decodeBase64((String)bytes);
        Map map = (Map)JSON.parseObject((byte[])bytes1, Map.class, (Feature[])new Feature[0]);
        log.info("\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u6570\u636e\u89e3\u6790\uff1a{}", (Object)JSONUtil.toJsonStr((Object)map));
        String sign = (String)map.get("sign");
        map.remove("sign");
        SignManager signManager = new SignManager();
        signManager.setSignType(SignType.HMACSHA256);
        Map<String, Object> signData = signManager.buildRequestPara(map);
        signData.remove(signManager.getSignTypeName());
        String localSign = SignUtil.getSignHmacSHA256(signData, "\u9700\u8981\u52a0\u5165\u79d8\u94a5");
        if (!sign.equals(localSign)) {
            return "\u7b7e\u540d\u9519\u8bef";
        }
        String data = (String)map.get("data");
        Map result = (Map)JSON.parseObject((String)data, Map.class);
        String docNo = (String)result.get("outTradeNo");
        String tradeNo = (String)result.get("tradeNo");
        String tradeAmount = (String)result.get("tradeAmount");
        String paySuccessTime = (String)result.get("paySuccessTime");
        this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            TenantContextHolder.setCurrentTenant((SysTenantDTO)TenantClient.getSessionTenant());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            if ("PO".equals(docNo.substring(0, 2))) {
                PurPoOnlinePayParamDTO purPoOnlinePayParamDTO = new PurPoOnlinePayParamDTO();
                purPoOnlinePayParamDTO.setOnlinePayFlag(Boolean.TRUE);
                purPoOnlinePayParamDTO.setDocNo(docNo);
                purPoOnlinePayParamDTO.setOnlinePayTime(LocalDateTime.parse(paySuccessTime, formatter));
                this.rmiPurRpcService.updateOnlinePay(purPoOnlinePayParamDTO);
            } else {
                InvTroOnlinePayParamDTO invTroOnlinePayParamDTO = new InvTroOnlinePayParamDTO();
                invTroOnlinePayParamDTO.setDocNo(docNo);
                invTroOnlinePayParamDTO.setOnlinePayTime(LocalDateTime.parse(paySuccessTime, formatter));
                invTroOnlinePayParamDTO.setOnlinePayFlag(Boolean.TRUE);
                this.rmiInvStkRpcService.updateOnlinePay(invTroOnlinePayParamDTO);
            }
            String key = "SCP_ONLINE_PAY:" + docNo;
            if (this.redisTemplate.delete((Object)key).booleanValue()) {
                this.messageDelyQueueService.remove(key);
                this.transactionTemplate.setPropagationBehavior(3);
                this.transactionTemplate.execute(transactionStatus -> {
                    try {
                        this.scpDemandOrderDRepoProc.updatePayStatusBySrcDocId(docNo, ScpUdcEnum.PAY_STATUS_PAYING.getValueCode());
                        return "ok";
                    }
                    catch (Exception e) {
                        log.error("\u66f4\u65b0\u8981\u8d27\u5355\u51fa\u9519:{}", (Object)e.getMessage(), (Object)e);
                        transactionStatus.setRollbackOnly();
                        return "ok";
                    }
                });
                ScpOrderPayMqParam orderSubmitMqParam = new ScpOrderPayMqParam();
                orderSubmitMqParam.setSrcDocNo(docNo);
                orderSubmitMqParam.setFlowNo(tradeNo);
                orderSubmitMqParam.setBusinessKey("scp_order_pay");
                orderSubmitMqParam.setPayDateTime(LocalDateTime.parse(paySuccessTime, formatter));
                BigDecimal amt = new BigDecimal(tradeAmount).setScale(2, RoundingMode.HALF_UP);
                orderSubmitMqParam.setRealRecAmt(amt);
                this.messageQueueTemplate.publishMessageSync("yst-suplan", "scp_order_pay", (Serializable)orderSubmitMqParam);
            } else {
                log.error("\u4e0d\u80fd\u91cd\u590d\u8c03\u7528\u652f\u4ed8\u56de\u8c03");
            }
            return "";
        }, "6008");
        return "SUCCESS";
    }

    public LklPaymentServiceImpl(NotifyVerifyService notifyVerifyService, RedisWrapper redisWrapper, RedisUtils redisUtils, RmiPurRpcService rmiPurRpcService, RmiInvStkRpcService rmiInvStkRpcService, AccountLinkService accountLinkService, MessageQueueTemplate messageQueueTemplate, ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc, MessageDelyQueueService messageDelyQueueService, OrgStoreRpcService orgStoreRpcService, OrgOuRpcService orgOuRpcService, TenantDataIsolateProvider tenantDataIsolateProvider, TransactionTemplate transactionTemplate, RedisTemplate<Object, Object> redisTemplate, ScpDemandOrderDRepoProc scpDemandOrderDRepoProc, TcslPay tcslPay) {
        this.notifyVerifyService = notifyVerifyService;
        this.redisWrapper = redisWrapper;
        this.redisUtils = redisUtils;
        this.rmiPurRpcService = rmiPurRpcService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.accountLinkService = accountLinkService;
        this.messageQueueTemplate = messageQueueTemplate;
        this.scpWqfEntAccountRepoProc = scpWqfEntAccountRepoProc;
        this.messageDelyQueueService = messageDelyQueueService;
        this.orgStoreRpcService = orgStoreRpcService;
        this.orgOuRpcService = orgOuRpcService;
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
        this.transactionTemplate = transactionTemplate;
        this.redisTemplate = redisTemplate;
        this.scpDemandOrderDRepoProc = scpDemandOrderDRepoProc;
        this.tcslPay = tcslPay;
    }
}

