/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.rmi;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invIo.InvIoCalcParamRpcDTO;
import com.elitesland.inv.dto.invIo.InvIoCalcRpcDTO;
import com.elitesland.inv.dto.invTro.InvTroDRpcDTO;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayParamDTO;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayRpcDTO;
import com.elitesland.inv.dto.invTro.InvTroPayRpcDTO;
import com.elitesland.inv.dto.invstk.InvStkMpQueryRpcParam;
import com.elitesland.inv.dto.invstk.InvStkQueryRpcParam;
import com.elitesland.inv.dto.invstk.InvStkQueryRpcResult;
import com.elitesland.inv.dto.invstk.InvStkStoreMpRpcDTO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcDTO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcParam;
import com.elitesland.inv.dto.invwh.InvWhDetailRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.provider.InvIoProvider;
import com.elitesland.inv.provider.InvStkProvider;
import com.elitesland.inv.provider.InvTroProvider;
import com.elitesland.inv.provider.InvWhProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RmiInvStkRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiInvStkRpcService.class);
    private final InvStkProvider invStkProvider;
    private final InvWhProvider invWhProvider;
    private final InvTroProvider invTroProvider;
    private final InvIoProvider invIoProvider;

    public List<InvStkQueryRpcResult> queryInvStk(InvStkQueryRpcParam param) {
        log.info("\u67e5\u8be2\u5e93\u5b58\u53ef\u7528\u91cf\u5217\u8868\u5165\u53c2\uff1a" + JSON.toJSONString((Object)param));
        List invStkList = this.invStkProvider.queryInvStk(param);
        log.info("\u67e5\u8be2\u5e93\u5b58\u53ef\u7528\u91cf\u5217\u8868\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)invStkList));
        return invStkList;
    }

    public List<InvWhDetailRpcDTO> findWhAreaDTOByParam(InvWhRpcDtoParam param) {
        log.info("\u67e5\u8be2\u4ed3\u5e93\u53ca\u5e93\u533a\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)param));
        ApiResult whAreaDTOByParam = this.invWhProvider.findWhAreaDTOByParam(param);
        if (!whAreaDTOByParam.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u4ed3\u5e93\u53ca\u5e93\u533a\u4fe1\u606f:" + whAreaDTOByParam.getMsg());
        }
        return (List)whAreaDTOByParam.getData();
    }

    public ApiResult<List<InvWhRpcDTO>> findWhDTOByParam(InvWhRpcDtoParam param) {
        try {
            log.info("\u67e5\u8be2\u4ed3\u5e93\u8868\u5934\u7684\u63a5\u53e3\u5165\u53c2\uff1a\u3010{}\u3011", (Object)JSON.toJSONString((Object)param));
            return this.invWhProvider.findWhDTOByParam(param);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4ed3\u5e93\u8868\u5934\u5f02\u5e38:{0}", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u4ed3\u5e93\u8868\u5934\u7684\u63a5\u53e3\u5f02\u5e38" + e);
        }
    }

    public Map<Long, InvWhRpcSimpleDTO> findInvWhBaseMap(List<Long> whIds) {
        log.info("\u67e5\u8be2\u4ed3\u5e93\u8868\u5934\u7684\u63a5\u53e3\u5165\u53c2\uff1a\u3010{}\u3011", (Object)JSON.toJSONString(whIds));
        if (CollUtil.isEmpty(whIds)) {
            return new HashMap<Long, InvWhRpcSimpleDTO>();
        }
        ApiResult result = this.invWhProvider.querySimple(whIds);
        if (!result.isSuccess()) {
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u4ed3\u5e93\u8868\u5934\u7684\u63a5\u53e3\u5f02\u5e38" + result.getMsg());
        }
        return ((List)result.getData()).stream().collect(Collectors.toMap(InvWhRpcSimpleDTO::getWhId, Function.identity()));
    }

    public Map<String, InvWhRpcSimpleDTO> findInvWhBaseMapByCode(List<String> whCodes) {
        log.info("\u67e5\u8be2\u4ed3\u5e93\u8868\u5934\u7684\u63a5\u53e3\u5165\u53c2\uff1a\u3010{}\u3011", (Object)JSON.toJSONString(whCodes));
        if (CollUtil.isEmpty(whCodes)) {
            return new HashMap<String, InvWhRpcSimpleDTO>();
        }
        ApiResult result = this.invWhProvider.findSimpleWhByWhCodes(whCodes);
        if (!result.isSuccess()) {
            throw new BusinessException(ApiCode.FAIL, "\u67e5\u8be2\u4ed3\u5e93\u8868\u5934\u7684\u63a5\u53e3\u5f02\u5e38" + result.getMsg());
        }
        return ((List)result.getData()).stream().collect(Collectors.toMap(InvWhRpcSimpleDTO::getWhCode, Function.identity()));
    }

    public InvWhRpcSimpleDTO findSimpleWhByCode(String whCode) {
        log.info("\u67e5\u8be2\u4ed3\u5e93\u8868\u5934\u7684\u63a5\u53e3\u5165\u53c2\uff1a\u3010{}\u3011", (Object)JSON.toJSONString((Object)whCode));
        ApiResult simpleWhByWhCodes = this.invWhProvider.findSimpleWhByWhCodes(List.of(whCode));
        if (!simpleWhByWhCodes.isSuccess() || CollUtil.isEmpty((Collection)((Collection)simpleWhByWhCodes.getData()))) {
            throw new BusinessException("\u67e5\u8be2\u4ed3\u5e93\u8868\u5934\u7684\u63a5\u53e3\u5f02\u5e38" + simpleWhByWhCodes.getMsg());
        }
        return (InvWhRpcSimpleDTO)((List)simpleWhByWhCodes.getData()).get(0);
    }

    public List<InvTroPayRpcDTO> payInfo(Long id) {
        ApiResult payInfoByTroId = this.invTroProvider.findPayInfoByTroId(id);
        if (!payInfoByTroId.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u8c03\u62e8\u8ba2\u5355\u652f\u4ed8\u4fe1\u606f\u5f02\u5e38:" + payInfoByTroId.getMsg());
        }
        return (List)payInfoByTroId.getData();
    }

    public List<InvTroDRpcDTO> findTroDByTroId(Long troId) {
        ApiResult payInfoByTroId = this.invTroProvider.findTroDByMasId(troId);
        if (!payInfoByTroId.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u8c03\u62e8\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38:" + payInfoByTroId.getMsg());
        }
        return (List)payInfoByTroId.getData();
    }

    public void updateOnlinePay(InvTroOnlinePayParamDTO payParamDTO) {
        try {
            this.invTroProvider.updateOnlinePay(payParamDTO);
        }
        catch (Exception e) {
            throw new BusinessException("\u66f4\u65b0\u5728\u7ebf\u652f\u4ed8\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public InvTroOnlinePayRpcDTO findOnlinePayInfo(Long troId) {
        InvTroOnlinePayRpcDTO onlinePayInfo = this.invTroProvider.findOnlinePayInfo(troId);
        log.info("\u67e5\u8be2\u8c03\u62e8\u8ba2\u5355:{},\u652f\u4ed8\u4fe1\u606f:{}", (Object)troId, (Object)JSONUtil.toJsonStr((Object)onlinePayInfo));
        return onlinePayInfo;
    }

    public PagingVO<InvStkStoreMpRpcDTO> queryStoreMpInvStkMap(InvStkMpQueryRpcParam param) {
        PagingVO invStkStoreMpRpcDTOS = this.invStkProvider.queryStoreMpInvStk(param);
        log.info("\u67e5\u8be2\u5e93\u5b58\u53ef\u7528\u91cf\u5217\u8868\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)invStkStoreMpRpcDTOS));
        return invStkStoreMpRpcDTOS;
    }

    public void closeTro(List<Long> ids) {
        try {
            this.invTroProvider.closeTro(ids);
        }
        catch (Exception e) {
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u57df\uff1a\u5173\u95ed\u8c03\u62e8\u8ba2\u5355\u5f02\u5e38" + e.toString());
        }
    }

    public List<InvWhItemTotalStkRpcDTO> queryInvWhItemTotalStk(InvWhItemTotalStkRpcParam param) {
        log.info("\u67e5\u8be2\u5e93\u5b58\u53ef\u7528\u91cf[queryInvWhItemTotalStk]\u5165\u53c2\uff1a" + JSON.toJSONString((Object)param));
        List invStkList = this.invStkProvider.queryInvWhItemTotalStk(param);
        log.info("\u67e5\u8be2\u5e93\u5b58\u53ef\u7528\u91cf[queryInvWhItemTotalStk]\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)invStkList));
        return invStkList;
    }

    public List<InvIoCalcRpcDTO> calcIoByMrp(List<InvIoCalcParamRpcDTO> param) {
        log.info("MRP\u8ba1\u5212\u8ba1\u7b97\u5e93\u5b58\u6d41\u6c34\u5f00\u59cb\uff1a" + JSON.toJSONString(param));
        ApiResult result = this.invIoProvider.calcByMrp(param);
        if (!result.isSuccess()) {
            throw new BusinessException("MRP\u8ba1\u5212\u8ba1\u7b97\u5e93\u5b58\u6d41\u6c34:" + result.getMsg());
        }
        log.info("MRP\u8ba1\u5212\u8ba1\u7b97\u5e93\u5b58\u6d41\u6c34\u7ed3\u675f\uff1a" + JSON.toJSONString((Object)result.getData()));
        return (List)result.getData();
    }

    public RmiInvStkRpcService(InvStkProvider invStkProvider, InvWhProvider invWhProvider, InvTroProvider invTroProvider, InvIoProvider invIoProvider) {
        this.invStkProvider = invStkProvider;
        this.invWhProvider = invWhProvider;
        this.invTroProvider = invTroProvider;
        this.invIoProvider = invIoProvider;
    }
}

