package com.elitesland.scp.application.facade.vo.resp.mrp;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("物料需求计划明细")
public class ScpMrpDetailRespVO extends BaseViewModel implements Serializable {

    private static final long serialVersionUID = 3251813376174611086L;

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("mrp批次")
    private String mrpLotNo;

    @ApiModelProperty("预测批次")
    private String predLotNo;

    @ApiModelProperty("明细id")
    private Long dId;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("仓库id")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("预测安全库存")
    private BigDecimal predSafetyQty;

    @ApiModelProperty("预测目标库存")
    private BigDecimal predTargetQty;

    @ApiModelProperty("在库数")
    private BigDecimal invQty;

    @ApiModelProperty("毛需求")
    private BigDecimal grossDemand;

    @ApiModelProperty("采购在途数量")
    private BigDecimal purTransitQty;

    @ApiModelProperty("最小起订量")
    private BigDecimal moq;

    @ApiModelProperty("采购提前期")
    private BigDecimal purLeadTime;

    @ApiModelProperty("预期到货日期")
    private LocalDateTime expectArriveDate;

    @ApiModelProperty("库存周转率")
    private BigDecimal invTurnover;

    @ApiModelProperty("标准库存周转率")
    private BigDecimal stdInvTurnover;

    @ApiModelProperty("净需求")
    private BigDecimal netDemand;

    @ApiModelProperty("推送状态")
    @SysCode(sys = "yst-suplan", mod = "MRP_D_PUSH_STATUS")
    private String pushStatus;
    private String pushStatusName;

    @ApiModelProperty("采购计划Id")
    private Long planId;

    @ApiModelProperty("采购公司id")
    private Long purOuId;

    @ApiModelProperty("采购公司编码")
    private String purOuCode;

    @ApiModelProperty("采购公司名称")
    private String purOuName;

    @ApiModelProperty("供应商id")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("采购计划数量")
    private BigDecimal purQty;

    @ApiModelProperty("采购计划单位")
    private String purUom;

    @ApiModelProperty("采购订单号")
    private String poNo;

    @ApiModelProperty("采购订单行号")
    private Integer poLineNo;

    @ApiModelProperty("推送失败原因")
    private String pushFailReason;
}
