package com.elitesland.scp.application.facade.vo.stock;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-01-15
* @Version 1.0
**/

@Data
@ApiModel("目标库存安全库存返回")
public class ScpSafetyTargetStockPageVO extends BaseViewModel  implements Serializable {

    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty(value = "仓库编码")
    private String whCode;

    @ApiModelProperty(value = "仓库名称")
    private String whName;

    @ApiModelProperty(value = "商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "安全库存")
    private BigDecimal safetyQty;

    @ApiModelProperty(value = "安全库存")
    private BigDecimal targetQty;

    @ApiModelProperty(value = "计划单位")
    private String planUom;
    @ApiModelProperty(value = "计划单位名")
    private String planUomName;

    @ApiModelProperty(value = "库存类型")
    private String limit1;

    @ApiModelProperty(value = "商品类型2名称")
    private String itemType2;
    private String itemType2Name;

    @ApiModelProperty(value = "商品类型2名称")
    private String itemCateCode;
    private String itemCateCodeName;

    @ApiModelProperty(value = "品牌")
    private String brand;
    private String brandName;










}