package com.elitesland.scp.application.out.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.comm.service.ComPaymentTermProviderService;
import com.elitescloud.cloudt.comm.vo.resp.ComPaymentTermRespVO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.cacheable.SysCacheSettingRpcService;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.*;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysTaxRateRespDTO;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRateRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysTaxRateRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcSaveParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitescloud.cloudt.system.service.SysUserService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.*;


/**
 * @author feng
 * @program: yst-pur
 * @description:
 * @date 2022-03-17 11:02:58
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class SystemDubboServiceImpl implements SystemDubboService {

    private final SeqNumProvider sysNumberRuleService;
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final UdcProvider udcProvider;
    private final SysCurrencyRpcService currencyRpcService;
    private final SysTaxRateRpcService taxRateRpcService;
    private final SysCurrencyRateRpcService currencyRateRpcService;
    private final SysAreaRpcService areaRpcService;
    private final SysUserRpcService sysUserRpcService;
    private final ComPaymentTermProviderService comPaymentTermService;
    private final SysUserService sysUserService;
    private final UserRpcService userRpcService;
    private final EmployeeRpcService employeeRpcService;
    private final SysCacheSettingRpcService sysCacheSettingRpcService;

    @Override
    public String generateCode(String ruleCode, List<String> runtimeValues) {
        val code = sysNumberRuleService.generateCode("yst-purc",ruleCode, runtimeValues);
        if (Objects.isNull(code)) {
            log.error("调用发号器异常,发号器编码未生成,规则:" + ruleCode);
            throw new BusinessException(ApiCode.FAIL, "调用发号器异常,发号器编码未生成,规则:" + ruleCode);
        }
        return code;
    }

    @Override
    public List<String> generateCode(String ruleCode, List<String> runtimeValues, Integer num) {
        List<String> codes = sysNumberRuleService.generateCode("yst-purc", ruleCode, runtimeValues, num);
        if (CollectionUtils.isEmpty(codes)) {
            log.error("调用发号器异常,发号器编码未生成,规则:" + ruleCode);
            throw new BusinessException(ApiCode.FAIL, "调用发号器异常,发号器编码未生成,规则:" + ruleCode);
        }
        return codes;
    }

    @Override
    public List<Long> findUserIdsByFlowRoles(Long ouId, String customParams) {
        log.info("通过ouId,自定义参数获取用户列表，时间：{}，入参：{}", LocalDateTime.now(), ouId);
        try {
            SysUserIdFlowRoleRpcParam param = new SysUserIdFlowRoleRpcParam();
            param.setOuIds(Collections.singletonList(ouId));
            List<String> newStr = new ArrayList<>();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(customParams)){
                String[] sp = customParams.split(";");
                Collections.addAll(newStr,sp);
            }
            param.setFlowRoleCodes(newStr);
            List<Long> userIds = sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
            if (!CollectionUtils.isEmpty(userIds)) {
                return userIds;
            }
        } catch (Exception e) {
            log.error("findUserIdsByFlowRoles error:", e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> sysUdcGetCodeMap(String domain, String udc) {
        try {
            return udcProvider.getValueMapByUdcCode(domain, udc);
        } catch (Exception e) {
            log.error("sysUdcGetCodeMap error:", e);
        }
        return Maps.newHashMap();
    }

    @Override
    public SysUserDTO sysUserCurrent() {
        try {
            GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
            if (userDetails == null) {
                return null;
            }
            SysUserDTO sysUserDTO = userDetails.getUser();
            if (sysUserDTO == null) {
                return null;
            }
            return sysUserDTO;
        } catch (Exception e) {
            log.error("sysUserCurrent error:", e);
        }
        return null;
    }

    /**
     * 22.01
     *
     * @param ids
     * @return
     */
    @Override
    public List<SysUserRpcDTO> findUserByUserIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.EMPTY_LIST;
        }
        try {
            SysUserRpcDtoParam param = new SysUserRpcDtoParam();
            param.setUserIds(ids);
            List<SysUserRpcDTO> sysUserRpcDTOList = sysUserRpcService.findUserRpcDtoByParam(param);
            if (CollectionUtils.isEmpty(sysUserRpcDTOList)){
                return Collections.EMPTY_LIST;
            }
            return sysUserRpcDTOList;
        } catch (Exception e) {
            log.error("findUserByUserIds error:", e);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Optional<SysUserRpcDTO> findUserByUserId(Long id) {
        if (StringUtils.isEmpty(id)){
            return Optional.empty();
        }
        try {
            SysUserRpcDtoParam param = new SysUserRpcDtoParam();
            param.setUserIds(Collections.singletonList(id));
            List<SysUserRpcDTO> sysUserRpcDTOList = sysUserRpcService.findUserRpcDtoByParam(param);
            if (CollectionUtils.isEmpty(sysUserRpcDTOList)){
                return Optional.empty();
            }
            return Optional.of(sysUserRpcDTOList.get(0));
        } catch (Exception e) {
            log.error("findUserByUserId error:", e);
        }
        return Optional.empty();
    }

    /**
     * 根据id查询用户
     *
     * @param ids
     * @return
     */
    @Override
    public List<SysUserBasicDTO> findUserByUserIdBatch(Set<Long> ids) {
        log.info("findUserByUserIdBatch params:{}",JSON.toJSONString(ids));
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.EMPTY_LIST;
        }
        try {
            UserQueryDTO userQueryDTO = new UserQueryDTO();
            userQueryDTO.setUserIds(ids);
            ApiResult<List<SysUserBasicDTO>> apiResult = userRpcService.queryUser(userQueryDTO);
            log.info("findUserByUserIdBatch，时间：{}，出参：{}", LocalDateTime.now(), apiResult);

            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException(ApiCode.FAIL, "调用系统域查询用户失败：" + apiResult.getErrorMsg());
                //return Collections.EMPTY_LIST;
            }
        } catch (Exception e) {
            log.error("findUserByUserIdBatch error:", e);
        }
        return Collections.EMPTY_LIST;
    }

    /**
     * 16.2
     * 根据支付条款代码查询支付条款
     *
     * @param paymentTermCodes 支付条款代码集合
     * @return 支付条款对象
     */
    @Override
    public List<ComPaymentTermRespVO> findPaymentCodeBatch(List<String> paymentTermCodes) {
        log.info("findPaymentCodeBatch params:{}",JSON.toJSONString(paymentTermCodes));
        if (CollectionUtils.isEmpty(paymentTermCodes)) {
            return Lists.newArrayList();
        }
        try {
            List<ComPaymentTermRespVO> list = comPaymentTermService.findCodeBatch(paymentTermCodes);
            if (!CollectionUtils.isEmpty(list)) {
                return list;
            }
        } catch (Exception e) {
            log.error("findPaymentCodeBatch error:", e);
        }
        return Lists.newArrayList();
    }

    /**
     * 16.3
     * 根据支付条款代码查询支付条款
     *
     * @param paymentTermCode 支付条款代码
     * @return 支付条款对象
     */
    @Override
    public Optional<ComPaymentTermRespVO> findPaymentByCode(String paymentTermCode) {
        log.info("findPaymentByCode param:{}",paymentTermCode);
        if (StringUtils.isEmpty(paymentTermCode)) {
            return Optional.empty();
        }
        try {
            ComPaymentTermRespVO comPaymentTermRespVO = comPaymentTermService.getCodeOne(paymentTermCode);
            if (Objects.nonNull(comPaymentTermRespVO)) {
                return Optional.of(comPaymentTermRespVO);
            }
        } catch (Exception e) {
            log.error("findPaymentByCode error:", e);
        }
        return Optional.empty();
    }

    /**
     * 查询所有付款条款
     *
     * @return 支付条款对象
     */
    @Override
    public List<ComPaymentTermRespVO> findAllPayment() {
        log.info("findAllPayment");
        try {
            List<ComPaymentTermRespVO> paymentTermRespVOS = comPaymentTermService.list();
            if (Objects.nonNull(paymentTermRespVOS)) {
                return paymentTermRespVOS;
            }
        } catch (Exception e) {
            log.error("findAllPayment error:", e);
        }
        return Collections.EMPTY_LIST;
    }

    /**
     * 根据货币编号集合获取货币信息列表
     *
     * @param currCodes 货币编号集合
     * @return 货币集
     */
    @Override
    public List<SysCurrencyRespDTO> findCurrByCodes(List<String> currCodes) {
        log.info("调用系统域域-根据货币编号集合获取货币信息列表，时间：{}，入参：{}", LocalDateTime.now(), currCodes);
        if (CollectionUtils.isEmpty(currCodes)) {
            return Lists.newArrayList();
        }
        try {
            return currencyRpcService.listByCodes(new HashSet<>(currCodes)).getData();
        } catch (Exception e) {
            log.error("findCurrByCodes error:", e);
        }
        return Lists.newArrayList();
    }

    /**
     * 查询所有币种
     *
     * @return 货币集
     */
    @Override
    public List<SysCurrencyRespDTO> findAllCurrency() {
        log.info("调用系统域域-获取所有货币信息列表，时间：{}", LocalDateTime.now());
        try {
            ApiResult<List<SysCurrencyRespDTO>> currencyResult = currencyRpcService.queryList(new SysCurrencyQueryDTO());
            if (currencyResult.isFailed()) {
                log.error("findAllCurrency error: {}", currencyResult.getErrorMsg());
            } else {
                return currencyResult.getData();
            }
        } catch (Exception e) {
            log.error("findAllCurrency error:", e);
        }
        return Lists.newArrayList();
    }

    /**
     * 根据货币编号获取货币信息
     *
     * @param currCode 货币编号
     * @return 货币信息
     */
    @Override
    public Optional<SysCurrencyRespDTO> findCurrByCode(String currCode) {
        log.info("调用系统域-根据货币编号获取货币信息，时间：{}，入参：{}", LocalDateTime.now(), currCode);
        if (StringUtils.isEmpty(currCode)) {
            return Optional.empty();
        }
        try {
            var comCurrRespVO = currencyRpcService.getByCode(currCode).getData();
            log.info("调用支撑域-根据货币编号获取货币信息，时间：{}，出参：{}", LocalDateTime.now(), comCurrRespVO);
            if (Objects.nonNull(comCurrRespVO)) {
                return Optional.of(comCurrRespVO);
            }
        } catch (Exception e) {
            log.error("findCurrByCode error:", e);
        }
        return Optional.empty();
    }

    /*************************15税率共通comTaxRateService*******************************/
    /**
     * 15.1
     * 查找税率共通方法
     *
     * @param param 单个入参
     * @return 返回 单个税率
     * @author 常昊阳 haoyang.chang@elitesland.com
     */
//    @Override
//    public Optional<SysTaxRateRespDTO> getCommonTaxRateRatio(ComCommonTaxRateQueryParamVO param) {
//        log.info("getCommonTaxRateRatio param:{}",JSON.toJSONString(param));
//        try {
//            taxRateRpcService.getByTaxRateNo(param.getVTxa1());
//            var comCommonTaxRateRespVO = taxRateRpcService.getByTaxRateNo(param.getVTxa1()).getData();
//            if (Objects.nonNull(comCommonTaxRateRespVO)) {
//                return Optional.of(comCommonTaxRateRespVO);
//            }
//        } catch (Exception e) {
//            log.error("getCommonTaxRateRatio error:", e);
//        }
//        return Optional.empty();
//    }

    /*************************17汇率comCurrRateService*******************************/
    /**
     * 17.01
     * 货币汇率转换
     *
     * @param param
     * @return 汇率
     */
//    @Override
//    public Double findCurrRateRatio(ComCurrRateQueryParamVO param) {
//        log.info("findCurrRateRatio param:{}",JSON.toJSONString(param));
//        SysCurrencyRateQueryDTO queryDTO = new SysCurrencyRateQueryDTO();
//        queryDTO.setFromCurr(param.getFromCurr());
//        queryDTO.setToCurr(param.getToCurr());
//        queryDTO.setValidDate(param.getValidDate());
//        queryDTO.setValidFromS(param.getValidFromS());
//        queryDTO.setValidFromE(param.getValidFromE());
//        queryDTO.setValidToS(param.getValidToS());
//        queryDTO.setValidToE(param.getValidToE());
//        try {
//            return currencyRateRpcService.findRatio(queryDTO).getData();
//        } catch (Exception e) {
//            log.error("findCurrRateRatio error:", e);
//        }
//        return null;
//    }
    /**
     * 15.3
     * 根据税率编号集合查询税率信息
     *
     * @param taxRateNos 税率编号
     * @return 税率信息集合
     **/
    @Override
    public List<SysTaxRateRespDTO> findTaxRateBytaxRateNoList(List<String> taxRateNos) {
        log.info("findTaxRateBytaxRateNoList params:{}",JSON.toJSONString(taxRateNos));
        if (CollectionUtils.isEmpty(taxRateNos)) {
            return Lists.newArrayList();
        }
        SysTaxRateQueryDTO queryDTO = new SysTaxRateQueryDTO();
        queryDTO.setTaxRateNos(new HashSet<>(taxRateNos));
        try {
            var comTaxRateVos = taxRateRpcService.queryList(queryDTO).getData();;
            if (!CollectionUtils.isEmpty(comTaxRateVos)) {
                return comTaxRateVos;
            }
        } catch (Exception e) {
            log.error("findTaxRateBytaxRateNoList error:", e);
        }
        return Lists.newArrayList();

    }

    /**
     * 15.3
     * 根据税率编号集合查询税率信息
     *
     * @return 税率信息集合
     **/
    @Override
    public List<SysTaxRateRespDTO> findAllTaxRate() {
        log.info("findAllTaxRate");
        SysTaxRateQueryDTO queryDTO = new SysTaxRateQueryDTO();
        try {
            var comTaxRateVos = taxRateRpcService.queryList(queryDTO).getData();;
            if (!CollectionUtils.isEmpty(comTaxRateVos)) {
                return comTaxRateVos;
            }
        } catch (Exception e) {
            log.error("findTaxRateBytaxRateNoList error:", e);
        }
        return Lists.newArrayList();

    }

    /*************************22sysUserRepo*******************************/
    /**
     * 22.01
     *
     * @param ids
     * @return
     */
    @Override
    public List<SysUserVO> sysUserGetByIds(List<Long> ids) {
        try {
            return sysUserService.getByIds(ids);
        } catch (Exception e) {
            log.error("sysUserGetByIds error:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<SysEmployeeBasicDTO> getEmpByIds(Set<Long> empIds) {
        if (CollectionUtils.isEmpty(empIds)) {
            return Lists.newArrayList();
        }
        EmployeeQueryDTO param = new EmployeeQueryDTO();
        param.setIds(empIds);
        log.info("调用系统域批量查询员工信息接口开始，参数：{}, 时间：{}", JSON.toJSONString(param), LocalDateTime.now());
        ApiResult<List<SysEmployeeBasicDTO>> apiResult = employeeRpcService.queryList(param);
        if (apiResult.isSuccess()) {
            log.info("调用系统域批量查询员工信息接口成功，返回值：{}, 时间：{}", JSON.toJSONString(apiResult), LocalDateTime.now());
            return apiResult.getData();
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "查询员工信息失败：" + apiResult.getMsg());
        }
    }

    @Override
    public SysEmployeeBasicDTO getEmpByUserId(Long userId) {
        if (Objects.isNull(userId)) {
            return null;
        }
        log.info("调用系统域根据用户id查询员工信息接口开始，参数：{}, 时间：{}", JSON.toJSONString(userId), LocalDateTime.now());
        ApiResult<SysEmployeeBasicDTO> apiResult = employeeRpcService.getByUserId(userId);
        if (apiResult.isSuccess()) {
            log.info("调用系统域根据用户id查询员工信息接口成功，返回值：{}, 时间：{}", JSON.toJSONString(apiResult), LocalDateTime.now());
            return apiResult.getData();
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "查询员工信息失败：" + apiResult.getMsg());
        }
    }

    @Override
    public List<EmployeePageRespDTO> queryEmpByUserId(Long userId) {
        if (Objects.isNull(userId)) {
            return Collections.emptyList();
        }
        EmployeePageQueryDTO param = new EmployeePageQueryDTO();
        param.setIds(Collections.singleton(userId));
        log.info("调用系统域根据用户id分页查询员工信息接口开始，参数：{}, 时间：{}", JSON.toJSONString(userId), LocalDateTime.now());
        ApiResult<PagingVO<EmployeePageRespDTO>> apiResult = employeeRpcService.queryByPage(param);
        if (apiResult.isSuccess() && apiResult.getData() != null && !CollectionUtils.isEmpty(apiResult.getData().getRecords())) {
            log.info("调用系统域根据用户id分页查询员工信息接口成功，返回值：{}, 时间：{}", JSON.toJSONString(apiResult), LocalDateTime.now());
            return apiResult.getData().getRecords();
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "查询员工信息失败：" + apiResult.getMsg());
        }
    }

    /**
     * 15.4
     * 根据税率编号查询税率信息
     *
     * @param taxRateNo 税率编号
     * @return 税率信息
     */
    @Override
    public Optional<SysTaxRateRespDTO> findTaxRateByTaxRateNo(String taxRateNo) {
        log.info("findTaxRateByTaxRateNo param:{}",taxRateNo);
        try {
            if (StringUtils.isEmpty(taxRateNo)) {
                return Optional.empty();
            }
            var comTaxRateRespVO = taxRateRpcService.getByTaxRateNo(taxRateNo).getData();
            if (Objects.nonNull(comTaxRateRespVO)) {
                return Optional.of(comTaxRateRespVO);
            }
        } catch (Exception e) {
            log.error("findTaxRateByTaxRateNo error:", e);
        }
        return Optional.empty();
    }

    /**
     * 根据区域编号集合获取区域信息列表
     *
     * @param areaCodes 区域编号集合
     * @return 区域集
     */
    @Override
    public List<SysAreaRespDTO> findAreaByCodes(List<String> areaCodes) {
        log.info("调用支撑域-根据区域编号集合获取区域信息列表，时间：{}，入参：{}", LocalDateTime.now(), areaCodes);
        if (CollectionUtils.isEmpty(areaCodes)){
            return Collections.EMPTY_LIST;
        }
        try {
            return areaRpcService.listByAreaCodes(new HashSet<>(areaCodes)).getData();
        } catch (Exception e) {
            log.error("findAreaByCodes error:", e);
        }
        return Collections.EMPTY_LIST;

    }

    /**
     * 获取全部区域信息列表
     *
     * @return 区域集
     */
    @Override
    public List<SysAreaRespDTO> findAllArea() {
        log.info("调用支撑域-获取全部区域信息列表，时间：{}，入参：{}", LocalDateTime.now());
        try {
            List<SysAreaRespDTO> areaList = areaRpcService.queryList(new SysAreaQueryDTO()).getData();
            if (CollectionUtils.isEmpty(areaList)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "未查询到公司信息");
            }
            return areaList;
        } catch (Exception e) {
            log.error("findAreaByCodes error:", e);
        }
        return Collections.EMPTY_LIST;
    }

    /**
     * 商品库存参数配置模块 - 更据计划员工ID查询系统用户账号信息
     *
     * @param calcEmpIds userids
     * @return 系统用户集
     */
    @Override
    public List<SysUserVO> findAllEmpsByIdIn(List<Long> calcEmpIds) {
        log.info("findAllEmpsByIdIn params:{}",JSON.toJSONString(calcEmpIds));
        try {
            if (calcEmpIds.isEmpty()) {
                return Collections.emptyList();
            }
            List<SysUserVO> sysUserVOList = sysUserService.getByIds(calcEmpIds);
            if (!com.alibaba.excel.util.CollectionUtils.isEmpty(sysUserVOList)) {
                return sysUserVOList;
            }
        } catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ComPaymentTermRespVO> findCodeBatch(List<String> paymentTermCodes) {
        log.info("findPaymentCodeBatch param:{}", JSON.toJSONString(paymentTermCodes));
        if (CollectionUtils.isEmpty(paymentTermCodes)) {
            return Lists.newArrayList();
        }
        try {
            List<ComPaymentTermRespVO> list = comPaymentTermService.findCodeBatch(paymentTermCodes);
            if (!CollectionUtils.isEmpty(list)) {
                return list;
            }
        } catch (Exception e) {
            log.error("findPaymentCodeBatch error:", e);
        }
        return Lists.newArrayList();
    }

    /**
     * 创建用户账号新方法
     *
     * @param param 用户信息
     * @return 用户ID
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> sysUserAccountCreate(SysUserRpcSaveParam param) {
        log.info("调用系统域-创建用户账号新方法，时间：{}，入参：{}", LocalDateTime.now(), param);
        try {
            ApiResult<Object> apiResult = sysUserRpcService.sysUserAccountCreate(param);
            log.info("调用系统域-创建用户账号新方法，时间：{}，出参：{}", LocalDateTime.now(), apiResult);
            return apiResult;
        } catch (Exception e) {
            log.error("sysUserAccountCreate error:", e);
            return ApiResult.fail(e.getMessage());
        }
    }

    @Override
    public SysSettingVO findSysSetting(String settingNo){
        log.info("调用系统域-获取系统配置参数，时间：{}，入参：{}", LocalDateTime.now(), settingNo);
        try {
            SysSettingVO sysSettingVO = sysCacheSettingRpcService.oneByNo(settingNo);
            return sysSettingVO;
        } catch (Exception e){
            throw new BusinessException("调用系统域-获取系统配置参数服务失败",e);
        }
    }

}
