package com.elitesland.scp.application.service.order;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invTrn.StoreOrderTrnRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.order.param.SalSoSaveDTO;
import com.elitesland.pur.dto.po.PurPoSaveDTO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderAppCountParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderItemBatchParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderItemParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.*;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSaveVO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.support.provider.org.dto.OrgStoreWhDTO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface ScpDemandOrderService {

    /**
     * 订货订单查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpDemandOrderTitlePageRespVO> page(ScpDemandOrderPageParamVO paramVO);

    /**
     * 订货订单明细查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpDemandOrderPageRespVO> queryDemandOrderDList(ScpDemandOrderPageParamVO paramVO);


    /**
     * 查询订单头列表
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpDemandOrderPageRespVO> queryDemandOrderHeader(ScpDemandOrderPageParamVO paramVO);

    /**
     * 订货订单详情-添加商品分类信息
     *
     * @param id
     * @return
     */
    Optional<ScpDemandOrderRespVO> findDemandOrderCateById(Long id);

    /**
     * 订货订单详情
     *
     * @param id
     * @return
     */
    Optional<ScpDemandOrderRespVO> findDemandOrderById(Long id);

    /**
     * 订货集计算分配
     *
     * @param demandSetId
     */
    void compute(Long demandSetId);

    /**
     * 根据订货集ID查询订货订单
     *
     * @param demandIds
     * @return
     */
    List<ScpDemandOrderRespVO> findDemandOrderByDemandIds(List<Long> demandIds);

    /**
     * 订货单保存
     *
     * @param saveVO
     * @return
     */
    Long saveDemandOrder(ScpDemandOrderSaveVO saveVO);

    /**
     * 获取商品明细行信息
     *
     * @param paramVO
     */
    List<ScpDemandOrderDRespVO> getItemList(ScpDemandOrderItemParamVO paramVO);

    /**
     * 获取商品明细行信息-批量
     *
     * @param paramVO
     */
    Map<String, List<ScpDemandOrderDRespVO>> getItemListBatch(ScpDemandOrderItemBatchParamVO paramVO);

    /**
     * 取消订货单
     *
     * @param id
     */
    void cancelScpDemand(Long id);

    /**
     * 类型数量
     *
     * @param paramVO
     * @return
     */
    List<AppDemandOrderCountRespVO> countStatus(ScpDemandOrderAppCountParamVO paramVO);

    /**
     * 订货单删除
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 推送订货单
     *
     * @param id
     */
    void push(Long id, Long agentEmpId, Boolean appFlag);

    default void push(Long id) {
        push(id, null, false);
    }

    /**
     * 准备调拨单数据
     *
     * @param demandOrderDTO
     * @param haveWhStoreMap
     * @param whIdMap
     * @param employeeId
     * @param demandOrderDList
     * @return
     */
    List<StoreOrderTrnRpcDTO> prepareDataTrnPush(ScpDemandOrderDTO demandOrderDTO, Map<String, List<OrgStoreWhDTO>> haveWhStoreMap, Map<Long, InvWhRpcSimpleDTO> whIdMap,
                                                 Long employeeId, List<ScpDemandOrderDDTO> demandOrderDList, ScpOrderSettingRespVO setting);

    /**
     * 准备采购单数据
     *
     * @param demandOrderDTO
     * @param haveWhStoreMap
     * @param employeeId
     * @param demandOrderDList
     * @return
     */
    List<PurPoSaveDTO> prepareDataPoPush(ScpDemandOrderDTO demandOrderDTO, Map<String, List<OrgStoreWhDTO>> haveWhStoreMap, Long employeeId,
                                         List<ScpDemandOrderDDTO> demandOrderDList, ScpOrderSettingRespVO setting);

    /**
     * 准备销售单数据
     *
     * @param demandOrderDTO
     * @param orgStoreMap
     * @param demandOrderDList
     * @return
     */
    List<SalSoSaveDTO> prepareDataSoPush(ScpDemandOrderDTO demandOrderDTO, Map<String, List<OrgStoreWhDTO>> orgStoreMap, List<ScpDemandOrderDDTO> demandOrderDList);

    /**
     * 查询仓库信息
     *
     * @param demandOrderDTOS
     * @return
     */
    Map<Long, InvWhRpcSimpleDTO> getWhMap(List<ScpDemandOrderDTO> demandOrderDTOS);

    /**
     * 查询门店信息
     *
     * @param demandOrderDTOS
     * @return
     */
    Map<String, List<OrgStoreWhDTO>> getOrgStoreMap(List<ScpDemandOrderDTO> demandOrderDTOS);

    /**
     * 推送采购订单数据
     *
     * @param storeOrderPoRpcDTOs
     */
    void pushPo(List<PurPoSaveDTO> storeOrderPoRpcDTOs);

    /**
     * 推送调拨单数据
     *
     * @param storeOrderTrnRpcDTOs
     */
    void pushTrn(List<StoreOrderTrnRpcDTO> storeOrderTrnRpcDTOs);

    /**
     * 推送销售单数据
     *
     * @param salSoSaveDTOS
     */
    void pushSo(List<SalSoSaveDTO> salSoSaveDTOS);

    /**
     * 订货单支付信息
     *
     * @param id
     */
    List<ScpDemandOrderPayInfoRespVO> payInfo(Long id);

    /**
     * 支付订货订单查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpPayOrderPageRespVO> payPage(ScpDemandOrderPageParamVO paramVO);

    /**
     * 订货订单关闭
     *
     * @param id
     */
    default void close(Long id) {
        close(id, null);
    }

    void close(Long id, String source);

    void closePoOrTro(Long id, String type);

    /**
     * 订货订单关闭-根据单据号
     *
     * @param docNo
     */
    void closeOrderByDocNo(String docNo);

    /**
     * pc端自动推送
     *
     * @param masId
     */
    void autoPush(Long masId);

    /**
     * 查询可用的订货强配活动
     *
     * @param paramVO
     * @return
     */
    Map<String, List<ScpDemandOrderDRespVO>> findEnableAllocSetting(ScpAllocSettingParamVO paramVO);

}
