package com.elitesland.scp.application.web.wqf;


import com.alibaba.excel.EasyExcel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.resp.wqf.*;
import com.elitesland.scp.application.service.wqf.ScpWqfEntAccountApplyService;
import com.elitesland.scp.utils.excel.ExcelEntityDataListener;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 微企付商户账户申请 前端控制器
 * </p>
 *
 * @author jeesie.jiang
 * @since 2025-02-27
 */
@Slf4j
@Api(tags = "微企付申请")
@RestController
@RequestMapping("/wqf/ent-account/apply")
@AllArgsConstructor
public class ScpWqfEntAccountApplyController {

    private final ScpWqfEntAccountApplyService scpWqfEntAccountApplyService;

    @ApiOperation(value = "微企付申请-分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpWqfEntAccountApplyPageVO>> page(@RequestBody ScpWqfEntAccountApplyPageParam paramVO) {
        return ApiResult.ok(scpWqfEntAccountApplyService.page(paramVO));
    }


    @ApiOperation(value = "微企付申请-新增/编辑")
    @PostMapping(value = "/save")
    public ApiResult<Object> save(@RequestBody ScpWqfEntAccountApplySaveVO createParam) {
        return ApiResult.ok(scpWqfEntAccountApplyService.save(createParam));
    }

    @PostMapping("/submit")
    @ApiOperation("微企付申请-提交")
    public ApiResult<Object> submit(@RequestBody ScpWqfEntAccountApplySaveVO saveVO) {
        return ApiResult.ok(scpWqfEntAccountApplyService.submit(saveVO));
    }

    @ApiOperation(value = "微企付申请-详情")
    @GetMapping("/detail/{id}")
    public ApiResult<ScpWqfEntAccountApplyRespVO> detail(@PathVariable Long id) {
        return ApiResult.ok(scpWqfEntAccountApplyService.detail(id));
    }

    @PostMapping("/importDetail")
    @ApiOperation("微企付申请-导入明细")
    public ApiResult<List<ScpWqfEntAccountApplyDRespVO>> importDetail(ScpWqfEntAccountApplyImportParam param){
        ExcelEntityDataListener<ScpWqfEntAccountApplyDImportVO> dataListener = new ExcelEntityDataListener<>();
        try {
            EasyExcel.read(param.getFile().getInputStream(), ScpWqfEntAccountApplyDImportVO.class, dataListener).doReadAll();
        }catch (Exception e){
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        List<ScpWqfEntAccountApplyDImportVO> list = dataListener.getDatas();
        return scpWqfEntAccountApplyService.importDetail(list,param);
    }


    @PostMapping("/batchSubmit")
    @ApiOperation("微企付申请列表-批量提交")
    public ApiResult<Object> batchSubmit(@RequestBody List<Long> ids) {
        return ApiResult.ok(scpWqfEntAccountApplyService.batchSubmit(ids));
    }

    @PostMapping("/delete")
    @ApiOperation("微企付申请列表-批量删除")
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        scpWqfEntAccountApplyService.delete(ids);
        return ApiResult.ok();
    }



}
