package com.elitesland.scp.domain.service.feedback.impl;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.feedback.ScpStoreFeedbackConvert;
import com.elitesland.scp.domain.entity.feedback.QScpStoreFeedbackDO;
import com.elitesland.scp.domain.entity.feedback.ScpStoreFeedbackDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.feedback.ScpStoreFeedbackRepoProc;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackRespVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackQueryParamVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackSaveVO;
import com.elitesland.scp.infr.repo.feedback.ScpStoreFeedbackRepo;
import com.elitesland.scp.domain.service.feedback.ScpStoreFeedbackDomainService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.github.houbb.sensitive.word.bs.SensitiveWordBs;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import lombok.RequiredArgsConstructor;
import lombok.val;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.transaction.annotation.Transactional;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author makejava
 * @since 2025-09-23 18:08:05
 */
@Service("scpStoreFeedbackDomainService")
@RequiredArgsConstructor
@Slf4j
public class ScpStoreFeedbackDomainServiceImpl implements ScpStoreFeedbackDomainService {
    
    private final ScpStoreFeedbackRepo scpStoreFeedbackRepo;
    
    private final ScpStoreFeedbackRepoProc scpStoreFeedbackRepoProc;

    private final SensitiveWordBs sensitiveWordBs;

 
    @Override
    public PagingVO<ScpStoreFeedbackRespVO> search(ScpStoreFeedbackQueryParamVO param){
        val ret = scpStoreFeedbackRepo.findAll(scpStoreFeedbackRepoProc.where(param), param.getPageRequest());
        val vos = ret.getContent().stream().map(ScpStoreFeedbackConvert.INSTANCE::doToVO).collect(Collectors.toList());
        vos.forEach(item -> {
            if (item.getFileUrl() != null)
                item.setFileUrlList(JSONObject.parseArray(item.getFileUrl(), ScpStoreFeedbackRespVO.FileObject.class));
            String replace = sensitiveWordBs.replace(item.getEvaluationComment());
            item.setEvaluationComment(replace);
            String replace1 = sensitiveWordBs.replace(item.getOptimizationSuggestion());
            item.setOptimizationSuggestion(replace1);
        });
        return PagingVO.<ScpStoreFeedbackRespVO>builder()
                .total(ret.getTotalElements())
                .records(vos)
                .build();
    }
 
    @Override
    public Optional<ScpStoreFeedbackRespVO> findCodeOne(String itemCode) {
        JPAQuery<ScpStoreFeedbackRespVO> jpaQuery = scpStoreFeedbackRepoProc.select(null);
        val jpaQDo = QScpStoreFeedbackDO.scpStoreFeedbackDO;
        //设置查询条件
        //jpaQuery.where(jpaQDo.itemCode.eq(itemCode));
        ScpStoreFeedbackRespVO vo = jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }
    @Override
    public Optional<ScpStoreFeedbackRespVO> findIdOne(Long id) {
        return scpStoreFeedbackRepo.findById(id).map(ScpStoreFeedbackConvert.INSTANCE::doToVO);
    }
    
    @Override
    public List<ScpStoreFeedbackRespVO> findIdBatch(List<Long> idList) {
         return scpStoreFeedbackRepo.findAllById(idList).stream().map(
               ScpStoreFeedbackConvert.INSTANCE::doToVO
        ).collect(Collectors.toList());
    }

    
    
    @Override
    @Transactional
    public Long createOne(ScpStoreFeedbackSaveVO param){
        ScpStoreFeedbackDO objDo = ScpStoreFeedbackConvert.INSTANCE.saveParamToDo(param);
        if(param.getId()!=null&&param.getId()>0){
            Optional<ScpStoreFeedbackDO> optional = scpStoreFeedbackRepo.findById(objDo.getId());
            if(optional.isPresent()){
                BeanCopyUtil.beanCopyWithIngore(objDo, optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
                scpStoreFeedbackRepo.save(optional.get());
            }else{
                throw new BusinessException(ApiCode.FAIL,"修改失败，数据不存在"+objDo.getId());
            }
        }

       return scpStoreFeedbackRepo.save(objDo).getId();
    }
    
    @Override
    @Transactional
    public List<ScpStoreFeedbackRespVO> createBatch(List<ScpStoreFeedbackSaveVO> list){
        List<ScpStoreFeedbackDO> dos = list.stream().map(ScpStoreFeedbackConvert.INSTANCE::creatParamToDo).collect(Collectors.toList());
       return scpStoreFeedbackRepo.saveAll(dos).stream().map(ScpStoreFeedbackConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> statusChangeByProcess(long id, ProcInstStatus procInstStatus, String approveComment) {
        log.info("门店反馈工作流回调:{},{}", id, procInstStatus);
        //1,查询单据是否存在
        Optional<ScpStoreFeedbackRespVO> optional =  this.findIdOne(id);
        if (optional.isEmpty()) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }
        ScpStoreFeedbackRespVO scpStoreFeedbackRespVO = optional.get();
        Map<String, String> result = new HashMap<>();
        //2,修改审批状态
        scpStoreFeedbackRespVO.setProcInstStatus(procInstStatus);
        String docStatus = null;
        String approveStatus = null;
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        //3,修改单据状态
        switch (procInstStatus) {
            // 未提交
            case NOTSUBMIT:
                // 中断执行
            case INTERRUPT:
                //草稿
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DRAFT.getValueCode();
//                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_APPROVING.getValueCode();
                break;
            // 审批拒绝
            case REJECTED:
                //拒绝
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DONE.getValueCode();
                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_INVALID.getValueCode();
                break;
            // 作废
            case INVALID:
                //作废
//                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DONE.getValueCode();
//                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_INVALID.getValueCode();
                break;
            // 审批中
            case APPROVING:
                //审批中(已提交)
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_APPROVING.getValueCode();
                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_APPROVING.getValueCode();
                break;
            // 审批通过
            case APPROVED:
                //审批通过//审批完成时间
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DONE.getValueCode();
                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_VALID.getValueCode();
                scpStoreFeedbackRespVO.setApprovalTime(LocalDateTime.now());
                if (currentUserDTO != null) {
                    scpStoreFeedbackRespVO.setApprovedBy(currentUserDTO.getDetail().getLastName());
                }
                break;
            default:
                throw new IllegalStateException("非法访问");
        }
        //执行
        scpStoreFeedbackRespVO.setFeedbackStatus(docStatus);
        scpStoreFeedbackRespVO.setApprovalStatus(approveStatus);
        scpStoreFeedbackRespVO.setProcInstStatus(procInstStatus);
        scpStoreFeedbackRespVO.setRemark(approveComment);
        this.updateById(scpStoreFeedbackRespVO);

        //4,其他业务
        if (procInstStatus.equals(ProcInstStatus.APPROVED)) {

        }
        return result;
    }

    @Override
    @Transactional
    public void updateById(ScpStoreFeedbackRespVO param) {
        scpStoreFeedbackRepoProc.update(param);
    }
    
    @Override
    @Transactional
    public void update(ScpStoreFeedbackSaveVO param) {
      ScpStoreFeedbackDO objDo = ScpStoreFeedbackConvert.INSTANCE.saveParamToDo(param);
        Optional<ScpStoreFeedbackDO> optional = scpStoreFeedbackRepo.findById(objDo.getId());
        if(optional.isPresent()){
             BeanCopyUtil.beanCopyWithIngore(objDo, optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
             scpStoreFeedbackRepo.save(optional.get());
        }else{
            throw new BusinessException(ApiCode.FAIL,"修改失败，数据不存在"+objDo.getId());
        }
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        val jpaQDo = QScpStoreFeedbackDO.scpStoreFeedbackDO;
        Predicate predicate = jpaQDo.isNotNull();
        predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
                Optional<ScpStoreFeedbackDO> optionalItem=scpStoreFeedbackRepo.findOne(predicate);
        if(optionalItem.isPresent()) {
            ScpStoreFeedbackDO do1 = optionalItem.get();
            do1.setDeleteFlag(1);
            scpStoreFeedbackRepo.save(do1);
        }else{
             throw new BusinessException(ApiCode.FAIL,"修改失败，数据不存在"+id);
        }
    }

    
    
    @Override
    @Transactional
    public void deleteOne(Long id) {
     
      this.scpStoreFeedbackRepo.deleteById(id) ;
      
    }
    
    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id-> scpStoreFeedbackRepo.deleteById(id));
    }
}


