package com.elitesland.scp.infr.repo.calendar;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarPageParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarPageVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarParamVO;
import com.elitesland.scp.application.service.scpsman.BaseScpmanAuthorityParam;
import com.elitesland.scp.domain.entity.calendar.QScpSuppDemandCalendarDO;
import com.elitesland.scp.domain.entity.calendar.ScpSuppDemandCalendarDO;
import com.elitesland.scp.infr.dto.calendar.ScpSuppDemandCalendarDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.val;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.time.format.DateTimeFormatter;
import java.util.List;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-03-28
* @Version 1.0
**/
@Component
public class ScpSuppDemandCalendarRepoProc extends BaseRepoProc<ScpSuppDemandCalendarDO> {

    private static final QScpSuppDemandCalendarDO jpaQDo = QScpSuppDemandCalendarDO.scpSuppDemandCalendarDO;
    public ScpSuppDemandCalendarRepoProc(){
        super(jpaQDo);
    }

    public PagingVO<ScpSuppDemandCalendarPageVO> searchPage(ScpSuppDemandCalendarPageParamVO param){
        JPAQuery<ScpSuppDemandCalendarPageVO> jpaQuery = jpaQueryFactory.select(Projections.bean(ScpSuppDemandCalendarPageVO.class,
                jpaQDo.suppId,
                jpaQDo.suppCode,
                jpaQDo.suppName,
                jpaQDo.type,
                jpaQDo.storeWhId,
                jpaQDo.storeWhCode,
                jpaQDo.storeWhName,
                jpaQDo.year,
                jpaQDo.month
        )).distinct().from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.orderBy(jpaQDo.year.desc(),jpaQDo.month.desc());
        param.setPaging(jpaQuery);
        return PagingVO.<ScpSuppDemandCalendarPageVO>builder()
                .total(getCount(param))
                .records(jpaQuery.fetch())
                .build();
    }


    public Predicate where(ScpSuppDemandCalendarPageParamVO param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if(StringUtils.isNotEmpty(param.getSuppCode())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.suppCode.eq(param.getSuppCode()));
        }
        if(StringUtils.isNotEmpty(param.getStoreWhCode())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.storeWhCode.eq(param.getStoreWhCode()));
        }
        if(StringUtils.isNotEmpty(param.getType())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.type.eq(param.getType()));
        }
        if(param.getStartDate() != null){
            String year = String.valueOf(param.getStartDate().getYear());

            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
            String month = param.getStartDate().format(formatter);

            predicate = ExpressionUtils.and(predicate, jpaQDo.year.goe(year)
                    .and(jpaQDo.month.goe(month)));

        }
        if(param.getEndDate() != null){
            String year = String.valueOf(param.getEndDate().getYear());

            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
            String month = param.getEndDate().format(formatter);

            predicate = ExpressionUtils.and(predicate, jpaQDo.year.loe(year)
                    .and(jpaQDo.month.loe(month)));

        }
        if(Boolean.TRUE.equals(param.getScpmanAuthority())){
            predicate = whereScpmanAuthority(param,predicate);
        }

        return predicate;
    }

    private Predicate whereScpmanAuthority(BaseScpmanAuthorityParam param, Predicate predicate) {
        if(CollectionUtils.isNotEmpty(param.getStores()) && CollectionUtils.isNotEmpty(param.getWhCodes())){
            predicate = ExpressionUtils.or(
                    jpaQDo.type.eq("1").and(jpaQDo.storeWhCode.in(param.getWhCodes())),
                    jpaQDo.type.eq("0").and(jpaQDo.storeWhCode.in(param.getStores()))
            );
        }else if(CollectionUtils.isNotEmpty(param.getWhCodes())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.type.eq("1"));
            predicate = ExpressionUtils.and(predicate, jpaQDo.storeWhCode.in(param.getWhCodes()));
        }else if(CollectionUtils.isNotEmpty(param.getStores())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.type.eq("0"));
            predicate = ExpressionUtils.and(predicate,jpaQDo.storeWhCode.in(param.getStores()));
        }
        return predicate;
    }

    private Long getCount(ScpSuppDemandCalendarPageParamVO param) {
        val jpaQuery = jpaQueryFactory.selectDistinct(
                jpaQDo.suppId,
                jpaQDo.suppCode,
                jpaQDo.suppName,
                jpaQDo.type,
                jpaQDo.storeWhId,
                jpaQDo.storeWhCode,
                jpaQDo.storeWhName,
                jpaQDo.year,
                jpaQDo.month
        ).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return (long) jpaQuery.fetch().size();
    }

    public List<ScpSuppDemandCalendarDTO> findSuppCalendarListByParam(ScpSuppDemandCalendarParamVO param){
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(ScpSuppDemandCalendarDTO.class,
                        jpaQDo.suppId,
                        jpaQDo.suppCode,
                        jpaQDo.suppName,
                        jpaQDo.type,
                        jpaQDo.storeWhId,
                        jpaQDo.storeWhCode,
                        jpaQDo.storeWhName,
                        jpaQDo.year,
                        jpaQDo.month,
                        jpaQDo.id,
                        jpaQDo.workStatus,
                        jpaQDo.day
                )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return jpaQuery.fetch();
    }

    public Predicate where(ScpSuppDemandCalendarParamVO param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if(StringUtils.isNotEmpty(param.getSuppCode())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.suppCode.eq(param.getSuppCode()));
        }
        if(StringUtils.isNotEmpty(param.getStoreWhCode())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.storeWhCode.eq(param.getStoreWhCode()));
        }
        if(StringUtils.isNotEmpty(param.getType())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.type.eq(param.getType()));
        }
        if(StringUtils.isNotEmpty(param.getYear())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.year.eq(param.getYear()));
        }
        if(StringUtils.isNotEmpty(param.getMonth())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.month.eq(param.getMonth()));
        }

        return predicate;
    }



}