package com.elitesland.scp.infr.repo.supalloc;

import com.elitesland.scp.domain.entity.supalloc.ScpSupplyAllocationDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-03-25
* @Version 1.0
**/
@Repository
public interface ScpSupplyAllocationRepo extends JpaRepository<ScpSupplyAllocationDO, Long>, QuerydslPredicateExecutor<ScpSupplyAllocationDO> {


    @Query(value = "select * from scp_supply_allocation where (delete_flag = 0 or delete_flag is null) and status = true " +
            "and CONCAT(COALESCE(store_wh_code, ''),COALESCE(item_code, '')) in (?1)",nativeQuery = true)
   List<ScpSupplyAllocationDO>findByConcatKey(List<String> cocatKeys);


    @Modifying
    @Query(value = "delete from scp_supply_allocation where (delete_flag = 0 or delete_flag is null) and CONCAT(COALESCE(store_wh_code, ''), COALESCE(item_code, '')) in (?1)",nativeQuery = true)
    void deleteByBusinessKey(Set<String> concatKeys);


    @Query(value = "select * from scp_supply_allocation where (delete_flag = 0 or delete_flag is null)  " +
            "and CONCAT(COALESCE(store_wh_code, ''),COALESCE(item_code, '')) in (?1)",nativeQuery = true)
    List<ScpSupplyAllocationDO> findAllByConcatKey(List<String> cocatKeys);

    List<ScpSupplyAllocationDO> findByIdIn(List<Long> ids);
}
