package com.elitesland.scp.mq;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.support.provider.out.ItmItemSpuUpdateMqParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * 门店收货单发货回写
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class ItmItemSpuUpdateListener implements MessageQueueListener<ItmItemSpuUpdateMqParam> {

    private final ScpCateItemRepoProc scpCateItemRepoProc;

    @Override
    public @NotEmpty String[] channels() {
        return new String[]{ItmItemSpuUpdateMqParam.ITEM_UPDATE_CHANNEL};
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onConsume(@NotBlank String s, @NotNull ItmItemSpuUpdateMqParam itmItemSpuUpdateMqParam) {
        log.info("商品SPU变更：" + JSON.toJSONString(itmItemSpuUpdateMqParam));
        if (itmItemSpuUpdateMqParam.getSpuId() == null) {
            log.info("商品SPU变更：spuId为空");
            return;
        }
        scpCateItemRepoProc.updateItemSpuInfo(itmItemSpuUpdateMqParam.getItemType2(), itmItemSpuUpdateMqParam.getAnotherName(),
                itmItemSpuUpdateMqParam.getSpuId());
    }

}
