package com.elitesland.scp.utils;

import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 17:36
 * @Description:
 */
public class DateTimeUtil {
    private DateTimeUtil() {
    }

    /**
     * 服务器时区
     */
    public static final ZoneOffset SYS_ZONE_OFFSET = ZoneOffset.of("+8");

    /**
     * 日期格式
     */
    public static final DateTimeFormatter FORMATTER_DATETIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter FORMATTER_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final LocalTime MAX_TIME = LocalTime.of(23, 59, 59);

    public static Date nowOnlyDay() {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }


}
