/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.constant.OrgType;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityRegionParamVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityStatusParamVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityWhStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityDRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityRespVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthorityDSaveVO;
import com.elitesland.scp.application.facade.vo.save.authority.ScpManAuthoritySaveVO;
import com.elitesland.scp.application.facade.vo.scpsman.SalesmanInfoSaveVO;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityService;
import com.elitesland.scp.application.service.scpsman.ScpsmanInfoService;
import com.elitesland.scp.domain.convert.authority.ScpDemandAuthorityConvert;
import com.elitesland.scp.domain.convert.authority.ScpDemandAuthorityDConvert;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDDO;
import com.elitesland.scp.domain.entity.authority.ScpsmanAuthorityDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityDService;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepo;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityDRepoProc;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepo;
import com.elitesland.scp.infr.repo.authority.ScpDemandAuthorityRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgRegionDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgRegionQueryDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgRegionRpcService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class ScpsmanAuthprityServiceImpl
implements ScpsmanAuthorityService {
    private static final Logger log = LoggerFactory.getLogger(ScpsmanAuthprityServiceImpl.class);
    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final ScpDemandAuthorityRepo scpDemandAuthorityRepo;
    private final ScpDemandAuthorityRepoProc scpDemandAuthorityRepoProc;
    private final ScpDemandAuthorityDService scpDemandAuthorityDService;
    private final ScpsmanInfoRepo scpsmanInfoRepo;
    private final ScpsmanInfoRepoProc scpsmanInfoRepoProc;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final ScpDemandAuthorityDRepo scpDemandAuthorityDRepo;
    private final ScpDemandAuthorityDRepoProc scpDemandAuthorityDRepoProc;
    private final ScpsmanInfoService scpsmanInfoService;
    private final EmployeeRpcService employeeRpcService;
    private final UserRpcService userRpcService;
    private final OrgRegionRpcService orgRegionRpcService;
    private final OrgRpcService orgRpcService;
    private final OrgOuRpcService orgOuRpcService;
    private final TaskExecutor taskExecutor;

    @Override
    public PagingVO<ScpManAuthorityPageRespVO> queryAuthorit(ScpManAuthorityParam paramVO) {
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.scpDemandAuthorityService.queryAuthorit(paramVO);
        scpManAuthorityPageRespVOPagingVO.getRecords().stream().forEach(t -> t.setEnableStatusName(ObjectUtil.equal((Object)t.getEnableStatus(), null) ? null : (t.getEnableStatus() != false ? "\u542f\u7528" : "\u7981\u7528")));
        return scpManAuthorityPageRespVOPagingVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeStatus(ScpManAuthorityStatusParamVO paramVO) {
        if (CollectionUtil.isEmpty(paramVO.getIds())) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u8ba1\u5212\u5458\u6743\u9650ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.scpDemandAuthorityService.changeStatus(paramVO.getIds(), paramVO.getStatus());
    }

    @Override
    public void region(ScpManAuthorityRegionParamVO paramVO) {
        if ("1".equals(paramVO.getType())) {
            InvWhRpcDtoParam param = new InvWhRpcDtoParam();
            param.setRegion(paramVO.getRegion());
            List invWhRpcDTOS = (List)this.rmiInvStkRpcService.findWhDTOByParam(param).computeData();
            log.info("\u6309\u533a\u57df\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)invWhRpcDTOS));
            List<ScpsmanAuthorityDDO> data = invWhRpcDTOS.stream().map(e -> {
                ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
                scpsmanAuthorityDDO.setMasId(paramVO.getMasId());
                scpsmanAuthorityDDO.setStWhId(e.getWhId());
                scpsmanAuthorityDDO.setStWhCode(e.getWhCode());
                scpsmanAuthorityDDO.setStWhName(e.getWhName());
                scpsmanAuthorityDDO.setType(1);
                scpsmanAuthorityDDO.setRegion(paramVO.getRegion());
                scpsmanAuthorityDDO.setAuthSource(CharSequenceUtil.blankToDefault((CharSequence)paramVO.getAuthSource(), (String)ScpUdcEnum.SCPSMAN_AUTH_SOURCE_MANUAL.getValueCode()));
                return scpsmanAuthorityDDO;
            }).collect(Collectors.toList());
            log.info("\u6309\u533a\u57df\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f2:{}", (Object)JSONUtil.toJsonStr(data));
            if (CollUtil.isNotEmpty(data)) {
                List<ScpsmanAuthorityDDO> filterExisting = this.filterExisting(data, paramVO.getMasId());
                log.info("\u6309\u533a\u57df\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f3,\u8fc7\u6ee4\u540e:{}", (Object)JSONUtil.toJsonStr(filterExisting));
                this.scpDemandAuthorityDRepo.saveAll(filterExisting);
            }
        } else if ("0".equals(paramVO.getType())) {
            List<OrgStoreBaseRpcDTO> orgStoreBaseByRegion = this.rmiOrgStoreRpcService.findOrgStoreBaseByRegion(Arrays.asList(paramVO.getRegion()));
            log.info("\u6309\u533a\u57df\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr(orgStoreBaseByRegion));
            List<ScpsmanAuthorityDDO> data = orgStoreBaseByRegion.stream().map(e -> {
                ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
                scpsmanAuthorityDDO.setMasId(paramVO.getMasId());
                scpsmanAuthorityDDO.setStWhId(e.getId());
                scpsmanAuthorityDDO.setStWhCode(e.getStoreCode());
                scpsmanAuthorityDDO.setStWhName(e.getStoreName());
                scpsmanAuthorityDDO.setType(0);
                scpsmanAuthorityDDO.setRegion(paramVO.getRegion());
                scpsmanAuthorityDDO.setAuthSource(CharSequenceUtil.blankToDefault((CharSequence)paramVO.getAuthSource(), (String)ScpUdcEnum.SCPSMAN_AUTH_SOURCE_MANUAL.getValueCode()));
                return scpsmanAuthorityDDO;
            }).collect(Collectors.toList());
            log.info("\u6309\u533a\u57df\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f2:{}", (Object)JSONUtil.toJsonStr(data));
            if (CollUtil.isNotEmpty(data)) {
                List<ScpsmanAuthorityDDO> filterExisting = this.filterExisting(data, paramVO.getMasId());
                log.info("\u6309\u533a\u57df\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f3,\u8fc7\u6ee4\u540e:{}", (Object)JSONUtil.toJsonStr(filterExisting));
                this.scpDemandAuthorityDRepo.saveAll(filterExisting);
            }
        }
    }

    private List<ScpsmanAuthorityDDO> filterExisting(List<ScpsmanAuthorityDDO> data, Long masId) {
        List<ScpsmanAuthorityDRespVO> existedAll = this.scpDemandAuthorityDRepoProc.findbyMasId(masId);
        List existedStWhCodeAll = existedAll.stream().map(e -> e.getStWhCode()).collect(Collectors.toList());
        List<ScpsmanAuthorityDDO> filterData = data.stream().filter(e -> !existedStWhCodeAll.contains(e.getStWhCode())).collect(Collectors.toList());
        return filterData;
    }

    @Override
    public void saveWhStore(ScpManAuthorityWhStoreParamVO paramVO) {
        ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
        scpsmanAuthorityDDO.setMasId(paramVO.getMasId());
        scpsmanAuthorityDDO.setStWhId(paramVO.getStWhId());
        scpsmanAuthorityDDO.setStWhCode(paramVO.getStWhCode());
        scpsmanAuthorityDDO.setStWhName(paramVO.getStWhName());
        scpsmanAuthorityDDO.setType(paramVO.getType());
        scpsmanAuthorityDDO.setRegion(paramVO.getRegion());
        scpsmanAuthorityDDO.setAuthSource(CharSequenceUtil.blankToDefault((CharSequence)paramVO.getAuthSource(), (String)ScpUdcEnum.SCPSMAN_AUTH_SOURCE_MANUAL.getValueCode()));
        this.scpDemandAuthorityDRepo.save(scpsmanAuthorityDDO);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u8ba1\u5212\u5458\u6743\u9650ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.scpDemandAuthorityDService.deleteByIds(ids);
        this.scpDemandAuthorityService.deleteByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByDIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.scpDemandAuthorityDService.deleteByDIds(ids);
    }

    @Override
    public Optional<ScpsmanAuthorityRespVO> findIdOne(Long id) {
        Optional<ScpsmanAuthorityRespVO> scpManAuthorityRespVO = this.scpDemandAuthorityRepo.findById(id).map(ScpDemandAuthorityConvert.INSTANCE::doToVO);
        if (scpManAuthorityRespVO.isPresent()) {
            List<ScpsmanAuthorityDRespVO> scpsmanAuthorityDRespVOS = this.scpDemandAuthorityDService.findbyMasId(id);
            ScpsmanAuthorityRespVO respVO = scpManAuthorityRespVO.get();
            respVO.setScpsmanAuthorityDRespVOList(scpsmanAuthorityDRespVOS);
        }
        this.translate(scpManAuthorityRespVO.get());
        return scpManAuthorityRespVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveScpAuthority(ScpManAuthoritySaveVO saveVO) {
        Map authorityDDOMap;
        log.info("\u5165\u53c2:{}", (Object)JSONUtil.toJsonStr((Object)saveVO));
        List<ScpManAuthorityDSaveVO> scpManAuthorityDSaveVOS = saveVO.getScpManAuthorityDSaveVOS();
        log.info("\u8fc7\u6ee4\u524d:{}", (Object)JSONUtil.toJsonStr(scpManAuthorityDSaveVOS));
        List distinctScpManAuthorityDSaveVOS = scpManAuthorityDSaveVOS.stream().collect(Collectors.collectingAndThen(Collectors.toMap(ScpManAuthorityDSaveVO::getStWhCode, vo -> vo, (existing, replacement) -> existing), map -> new ArrayList(map.values())));
        log.info("\u8fc7\u6ee4\u540e:{}", (Object)JSONUtil.toJsonStr((Object)distinctScpManAuthorityDSaveVOS));
        saveVO.setScpManAuthorityDSaveVOS(distinctScpManAuthorityDSaveVOS);
        Long masId = saveVO.getId();
        Map<Object, Object> map2 = authorityDDOMap = masId == null ? Collections.emptyMap() : this.scpDemandAuthorityDRepoProc.listByMasId(masId).stream().collect(Collectors.toMap(t -> t.getType() + ":" + t.getStWhId(), Function.identity(), (t1, t2) -> t1));
        if (masId != null) {
            this.scpDemandAuthorityDService.deleteByIds(Arrays.asList(masId));
        } else if (this.scpDemandAuthorityService.existsByscpsmanNo(saveVO)) {
            throw new BusinessException("\u5f53\u524d\u8ba1\u5212\u5458\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        this.checkMessage(saveVO);
        ScpsmanAuthorityDO scpsmanAuthorityDO = ScpDemandAuthorityConvert.INSTANCE.voToDo(saveVO);
        Long aLong = this.scpDemandAuthorityService.saveScpManAuthority(scpsmanAuthorityDO);
        if (CollectionUtil.isNotEmpty(saveVO.getScpManAuthorityDSaveVOS())) {
            List<ScpsmanAuthorityDDO> collect = saveVO.getScpManAuthorityDSaveVOS().stream().map(t -> {
                t.setMasId(aLong);
                if (CharSequenceUtil.isBlank((CharSequence)t.getAuthSource())) {
                    t.setAuthSource(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_MANUAL.getValueCode());
                }
                ScpsmanAuthorityDDO doo = ScpDemandAuthorityDConvert.INSTANCE.voToDo((ScpManAuthorityDSaveVO)t);
                doo.setId(null);
                ScpsmanAuthorityDDO oldData = (ScpsmanAuthorityDDO)authorityDDOMap.get(t.getType() + ":" + t.getStWhId());
                if (oldData != null) {
                    doo.setAuthSourceId(oldData.getAuthSourceId());
                }
                return doo;
            }).collect(Collectors.toList());
            this.scpDemandAuthorityDService.saveScpManAuthority(collect);
        }
        return aLong;
    }

    @Override
    public List<ScpManAuthorityPageRespVO> findByScpsmanNoIn(List<String> scpsmanNoList) {
        List<ScpManAuthorityPageRespVO> byScpsmanNoIn = this.scpDemandAuthorityService.findByScpsmanNoIn(scpsmanNoList);
        byScpsmanNoIn.stream().forEach(t -> t.setEnableStatusName(ObjectUtil.equal((Object)t.getEnableStatus(), null) ? null : (t.getEnableStatus() != false ? "\u542f\u7528" : "\u7981\u7528")));
        return byScpsmanNoIn;
    }

    @Override
    public ApiResult<Boolean> createdByEmployee(String employeeCode) {
        if (CharSequenceUtil.isBlank((CharSequence)employeeCode)) {
            return ApiResult.fail((String)"\u5458\u5de5\u7f16\u7801\u4e3a\u7a7a");
        }
        this.taskExecutor.execute(() -> this.updateForEmployee(employeeCode));
        return ApiResult.ok((Object)true);
    }

    private void updateForEmployee(String employeeCode) {
        List<OrgStoreBaseRpcDTO> orgStoreListOfOrg;
        SysEmployeeDetailDTO employee = (SysEmployeeDetailDTO)this.employeeRpcService.getDetailByCode(employeeCode).computeData();
        if (employee == null) {
            log.error("\u5458\u5de5\u4e0d\u5b58\u5728\uff1a{}", (Object)employeeCode);
            return;
        }
        Set<String> orgCodes = CollUtil.isEmpty((Collection)employee.getOrgList()) ? Collections.emptySet() : employee.getOrgList().stream().map(SysEmployeeDetailDTO.EmployeeOrg::getOrgCode).filter(StringUtils::hasText).collect(Collectors.toSet());
        Set<Long> orgIds = CollUtil.isEmpty((Collection)employee.getOrgList()) ? Collections.emptySet() : employee.getOrgList().stream().map(SysEmployeeDetailDTO.EmployeeOrg::getOrgId).filter(Objects::nonNull).collect(Collectors.toSet());
        Long scpsmanId = this.scpsmanInfoRepoProc.getIdByCode(employeeCode);
        Long scpsmanAuthorityId = scpsmanId == null ? null : this.scpDemandAuthorityRepoProc.getIdByScpsManId(scpsmanId);
        List<OrgStoreBaseRpcDTO> orgStoreListOfRegion = null;
        Map<String, OrgRegionDTO> regionMap = this.queryRegionByOrg(orgCodes);
        if (regionMap.isEmpty()) {
            if (scpsmanAuthorityId != null) {
                this.scpDemandAuthorityDRepoProc.deleteByAuthSource(scpsmanAuthorityId, ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_REGION.getValueCode(), Set.of(employeeCode));
            }
        } else {
            orgStoreListOfRegion = this.queryOrgStoreByRegion(regionMap);
        }
        if (CollUtil.isEmpty(orgStoreListOfOrg = this.queryOrgStoreByOrg(orgIds)) && scpsmanAuthorityId != null) {
            this.scpDemandAuthorityDRepoProc.deleteByAuthSource(scpsmanAuthorityId, ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE.getValueCode(), Set.of(employeeCode));
        }
        if (CollUtil.isEmpty(orgStoreListOfRegion) && CollUtil.isEmpty(orgStoreListOfOrg)) {
            long numOfAuthority;
            if (scpsmanAuthorityId != null && (numOfAuthority = this.scpDemandAuthorityDRepoProc.countByMasId(scpsmanAuthorityId)) == 0L) {
                this.scpDemandAuthorityRepoProc.delete(scpsmanAuthorityId);
                this.scpsmanInfoRepoProc.delete(scpsmanId);
                this.userRpcService.removeUserType(employee.getUserId(), "scpsman", scpsmanId.toString());
            }
            return;
        }
        if (scpsmanId == null) {
            scpsmanId = this.createScpsmanInfo(employee, orgCodes);
        }
        scpsmanAuthorityId = this.getOrCreateScpsmanAuthority(scpsmanId);
        if (CollUtil.isNotEmpty(orgStoreListOfRegion)) {
            this.updateByStoreOfEmployee(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_REGION, scpsmanAuthorityId, employee, orgStoreListOfRegion);
        }
        if (CollUtil.isNotEmpty(orgStoreListOfOrg)) {
            this.updateByStoreOfEmployee(ScpUdcEnum.SCPSMAN_AUTH_SOURCE_EMP_STORE, scpsmanAuthorityId, employee, orgStoreListOfOrg);
        }
    }

    private void updateByStoreOfEmployee(ScpUdcEnum authSource, long scpsmanAuthorityId, SysEmployeeDetailDTO employee, List<OrgStoreBaseRpcDTO> orgStoreList) {
        List authorityList;
        String authSourceId = employee.getCode();
        List<Long> currentAuthorityIds = this.scpDemandAuthorityDRepoProc.getStWhIdListByMasId(scpsmanAuthorityId, 0);
        if (!currentAuthorityIds.isEmpty()) {
            this.scpDemandAuthorityDRepoProc.deleteByAuthSource(scpsmanAuthorityId, authSource.getValueCode(), Set.of(authSourceId));
        }
        if (!(authorityList = orgStoreList.stream().map(t -> {
            ScpsmanAuthorityDDO scpsmanAuthorityDDO = new ScpsmanAuthorityDDO();
            scpsmanAuthorityDDO.setMasId(scpsmanAuthorityId);
            scpsmanAuthorityDDO.setStWhId(t.getId());
            scpsmanAuthorityDDO.setStWhCode(t.getStoreCode());
            scpsmanAuthorityDDO.setStWhName(t.getStoreName());
            scpsmanAuthorityDDO.setType(0);
            scpsmanAuthorityDDO.setRegion(t.getRegion());
            scpsmanAuthorityDDO.setAuthSource(authSource.getValueCode());
            scpsmanAuthorityDDO.setAuthSourceId(authSourceId);
            return scpsmanAuthorityDDO;
        }).collect(Collectors.toList())).isEmpty()) {
            this.scpDemandAuthorityDRepoProc.save(authorityList);
        }
    }

    private Map<String, SysOrgBasicDTO> filterCompanyOfEmployee(SysEmployeeDetailDTO employee) {
        if (CollUtil.isEmpty((Collection)employee.getOrgList())) {
            return Collections.emptyMap();
        }
        HashMap<String, SysOrgBasicDTO> orgCompanyMap = new HashMap<String, SysOrgBasicDTO>(employee.getOrgList().size());
        block0: for (SysEmployeeDetailDTO.EmployeeOrg employeeOrg : employee.getOrgList()) {
            if (CollUtil.isEmpty((Collection)employeeOrg.getOrgList())) continue;
            for (int i = employeeOrg.getOrgList().size() - 1; i >= 0; --i) {
                SysOrgBasicDTO org = (SysOrgBasicDTO)employeeOrg.getOrgList().get(i);
                if (!OrgType.COMPANY.getValue().equals(org.getType())) continue;
                orgCompanyMap.put(employeeOrg.getOrgCode(), org);
                continue block0;
            }
        }
        return orgCompanyMap;
    }

    private Long createScpsmanInfo(SysEmployeeDetailDTO employee, Set<String> orgCodes) {
        Map companyMap;
        Map<String, SysOrgBasicDTO> regionCompanyMap = this.filterCompanyOfEmployee(employee);
        if (regionCompanyMap.isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5458\u5de5\u7684\u6240\u5c5e\u516c\u53f8");
        }
        List companyCodes = regionCompanyMap.values().stream().map(SysOrgBasicDTO::getCode).filter(StringUtils::hasText).collect(Collectors.toList());
        Map<Object, Object> map = companyMap = companyCodes.isEmpty() ? Collections.emptyMap() : this.orgOuRpcService.findSimpleByOuCodes(companyCodes).stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, Function.identity(), (t1, t2) -> t1));
        if (regionCompanyMap.isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5458\u5de5\u7684\u6240\u5c5e\u516c\u53f8");
        }
        SalesmanInfoSaveVO salesmanInfoSaveVO = new SalesmanInfoSaveVO();
        salesmanInfoSaveVO.setUserId(employee.getId());
        salesmanInfoSaveVO.setScpsmanNo(employee.getCode());
        salesmanInfoSaveVO.setLoginAccount(employee.getUsername());
        salesmanInfoSaveVO.setName(employee.getFullName());
        salesmanInfoSaveVO.setPhone(employee.getPhone());
        salesmanInfoSaveVO.setEmail(employee.getEmail());
        salesmanInfoSaveVO.setSex(Gender.FEMALE.getValue().equals(employee.getGender()) ? 2 : 1);
        salesmanInfoSaveVO.setBirthdayTime(DatetimeUtil.toStr((LocalDate)employee.getBirthDate()));
        salesmanInfoSaveVO.setIdCardNo(employee.getIdCard());
        salesmanInfoSaveVO.setDetailedAddress(employee.getAddress());
        salesmanInfoSaveVO.setJoinTime(employee.getJoinTime() == null ? null : DatetimeUtil.toStr((LocalDate)employee.getJoinTime().toLocalDate()));
        SysEmployeeDetailDTO.EmployeeOrg employeeOrg = null;
        OrgOuRpcSimpleDTO ou = null;
        block0: for (Map.Entry<String, SysOrgBasicDTO> entry : regionCompanyMap.entrySet()) {
            OrgOuRpcSimpleDTO company = (OrgOuRpcSimpleDTO)companyMap.get(entry.getValue().getCode());
            if (company == null) continue;
            ou = company;
            for (SysEmployeeDetailDTO.EmployeeOrg empOrg : employee.getOrgList()) {
                if (!empOrg.getOrgCode().equals(entry.getKey())) continue;
                employeeOrg = empOrg;
                break block0;
            }
        }
        Assert.notNull(ou, (String)"\u672a\u67e5\u8be2\u5230\u5458\u5de5\u7684\u516c\u53f8");
        Assert.notNull(employeeOrg, (String)"\u672a\u67e5\u8be2\u5230\u5458\u5de5\u7684\u7ec4\u7ec7");
        salesmanInfoSaveVO.setOuId(ou.getId().toString());
        salesmanInfoSaveVO.setOuName(ou.getOuName());
        salesmanInfoSaveVO.setOuCode(ou.getOuCode());
        salesmanInfoSaveVO.setBuName(employeeOrg.getOrgName());
        salesmanInfoSaveVO.setBuCode(employeeOrg.getOrgCode());
        salesmanInfoSaveVO.setBuId(employeeOrg.getOrgId());
        salesmanInfoSaveVO.setOrgIdBelong(employeeOrg.getOrgId().toString());
        salesmanInfoSaveVO.setSource("EMP");
        this.scpsmanInfoService.save(salesmanInfoSaveVO).computeData();
        Long id = this.scpsmanInfoRepoProc.getIdByCode(employee.getCode());
        Assert.notNull((Object)id, (String)"\u4fdd\u5b58\u5931\u8d25");
        return id;
    }

    private Long getOrCreateScpsmanAuthority(long scpsmanId) {
        Long scpsmanAuthorityId = this.scpDemandAuthorityRepoProc.getIdByScpsManId(scpsmanId);
        if (scpsmanAuthorityId != null) {
            return scpsmanAuthorityId;
        }
        ScpsmanInfoDO scpsmanInfo = (ScpsmanInfoDO)((Object)this.scpsmanInfoRepoProc.get(scpsmanId));
        Assert.notNull((Object)((Object)scpsmanInfo), (String)"\u8ba1\u5212\u5458\u4fe1\u606f\u4e3a\u7a7a");
        ScpsmanAuthorityDO authorityDO = new ScpsmanAuthorityDO();
        authorityDO.setScpsmanId(scpsmanId);
        authorityDO.setScpsmanNo(scpsmanInfo.getScpsmanNo());
        authorityDO.setOuId(scpsmanInfo.getOuId());
        authorityDO.setOuName(scpsmanInfo.getOuName());
        authorityDO.setOuCode(scpsmanInfo.getOuCode());
        authorityDO.setEnableStatus(true);
        this.scpDemandAuthorityService.saveScpManAuthority(authorityDO);
        return authorityDO.getId();
    }

    private List<OrgStoreBaseRpcDTO> queryOrgStoreByRegion(Map<String, OrgRegionDTO> regionMap) {
        Map orgMap = (Map)this.orgRpcService.queryChildrenList(regionMap.keySet()).computeData();
        List<String> orgCodes = orgMap.values().stream().flatMap(Collection::stream).map(IdCodeNameParam::getCode).collect(Collectors.toList());
        return this.rmiOrgStoreRpcService.findOrgStoreBaseByRegion(orgCodes);
    }

    private List<OrgStoreBaseRpcDTO> queryOrgStoreByOrg(Set<Long> orgIds) {
        if (CollUtil.isEmpty(orgIds)) {
            return Collections.emptyList();
        }
        return this.rmiOrgStoreRpcService.findOrgStoreBaseByBuIds(new ArrayList<Long>(orgIds));
    }

    private Map<String, OrgRegionDTO> queryRegionByOrg(Set<String> orgCodes) {
        if (CollUtil.isEmpty(orgCodes)) {
            return Collections.emptyMap();
        }
        OrgRegionQueryDTO queryDTO = new OrgRegionQueryDTO();
        queryDTO.setRegionCodes(orgCodes);
        List regionList = (List)this.orgRegionRpcService.queryList(queryDTO).computeData();
        if (CollUtil.isEmpty((Collection)regionList)) {
            return Collections.emptyMap();
        }
        return regionList.stream().collect(Collectors.toMap(OrgRegionDTO::getRegionCode, Function.identity(), (t1, t2) -> t1));
    }

    private void checkMessage(ScpManAuthoritySaveVO saveVO) {
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        scpManAuthorityParam.setScpsmanId(saveVO.getScpsmanId());
        scpManAuthorityParam.setScpsmanNo(saveVO.getScpsmanNo());
        scpManAuthorityParam.setOuCode(saveVO.getOuCode());
        scpManAuthorityParam.setOuId(saveVO.getOuId());
        List<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOS = this.scpDemandAuthorityService.listQuery(scpManAuthorityParam);
        List<ScpManAuthorityDSaveVO> scpManAuthorityDSaveVOS = saveVO.getScpManAuthorityDSaveVOS();
        ArrayList checkflag = new ArrayList();
        scpManAuthorityDSaveVOS.stream().forEach(t -> checkflag.add(t.getType() + t.getStWhCode() + t.getStWhName()));
        if (CollectionUtil.isEmpty(scpManAuthorityPageRespVOS)) {
            return;
        }
        if (saveVO.getId() == null) {
            scpManAuthorityPageRespVOS.stream().forEach(t -> {
                String log = t.getType() + t.getStWhCode() + t.getStWhName();
                List checkList = checkflag.stream().filter(f -> f.equals(log)).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(checkList)) {
                    throw new BusinessException("\u8ba1\u5212\u5458\u59d3\u540d\uff1a" + saveVO.getScpsmanName() + ",\u516c\u53f8\uff1a" + saveVO.getOuName() + ",\u95e8\u5e97\u540d\u79f0/\u4ed3\u5e93\u540d\u79f0:" + t.getStWhName() + ";\u6570\u636e\u91cd\u590d");
                }
            });
        }
        if (saveVO.getId() != null) {
            List collect = scpManAuthorityPageRespVOS.stream().filter(t -> t.getId().compareTo(saveVO.getId()) != 0).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(collect)) {
                return;
            }
            collect.stream().forEach(check -> {
                String log = check.getType() + check.getStWhCode() + check.getStWhName();
                List checkList = checkflag.stream().filter(f -> f.equals(log)).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(checkList)) {
                    throw new BusinessException("\u8ba1\u5212\u5458\u59d3\u540d\uff1a" + saveVO.getScpsmanName() + ",\u516c\u53f8\uff1a" + saveVO.getOuName() + ",\u95e8\u5e97\u540d\u79f0/\u4ed3\u5e93\u540d\u79f0:" + check.getStWhName() + ";\u6570\u636e\u91cd\u590d");
                }
            });
        }
    }

    private void translate(ScpsmanAuthorityRespVO scpsmanAuthorityRespVO) {
        scpsmanAuthorityRespVO.setEnableStatusName(ObjectUtil.equal((Object)scpsmanAuthorityRespVO.getEnableStatus(), null) ? null : (scpsmanAuthorityRespVO.getEnableStatus() != false ? "\u542f\u7528" : "\u7981\u7528"));
        ScpsmanInfoDO byScpsmanNo = this.scpsmanInfoRepo.findByScpsmanNo(scpsmanAuthorityRespVO.getScpsmanNo());
        if (ObjectUtil.isEmpty((Object)((Object)byScpsmanNo))) {
            return;
        }
        scpsmanAuthorityRespVO.setScpsman(byScpsmanNo.getName());
    }

    public ScpsmanAuthprityServiceImpl(ScpDemandAuthorityService scpDemandAuthorityService, ScpDemandAuthorityRepo scpDemandAuthorityRepo, ScpDemandAuthorityRepoProc scpDemandAuthorityRepoProc, ScpDemandAuthorityDService scpDemandAuthorityDService, ScpsmanInfoRepo scpsmanInfoRepo, ScpsmanInfoRepoProc scpsmanInfoRepoProc, RmiInvStkRpcService rmiInvStkRpcService, RmiOrgStoreRpcService rmiOrgStoreRpcService, ScpDemandAuthorityDRepo scpDemandAuthorityDRepo, ScpDemandAuthorityDRepoProc scpDemandAuthorityDRepoProc, ScpsmanInfoService scpsmanInfoService, EmployeeRpcService employeeRpcService, UserRpcService userRpcService, OrgRegionRpcService orgRegionRpcService, OrgRpcService orgRpcService, OrgOuRpcService orgOuRpcService, TaskExecutor taskExecutor) {
        this.scpDemandAuthorityService = scpDemandAuthorityService;
        this.scpDemandAuthorityRepo = scpDemandAuthorityRepo;
        this.scpDemandAuthorityRepoProc = scpDemandAuthorityRepoProc;
        this.scpDemandAuthorityDService = scpDemandAuthorityDService;
        this.scpsmanInfoRepo = scpsmanInfoRepo;
        this.scpsmanInfoRepoProc = scpsmanInfoRepoProc;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.scpDemandAuthorityDRepo = scpDemandAuthorityDRepo;
        this.scpDemandAuthorityDRepoProc = scpDemandAuthorityDRepoProc;
        this.scpsmanInfoService = scpsmanInfoService;
        this.employeeRpcService = employeeRpcService;
        this.userRpcService = userRpcService;
        this.orgRegionRpcService = orgRegionRpcService;
        this.orgRpcService = orgRpcService;
        this.orgOuRpcService = orgOuRpcService;
        this.taskExecutor = taskExecutor;
    }
}

