/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.strategy;

import cn.hutool.core.lang.Assert;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderComputeVO;
import com.elitesland.scp.application.service.strategy.EventStrategy;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class EventContext
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(EventContext.class);
    private final List<EventStrategy> eventStrategieList;
    private static Map<String, EventStrategy> STRATEGY_MAP = new HashMap<String, EventStrategy>(16);

    public void consumeEventInvStk(List<ScpDemandOrderComputeVO> storeParamVOS, BigDecimal warehouse, String allocRuleType) {
        EventStrategy eventStrategy = STRATEGY_MAP.get(allocRuleType);
        Assert.notNull((Object)eventStrategy, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5206\u914d\u7b56\u7565", (Object[])new Object[0]);
        eventStrategy.handleInvStk(storeParamVOS, warehouse);
    }

    public EventStrategy getEvent(@NonNull String allocRuleType) {
        if (allocRuleType == null) {
            throw new NullPointerException("allocRuleType is marked non-null but is null");
        }
        return STRATEGY_MAP.get(allocRuleType);
    }

    public void afterPropertiesSet() {
        this.eventStrategieList.forEach(eventStrategy -> eventStrategy.getAllocRuleTypes().forEach(allocRuleType -> {
            STRATEGY_MAP.put((String)allocRuleType, (EventStrategy)eventStrategy);
            log.info("\u7b56\u7565\u7c7b\u578b\uff1a{}\uff0c\u7b56\u7565\u5b9e\u73b0\uff1a{}", allocRuleType, (Object)eventStrategy.getClass().getName());
        }));
    }

    public EventContext(List<EventStrategy> eventStrategieList) {
        this.eventStrategieList = eventStrategieList;
    }
}

