package com.elitesland.scp.pay.service;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.utils.MessageDelyQueueService;
import com.tenpay.business.entpay.mse.sdk.api.Redirect;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.RedirectParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.concurrent.TimeUnit;

@Slf4j
@Service
@RequiredArgsConstructor
public class AccountLinkServiceImpl implements AccountLinkService {

    private final RedisUtils redisUtils;
    private final MessageDelyQueueService messageDelyQueueService;

    @Override
    public Redirect createPaymentLink(String paymentId, String docNo, Date expireTime) throws EntpayException {
        // 获取收银台链接
        RedirectParam redirectParam = RedirectParam.builder()
                .id(paymentId)
                .build();
        Redirect redirect = Redirect.create(redirectParam);
        log.info("获取支付跳转链接：{}", redirect);
        redisUtils.set(ScpConstant.SCP_ONLINE_PAY + docNo, JSONUtil.toJsonStr(redirect), 25, TimeUnit.HOURS);
        messageDelyQueueService.resettingOrderExpireTime(docNo, expireTime.getTime() - (new Date().getTime()));
        return redirect;
    }
}
