/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.cart;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.cart.CartChangeSelectedStatusAllParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartChangeSelectedStatusParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartCountParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartDataSummaryParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartDataSummaryRespVO;
import com.elitesland.scp.application.facade.vo.cart.CartDeleteItemParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartDetailParamVO;
import com.elitesland.scp.application.facade.vo.cart.CartDetailRespVO;
import com.elitesland.scp.application.facade.vo.cart.OrderCheckParamVO;
import com.elitesland.scp.application.facade.vo.cart.OrderCheckRespVO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartBatchSaveVO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartQueryParamVO;
import com.elitesland.scp.application.facade.vo.cart.StoreCartSaveVO;
import com.elitesland.scp.application.service.cart.ScpStoreCartService;
import com.elitesland.scp.application.web.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cart"}, produces={"application/json"})
@Api(value="\u79fb\u52a8\u7aef-\u91c7\u8d2d\u8f66\u7ba1\u7406", tags={"\u79fb\u52a8\u7aef-\u91c7\u8d2d\u8f66\u7ba1\u7406"})
public class CartManageController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(CartManageController.class);
    private final ScpStoreCartService scpStoreCartService;

    @PostMapping(value={"/detail"})
    @ApiOperation(value="\u91c7\u8d2d\u8f66\u8be6\u60c5")
    public ApiResult<List<CartDetailRespVO>> detail(@RequestBody @Validated CartDetailParamVO paramVO) {
        log.info("[SCP-CART] detail  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        return ApiResult.ok(this.scpStoreCartService.detail(paramVO));
    }

    @PostMapping(value={"/count"})
    @ApiOperation(value="\u91c7\u8d2d\u8f66\u6570\u91cf\u6c47\u603b")
    public ApiResult<Map<String, Integer>> count(@RequestBody @Validated StoreCartQueryParamVO paramVO) {
        log.info("[SCP-CART] count  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        return ApiResult.ok(this.scpStoreCartService.getCartCount(paramVO));
    }

    @PostMapping(value={"/addItem"})
    @ApiOperation(value="\u91c7\u8d2d\u8f66\u6dfb\u52a0\u5546\u54c1")
    public ApiResult<Map<Long, BigDecimal>> addItem(@RequestBody @Validated StoreCartSaveVO saveVO) {
        log.info("[SCP-CART] addItem  saveVO ={}", (Object)JSONUtil.toJsonStr((Object)saveVO));
        return ApiResult.ok(this.scpStoreCartService.saveCart(saveVO));
    }

    @PostMapping(value={"/batch/addItem"})
    @ApiOperation(value="\u91c7\u8d2d\u8f66\u6279\u91cf\u6dfb\u52a0\u5546\u54c1")
    public ApiResult<Map<Long, BigDecimal>> batchAddItem(@RequestBody @Validated StoreCartBatchSaveVO saveVO) {
        log.info("[SCP-CART] batchAddItem  saveVO ={}", (Object)JSONUtil.toJsonStr((Object)saveVO));
        this.scpStoreCartService.batchSaveCart(saveVO.getDemandWhStCode(), saveVO.getCartType(), saveVO.getCartSaveVOList());
        return ApiResult.ok();
    }

    @PostMapping(value={"/updateCount"})
    @ApiOperation(value="\u91c7\u8d2d\u8f66\u66f4\u65b0\u6570\u91cf")
    public ApiResult<Object> updateCount(@RequestBody CartCountParamVO cartCountParamVO) {
        log.info("[SCP-CART] updateCount  saveVO ={}", (Object)JSONUtil.toJsonStr((Object)cartCountParamVO));
        this.scpStoreCartService.updateCount(cartCountParamVO);
        return ApiResult.ok();
    }

    @PostMapping(value={"/deleteItem"})
    @ApiOperation(value="\u91c7\u8d2d\u8f66\u5220\u9664\u5546\u54c1")
    public ApiResult<String> deleteItem(@RequestBody @Validated CartDeleteItemParamVO paramVO) {
        log.info("[SCP-CART] deleteItem  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        this.scpStoreCartService.deleteItem(paramVO);
        return ApiResult.ok();
    }

    @PostMapping(value={"/dataSummary"})
    @ApiOperation(value="\u91c7\u8d2d\u8f66\u6570\u636e\u6c47\u603b")
    public ApiResult<CartDataSummaryRespVO> dataSummary(@RequestBody @Validated CartDataSummaryParamVO paramVO) {
        log.info("[SCP-CART] dataSummary  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        return ApiResult.ok((Object)this.scpStoreCartService.dataSummary(paramVO));
    }

    @PostMapping(value={"/order"})
    @ApiOperation(value="\u4e0b\u5355")
    public ApiResult<OrderCheckRespVO> order(@RequestBody @Validated OrderCheckParamVO orderCheckParamVO) {
        log.info("[SCP-CART] order  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)orderCheckParamVO));
        return ApiResult.ok((Object)this.scpStoreCartService.order(orderCheckParamVO));
    }

    @PostMapping(value={"/changeSelectedStatus"})
    @ApiOperation(value="\u91c7\u8d2d\u8f66\u9009\u62e9\u72b6\u6001\u66f4\u65b0")
    public ApiResult<String> changeSelectedStatus(@RequestBody @Validated CartChangeSelectedStatusParamVO paramVO) {
        log.info("[SCP-CART] changeSelectedStatus  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        this.scpStoreCartService.changeSelectedStatus(paramVO);
        return ApiResult.ok();
    }

    @PostMapping(value={"/changeSelectedStatus/all"})
    @ApiOperation(value="\u91c7\u8d2d\u8f66\u5168\u9009/\u53d6\u6d88\u5168\u9009\u72b6\u6001\u66f4\u65b0")
    public ApiResult<String> changeSelectedStatusAll(@RequestBody @Validated CartChangeSelectedStatusAllParamVO paramVO) {
        log.info("[SCP-CART] changeSelectedStatusAll  paramVO ={}", (Object)JSONUtil.toJsonStr((Object)paramVO));
        this.scpStoreCartService.changeSelectedStatusAll(paramVO);
        return ApiResult.ok();
    }

    public CartManageController(ScpStoreCartService scpStoreCartService) {
        this.scpStoreCartService = scpStoreCartService;
    }
}

