/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.feedback.impl;

import com.alibaba.fastjson.JSONObject;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackQueryParamVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackRespVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.feedback.ScpStoreFeedbackConvert;
import com.elitesland.scp.domain.entity.feedback.QScpStoreFeedbackDO;
import com.elitesland.scp.domain.entity.feedback.ScpStoreFeedbackDO;
import com.elitesland.scp.domain.service.feedback.ScpStoreFeedbackDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.feedback.ScpStoreFeedbackRepo;
import com.elitesland.scp.infr.repo.feedback.ScpStoreFeedbackRepoProc;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.github.houbb.sensitive.word.bs.SensitiveWordBs;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="scpStoreFeedbackDomainService")
public class ScpStoreFeedbackDomainServiceImpl
implements ScpStoreFeedbackDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreFeedbackDomainServiceImpl.class);
    private final ScpStoreFeedbackRepo scpStoreFeedbackRepo;
    private final ScpStoreFeedbackRepoProc scpStoreFeedbackRepoProc;
    private final SensitiveWordBs sensitiveWordBs;

    @Override
    public PagingVO<ScpStoreFeedbackRespVO> search(ScpStoreFeedbackQueryParamVO param) {
        Page ret = this.scpStoreFeedbackRepo.findAll(this.scpStoreFeedbackRepoProc.where(param), (Pageable)param.getPageRequest());
        List<ScpStoreFeedbackRespVO> vos = ret.getContent().stream().map(ScpStoreFeedbackConvert.INSTANCE::doToVO).collect(Collectors.toList());
        vos.forEach(item -> {
            if (item.getFileUrl() != null) {
                item.setFileUrlList(JSONObject.parseArray((String)item.getFileUrl(), ScpStoreFeedbackRespVO.FileObject.class));
            }
            String replace = this.sensitiveWordBs.replace(item.getEvaluationComment());
            item.setEvaluationComment(replace);
            String replace1 = this.sensitiveWordBs.replace(item.getOptimizationSuggestion());
            item.setOptimizationSuggestion(replace1);
        });
        return PagingVO.builder().total(ret.getTotalElements()).records(vos).build();
    }

    @Override
    public Optional<ScpStoreFeedbackRespVO> findCodeOne(String itemCode) {
        JPAQuery<ScpStoreFeedbackRespVO> jpaQuery = this.scpStoreFeedbackRepoProc.select(null);
        QScpStoreFeedbackDO jpaQDo = QScpStoreFeedbackDO.scpStoreFeedbackDO;
        ScpStoreFeedbackRespVO vo = (ScpStoreFeedbackRespVO)jpaQuery.fetchOne();
        return Optional.ofNullable(vo);
    }

    @Override
    public Optional<ScpStoreFeedbackRespVO> findIdOne(Long id) {
        return this.scpStoreFeedbackRepo.findById(id).map(ScpStoreFeedbackConvert.INSTANCE::doToVO);
    }

    @Override
    public List<ScpStoreFeedbackRespVO> findIdBatch(List<Long> idList) {
        return this.scpStoreFeedbackRepo.findAllById(idList).stream().map(ScpStoreFeedbackConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public Long createOne(ScpStoreFeedbackSaveVO param) {
        ScpStoreFeedbackDO objDo = ScpStoreFeedbackConvert.INSTANCE.saveParamToDo(param);
        if (param.getId() != null && param.getId() > 0L) {
            Optional optional = this.scpStoreFeedbackRepo.findById(objDo.getId());
            if (optional.isPresent()) {
                BeanCopyUtil.beanCopyWithIngore((Object)objDo, (Object)((ScpStoreFeedbackDO)optional.get()), (String[])BeanCopyUtil.getNullPropertyNames((Object)objDo));
                this.scpStoreFeedbackRepo.save((ScpStoreFeedbackDO)optional.get());
            } else {
                throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
            }
        }
        return ((ScpStoreFeedbackDO)this.scpStoreFeedbackRepo.save(objDo)).getId();
    }

    @Override
    @Transactional
    public List<ScpStoreFeedbackRespVO> createBatch(List<ScpStoreFeedbackSaveVO> list) {
        List dos = list.stream().map(ScpStoreFeedbackConvert.INSTANCE::creatParamToDo).collect(Collectors.toList());
        return this.scpStoreFeedbackRepo.saveAll(dos).stream().map(ScpStoreFeedbackConvert.INSTANCE::doToVO).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> statusChangeByProcess(long id, ProcInstStatus procInstStatus, String approveComment) {
        log.info("\u95e8\u5e97\u53cd\u9988\u5de5\u4f5c\u6d41\u56de\u8c03:{},{}", (Object)id, (Object)procInstStatus);
        Optional<ScpStoreFeedbackRespVO> optional = this.findIdOne(id);
        if (optional.isEmpty()) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        ScpStoreFeedbackRespVO scpStoreFeedbackRespVO = optional.get();
        HashMap<String, String> result = new HashMap<String, String>();
        scpStoreFeedbackRespVO.setProcInstStatus(procInstStatus);
        String docStatus = null;
        String approveStatus = null;
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        switch (procInstStatus) {
            case NOTSUBMIT: 
            case INTERRUPT: {
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DRAFT.getValueCode();
                break;
            }
            case REJECTED: {
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DONE.getValueCode();
                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_INVALID.getValueCode();
                break;
            }
            case INVALID: {
                break;
            }
            case APPROVING: {
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_APPROVING.getValueCode();
                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_APPROVING.getValueCode();
                break;
            }
            case APPROVED: {
                docStatus = ScpUdcEnum.FEEDBACK_STATUS_DONE.getValueCode();
                approveStatus = ScpUdcEnum.FEEDBACK_APPROVAL_STATUS_VALID.getValueCode();
                scpStoreFeedbackRespVO.setApprovalTime(LocalDateTime.now());
                if (currentUserDTO == null) break;
                scpStoreFeedbackRespVO.setApprovedBy(currentUserDTO.getDetail().getLastName());
                break;
            }
            default: {
                throw new IllegalStateException("\u975e\u6cd5\u8bbf\u95ee");
            }
        }
        scpStoreFeedbackRespVO.setFeedbackStatus(docStatus);
        scpStoreFeedbackRespVO.setApprovalStatus(approveStatus);
        scpStoreFeedbackRespVO.setProcInstStatus(procInstStatus);
        scpStoreFeedbackRespVO.setRemark(approveComment);
        this.updateById(scpStoreFeedbackRespVO);
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            // empty if block
        }
        return result;
    }

    @Override
    @Transactional
    public void updateById(ScpStoreFeedbackRespVO param) {
        this.scpStoreFeedbackRepoProc.update(param);
    }

    @Override
    @Transactional
    public void update(ScpStoreFeedbackSaveVO param) {
        ScpStoreFeedbackDO objDo = ScpStoreFeedbackConvert.INSTANCE.saveParamToDo(param);
        Optional optional = this.scpStoreFeedbackRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore((Object)objDo, (Object)((ScpStoreFeedbackDO)optional.get()), (String[])BeanCopyUtil.getNullPropertyNames((Object)objDo));
        this.scpStoreFeedbackRepo.save((ScpStoreFeedbackDO)optional.get());
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        QScpStoreFeedbackDO jpaQDo = QScpStoreFeedbackDO.scpStoreFeedbackDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.scpStoreFeedbackRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        ScpStoreFeedbackDO do1 = (ScpStoreFeedbackDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.scpStoreFeedbackRepo.save(do1);
    }

    @Override
    @Transactional
    public void deleteOne(Long id) {
        this.scpStoreFeedbackRepo.deleteById(id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.scpStoreFeedbackRepo.deleteById(id));
    }

    public ScpStoreFeedbackDomainServiceImpl(ScpStoreFeedbackRepo scpStoreFeedbackRepo, ScpStoreFeedbackRepoProc scpStoreFeedbackRepoProc, SensitiveWordBs sensitiveWordBs) {
        this.scpStoreFeedbackRepo = scpStoreFeedbackRepo;
        this.scpStoreFeedbackRepoProc = scpStoreFeedbackRepoProc;
        this.sensitiveWordBs = sensitiveWordBs;
    }
}

