/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.pay.service;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitesland.scp.pay.service.AccountLinkService;
import com.elitesland.scp.utils.MessageDelyQueueService;
import com.tenpay.business.entpay.mse.sdk.api.Redirect;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.RedirectParam;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AccountLinkServiceImpl
implements AccountLinkService {
    private static final Logger log = LoggerFactory.getLogger(AccountLinkServiceImpl.class);
    private final RedisUtils redisUtils;
    private final MessageDelyQueueService messageDelyQueueService;

    @Override
    public Redirect createPaymentLink(String paymentId, String docNo, Date expireTime) throws EntpayException {
        RedirectParam redirectParam = RedirectParam.builder().id(paymentId).build();
        Redirect redirect = Redirect.create((RedirectParam)redirectParam);
        log.info("\u83b7\u53d6\u652f\u4ed8\u8df3\u8f6c\u94fe\u63a5\uff1a{}", (Object)redirect);
        this.redisUtils.set("SCP_ONLINE_PAY:" + docNo, (Object)JSONUtil.toJsonStr((Object)redirect), 25L, TimeUnit.HOURS);
        this.messageDelyQueueService.resettingOrderExpireTime(docNo, expireTime.getTime() - new Date().getTime());
        return redirect;
    }

    public AccountLinkServiceImpl(RedisUtils redisUtils, MessageDelyQueueService messageDelyQueueService) {
        this.redisUtils = redisUtils;
        this.messageDelyQueueService = messageDelyQueueService;
    }
}

