package com.elitesland.scp.infr.repo.setting;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.domain.entity.setting.QScpOrderSettingDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ScpOrderSettingRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpOrderSettingDO scpOrderSettingDO = QScpOrderSettingDO.scpOrderSettingDO;

    public long countOrderSetting(ScpOrderSettingPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(scpOrderSettingDO.count())
                .from(scpOrderSettingDO);
        jpaQuery.where(this.whereOrderSettingPage(paramVO));
        return jpaQuery.fetchCount();
    }

    private final QBean<ScpOrderSettingPageRespVO> pageList = Projections.bean(
            ScpOrderSettingPageRespVO.class,
            scpOrderSettingDO.id,
            scpOrderSettingDO.docType,
            scpOrderSettingDO.itemCate,
            scpOrderSettingDO.purScene,
            scpOrderSettingDO.purSceneName,
            scpOrderSettingDO.trnType,
            scpOrderSettingDO.firstPriority,
            scpOrderSettingDO.secPriority,
            scpOrderSettingDO.whnetFreightFlag,
            scpOrderSettingDO.suppFreightFlag,
            scpOrderSettingDO.status,
            scpOrderSettingDO.creator,
            scpOrderSettingDO.createUserId,
            scpOrderSettingDO.createTime,
            scpOrderSettingDO.updater,
            scpOrderSettingDO.modifyUserId,
            scpOrderSettingDO.modifyTime,
            scpOrderSettingDO.remark,
            scpOrderSettingDO.type
    );

    public List<ScpOrderSettingPageRespVO> queryOrderSetting(ScpOrderSettingPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(scpOrderSettingDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpOrderSettingDO);
        jpaQuery.where(this.whereOrderSettingPage(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereOrderSettingPage(ScpOrderSettingPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            predicates.add(scpOrderSettingDO.docType.eq(paramVO.getDocType()));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            predicates.add(scpOrderSettingDO.type.eq(paramVO.getType()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public void enableDemandSet(List<Long> ids, Boolean enable) {
        JPAUpdateClause update = jpaQueryFactory.update(scpOrderSettingDO)
                .set(scpOrderSettingDO.status, enable)
                .where(scpOrderSettingDO.id.in(ids));
        update.execute();
    }

    public long deleteByIds(List<Long> ids) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scpOrderSettingDO.id.in(ids));
        var delete = jpaQueryFactory.delete(scpOrderSettingDO)
                .where(ExpressionUtils.allOf(predicates));
        return delete.execute();
    }

    public List<ScpOrderSettingRespVO> findByParam(ScpOrderSettingParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpOrderSettingRespVO.class,
                        scpOrderSettingDO.id,
                        scpOrderSettingDO.docType,
                        scpOrderSettingDO.firstPriority,
                        scpOrderSettingDO.secPriority,
                        scpOrderSettingDO.type,
                        scpOrderSettingDO.itemCate,
                        scpOrderSettingDO.whnetFreightFlag,
                        scpOrderSettingDO.suppFreightFlag,
                        scpOrderSettingDO.purScene,
                        scpOrderSettingDO.purSceneName,
                        scpOrderSettingDO.trnType,
                        scpOrderSettingDO.status
                ))
                .from(scpOrderSettingDO);
        jpaQuery.where(this.whereOrderSetting(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereOrderSetting(ScpOrderSettingParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StrUtil.isNotBlank(paramVO.getDocType())) {
            predicates.add(scpOrderSettingDO.docType.eq(paramVO.getDocType()));
        }
        if (StrUtil.isNotBlank(paramVO.getItemCate())) {
            predicates.add(scpOrderSettingDO.itemCate.like("%" + paramVO.getItemCate() + "%"));
        }
        if (CollUtil.isNotEmpty(paramVO.getItemCates())) {
            predicates.add(scpOrderSettingDO.itemCate.in(paramVO.getItemCates()));
        }
        if (paramVO.getStatus() != null) {
            predicates.add(scpOrderSettingDO.status.eq(paramVO.getStatus()));
        }
        if (StrUtil.isNotBlank(paramVO.getTrnType())) {
            predicates.add(scpOrderSettingDO.trnType.eq(paramVO.getTrnType()));
        }
        if (StrUtil.isNotBlank(paramVO.getType())) {
            predicates.add(scpOrderSettingDO.type.eq(paramVO.getType()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScpOrderSettingRespVO> findEnabledSetting() {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(ScpOrderSettingRespVO.class,
                        scpOrderSettingDO.id,
                        scpOrderSettingDO.docType,
                        scpOrderSettingDO.type,
                        scpOrderSettingDO.itemCate,
                        scpOrderSettingDO.firstPriority
                ))
                .from(scpOrderSettingDO)
                .where(scpOrderSettingDO.status.eq(Boolean.TRUE));
        return jpaQuery.fetch();
    }
}
