package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.boot.provider.IdFactory;
import com.elitesland.scp.boh.StoreRtnApproveSendParam;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDDO;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveDRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 门店退货审批回写
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class StoreRtnApproveListener implements MessageQueueListener<StoreRtnApproveSendParam> {

    private final StoreReceiveRepo storeReceiveRepo;
    private final StoreReceiveDRepo storeReceiveDRepo;

    @Override
    public @NotEmpty String[] channels() {
        return new String[]{StoreRtnApproveSendParam.STORE_RTN_CHANNEL};
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onConsume(@NotBlank String s, @NotNull StoreRtnApproveSendParam storeReceiveSendParam) {
        log.info("门店退货审批回写：" + JSON.toJSONString(storeReceiveSendParam));
        if (storeReceiveSendParam.getRelateDocId() == null) {
            List<StoreReceiveDO> receiveDOS = storeReceiveRepo.findAllByDocId(storeReceiveSendParam.getDocId());
            if (CollectionUtil.isEmpty(receiveDOS)) {
                return;
            }
            StoreReceiveDO receiveDO = receiveDOS.get(0);
            receiveDO.setStatus("CE");
            receiveDO.setDeliveryDate(LocalDateTime.now());
        } else {
            List<StoreReceiveDO> receiveDOS = storeReceiveRepo.findAllByDocId(storeReceiveSendParam.getRelateDocId());
            if (CollectionUtil.isEmpty(receiveDOS)) {
                return;
            }
            StoreReceiveDO receiveDO = receiveDOS.get(0);
            receiveDO.setStatus("APPROVED");
            receiveDO.setDeliveryDate(LocalDateTime.now());

            StoreReceiveDO trnReceiveDO = new StoreReceiveDO();
            trnReceiveDO.setDocCreateDate(LocalDateTime.now());
            trnReceiveDO.setStatus("CE"); // 待退货
            trnReceiveDO.setDocId(storeReceiveSendParam.getDocId());
            trnReceiveDO.setDocNo(storeReceiveSendParam.getDocNo());
            trnReceiveDO.setOrderId(receiveDO.getOrderId());
            trnReceiveDO.setOrderNo(receiveDO.getOrderNo());
            trnReceiveDO.setOrderDate(receiveDO.getOrderDate());
            trnReceiveDO.setReceiveDate(receiveDO.getReceiveDate());
            trnReceiveDO.setDeliveryDate(receiveDO.getDeliveryDate());
            trnReceiveDO.setReceiveDocId(receiveDO.getReceiveDocId());
            trnReceiveDO.setReceiveDocNo(receiveDO.getReceiveDocNo());
            trnReceiveDO.setStoreId(receiveDO.getStoreId());
            trnReceiveDO.setOrderSetId(receiveDO.getOrderSetId());
            trnReceiveDO.setDocType("TRN");

            trnReceiveDO.setTotalAmt(storeReceiveSendParam.getItems().stream().filter(i -> i.getQty() != null && i.getPrice() != null)
                    .map(i -> i.getQty().multiply(i.getPrice())).reduce(BigDecimal.ZERO, BigDecimal::add));
            trnReceiveDO.setTotalQty(storeReceiveSendParam.getItems().stream().map(i -> i.getQty()).reduce(BigDecimal.ZERO,
                    BigDecimal::add));
            trnReceiveDO.setRtType("T");
            StoreReceiveDO saved = storeReceiveRepo.save(trnReceiveDO);

            Map<Long, BigDecimal> priceMap = storeReceiveSendParam.getItems().stream().filter(i -> i.getPrice() != null).collect(Collectors.toMap(i -> i.getDid(), i -> i.getPrice()));
            List<StoreReceiveDDO> trnReceiveDDOS = new ArrayList<>();
            for (StoreRtnApproveSendParam.OrderItem item : storeReceiveSendParam.getItems()) {
                StoreReceiveDDO storeReceiveDDO = new StoreReceiveDDO();
                storeReceiveDDO.setDid(item.getDid());
                storeReceiveDDO.setId(IdFactory.generateLong());
                storeReceiveDDO.setItemId(item.getItemId());
                storeReceiveDDO.setMasId(saved.getId());
                storeReceiveDDO.setQty(item.getQty());
                storeReceiveDDO.setPrice(priceMap.get(item.getDid()));
                trnReceiveDDOS.add(storeReceiveDDO);
            }
            storeReceiveDRepo.saveAll(trnReceiveDDOS);
        }
    }

}
