package com.elitesland.scp.pay.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tenpay.business.entpay.mse.sdk.annotation.EncryptedField;
import com.tenpay.business.entpay.mse.sdk.model.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "支付订单请求参数")
public class PayOrderReqDTO implements Serializable {
    private static final long serialVersionUID = 8492354934168504003L;

    /**
     * 平台支付单号，数字、字母、下划线、中划线任意组合，平台自定义的唯一编号
     */
    @ApiModelProperty("平台支付单号")
    private String outPaymentId;

    /**
     * 支付金额，单位：分
     */
    @ApiModelProperty("支付金额")
    private Long amount;

    @ApiModelProperty("币种")
    private String currency;

    /**
     * 过期时间，东八区时间 如:2021-06-08T10:34:56+08:00，不能超过下单时间72小时，超过则自动关单
     */
    @ApiModelProperty("过期时间")
    private Date expireTime;

    /**
     * 收款商户企业ID，即商户入驻成功时返回的企业ID
     */
    @ApiModelProperty("收款商户Id")
    private String entId;

    /**
     * 收款商户名称，对应商户入驻申请接口入参的merchant_name
     */
    @ApiModelProperty("收款商户名称")
    private String entName;

    /**
     * 订单附加信息
     * 附言，即对账文件中的“订单附加信息”字段，只支持空格、中文、数字、英文大小写、下划线、全角半角的连字符、逗号和句号
     */
    @ApiModelProperty("订单附加信息")
    private String memo;

    /**
     * 支付商品信息
     */
    private List<Goods> goods = new ArrayList();

    /**
     * 订单附加信息，附加数据，在查询API中原样返回，可作为自定义参数使用
     */
    private String attachment;


    /**
     * 设备号，终端设备号（门店号或收银设备ID），示例值：POS1:1
     */
    @ApiModelProperty("设备号")
    private String deviceId;

    /**
     * 用户终端IP，用户端实际ip，示例值：14.17.22.32
     */
    @ApiModelProperty("用户终端IP")
    private String payerClientIp;
    /**
     * 用户UA，浏览器User-Agent
     */
    @ApiModelProperty("用户UA")
    private String payerUa;
    /**
     * 下单时间
     */
    @ApiModelProperty("下单时间")
    private Date createTime;
    /**
     * 提货方式
     * SELF_PICK 自提
     * LOGISTICS 物流
     * CHANGE_OWNER 改归属
     */
    @ApiModelProperty("提货方式")
    private String pickType;
    /**
     * 提货描述
     */
    @ApiModelProperty("提货描述")
    private String pickDescription;

    @ApiModelProperty("门店编号")
    private String storeId;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("区域编码")
    private String storeAreaCode;

    @ApiModelProperty("分账标识")
    private String profitAllocationFlag;

    @ApiModelProperty("小程序路径")
    private String mpPath;

    @ApiModelProperty("付款人名称")
    private String payerName;

    @ApiModelProperty("付款类型")
    private String payerType;

    @ApiModelProperty("收款子账号ID")
    private String entAccId;

    @ApiModelProperty("银行卡号后四位")
    private String bankAccountLast4;
}
