/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.alloc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingItemSaveVO;
import com.elitesland.scp.domain.convert.alloc.ScpAllocSettingItemConvert;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingItemDO;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingRedisDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingItemDomainService;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingItemRepo;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingItemRepoProc;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpAllocSettingItemDomainServiceImpl
implements ScpAllocSettingItemDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpAllocSettingItemDomainServiceImpl.class);
    private final RedisTemplate redisTemplate;
    private final ScpAllocSettingItemRepo scpAllocSettingItemRepo;
    private final ScpAllocSettingItemRepoProc scpAllocSettingItemRepoProc;

    @Override
    @SysCodeProc
    public List<ScpAllocSettingItemRespVO> findByMasId(Long masId) {
        List<ScpAllocSettingItemDO> settingItemDOS = this.scpAllocSettingItemRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpAllocSettingItemConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<ScpAllocSettingItemRespVO>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveAllocSettingItem(List<ScpAllocSettingItemSaveVO> saveVOS) {
        this.scpAllocSettingItemRepo.saveAll(ScpAllocSettingItemConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.scpAllocSettingItemRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpAllocSettingItemRepo.deleteByIds(ids);
    }

    @Override
    public List<ScpAllocSettingItemRespVO> getEnableAllocSettingItemByStoreCode(String storeCode, String docType, List<String> itemTypes) {
        ArrayList<ScpAllocSettingItemRespVO> respVOS = new ArrayList<ScpAllocSettingItemRespVO>();
        Object obj = this.redisTemplate.opsForValue().get((Object)("SCP:ALLOC:SETTING:" + storeCode));
        if (obj == null) {
            return new ArrayList<ScpAllocSettingItemRespVO>();
        }
        String str = (String)obj;
        ScpAllocSettingRedisDO setting = (ScpAllocSettingRedisDO)JSON.parseObject((String)str, ScpAllocSettingRedisDO.class);
        List<ScpAllocSettingRedisDO.ActivityDO> activityList = setting.getActivityList();
        for (ScpAllocSettingRedisDO.ActivityDO activityDO : activityList) {
            log.info("getEnableAllocSettingItemByStoreCode:{}", (Object)JSONUtil.toJsonStr((Object)activityDO));
            Object key = this.redisTemplate.opsForValue().get((Object)("SCP:ALLOC:SETTING:" + activityDO.getActivityId()));
            if (key == null) {
                log.info("\u5f3a\u914d\u6d3b\u52a8ID:{}\uff0c\u7f13\u5b58\u4e0d\u5b58\u5728", (Object)activityDO.getActivityId());
                continue;
            }
            if (LocalDateTime.now().compareTo(activityDO.getValidFrom()) < 0 || LocalDateTime.now().compareTo(activityDO.getValidTo()) > 0) {
                log.info("\u5f3a\u914d\u6d3b\u52a8ID:{}\uff0c\u5df2\u8fc7\u671f", (Object)activityDO.getActivityId());
                continue;
            }
            boolean contains = activityDO.getDocTypes().contains(docType);
            if (!contains) {
                log.info("\u5f3a\u914d\u6d3b\u52a8ID:{}\uff0c\u5355\u636e\u7c7b\u578b\u4e0d\u5339\u914d", (Object)activityDO.getActivityId());
                continue;
            }
            List<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = activityDO.getInnerItemDOS();
            for (ScpAllocSettingRedisDO.ActivityDO.InnerItemDO innerItemDO : innerItemDOS) {
                if (!itemTypes.contains(innerItemDO.getItemType2())) {
                    log.info("\u5f3a\u914d\u6d3b\u52a8ID:{}\uff0c\u5546\u54c1\u5206\u7c7b:{}\u4e0d\u5b58\u5728", (Object)activityDO.getActivityId(), (Object)innerItemDO.getItemType2());
                    continue;
                }
                ScpAllocSettingItemRespVO scpAllocSettingItemRespVO = new ScpAllocSettingItemRespVO();
                scpAllocSettingItemRespVO.setItemId(innerItemDO.getItemId());
                scpAllocSettingItemRespVO.setItemCode(innerItemDO.getItemCode());
                scpAllocSettingItemRespVO.setItemName(innerItemDO.getItemName());
                scpAllocSettingItemRespVO.setMasId(innerItemDO.getMasId());
                scpAllocSettingItemRespVO.setMinNum(innerItemDO.getMinNum());
                scpAllocSettingItemRespVO.setActivityCode(activityDO.getActivityCode());
                scpAllocSettingItemRespVO.setImgUrl(innerItemDO.getImgUrl());
                respVOS.add(scpAllocSettingItemRespVO);
            }
        }
        return respVOS;
    }

    @Override
    public List<Long> findMasIdByItemId(Long itemId) {
        return this.scpAllocSettingItemRepoProc.findMasIdByItemId(itemId);
    }

    public ScpAllocSettingItemDomainServiceImpl(RedisTemplate redisTemplate, ScpAllocSettingItemRepo scpAllocSettingItemRepo, ScpAllocSettingItemRepoProc scpAllocSettingItemRepoProc) {
        this.redisTemplate = redisTemplate;
        this.scpAllocSettingItemRepo = scpAllocSettingItemRepo;
        this.scpAllocSettingItemRepoProc = scpAllocSettingItemRepoProc;
    }
}

