/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.msg.impl;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.system.cacheable.SysCacheUserRpcService;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitesland.scp.application.facade.vo.resp.msg.BaseScpMessageDetailRespVO;
import com.elitesland.scp.application.facade.vo.resp.msg.BaseScpMessageListRespVO;
import com.elitesland.scp.domain.entity.msg.ScpMessageDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.msg.ScpMessageChannelRepoProc;
import com.elitesland.scp.infr.repo.msg.ScpMessageReceiverRepoProc;
import com.elitesland.scp.infr.repo.msg.ScpMessageRepoProc;
import com.elitesland.scp.infr.repo.msg.ScpMessageTxtRepoProc;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

abstract class BaseScpMessageService
extends BaseServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(BaseScpMessageService.class);
    @Autowired
    protected ScpMessageRepoProc repoProc;
    @Autowired
    protected ScpMessageChannelRepoProc channelRepoProc;
    @Autowired
    protected ScpMessageTxtRepoProc txtRepoProc;
    @Autowired
    protected ScpMessageReceiverRepoProc receiverRepoProc;
    @Autowired
    protected FileService fileService;
    @Autowired
    protected SysCacheUserRpcService cacheUserRpcService;
    @Autowired
    protected RmiOrgStoreRpcService orgStoreRpcService;

    BaseScpMessageService() {
    }

    protected <T extends BaseScpMessageDetailRespVO> void fillDetailInfo(ScpMessageDO messageDO, T messageVO) {
        SysUserBasicDTO author;
        if (messageDO.getTxtId() != null) {
            messageVO.setTxt(this.txtRepoProc.getTxt(messageDO.getTxtId()));
        }
        if (messageVO.getAuthorId() != null && (author = this.cacheUserRpcService.getById(messageVO.getAuthorId())) != null) {
            messageVO.setAuthorName(author.getFullName());
        }
        messageVO.setCategoryName(super.udcValue("yst-suplan", ScpUdcEnum.SCP_MESSAGE_CATEGORY_DEFAULT.getCodeName(), messageVO.getCategory()));
        messageVO.setFiles(this.queryFiles(messageDO.getFileCodesStr()));
    }

    protected <T extends BaseScpMessageListRespVO> void fillListInfo(List<T> messageList) {
        Map categoryNameMap = super.udcMap("yst-suplan", ScpUdcEnum.SCP_MESSAGE_CATEGORY_DEFAULT.getCodeName());
        messageList.forEach(t -> {
            SysUserBasicDTO author = this.cacheUserRpcService.getById(t.getAuthorId());
            if (author != null) {
                t.setAuthorName(author.getFullName());
            }
            t.setCategoryName((String)categoryNameMap.get(t.getCategory()));
        });
    }

    protected List<FileObjRespVO<?>> queryFiles(String fileCodeStr) {
        if (!StringUtils.hasText((String)fileCodeStr)) {
            return Collections.emptyList();
        }
        ApiResult fileResult = this.fileService.query(Arrays.asList(fileCodeStr.split(",")));
        if (!fileResult.isSuccess()) {
            logger.error("\u67e5\u8be2\u9644\u4ef6\u5f02\u5e38\uff1a{}, {}", (Object)fileCodeStr, (Object)fileResult.getMsg());
        }
        return (List)fileResult.getData();
    }
}

