/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.stock;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageParam;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockPageVO;
import com.elitesland.scp.domain.convert.stock.ScpSafetyTargetStockConvert;
import com.elitesland.scp.domain.entity.stock.ScpSafetyTargetStockDO;
import com.elitesland.scp.domain.service.stock.ScpSafetyTargetStockDomainService;
import com.elitesland.scp.infr.dto.stock.ScpSafetyTargetStockDTO;
import com.elitesland.scp.infr.repo.stock.ScpSafetyTargetStockRepo;
import com.elitesland.scp.infr.repo.stock.ScpSafetyTargetStockRepoProc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpSafetyTargetStockDomainServiceImpl
implements ScpSafetyTargetStockDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpSafetyTargetStockDomainServiceImpl.class);
    private final ScpSafetyTargetStockRepo scpSafetyTargetStockRepo;
    private final ScpSafetyTargetStockRepoProc scpSafetyTargetStockRepoProc;

    @Override
    public PagingVO<ScpSafetyTargetStockPageVO> searchPage(ScpSafetyTargetStockPageParam param) {
        return this.scpSafetyTargetStockRepoProc.searchPage(param);
    }

    @Override
    public ScpSafetyTargetStockDTO findById(Long id) {
        Optional targetStockDO = this.scpSafetyTargetStockRepo.findById(id);
        return targetStockDO.map(ScpSafetyTargetStockConvert.INSTANCE::doToDto).orElse(null);
    }

    @Override
    public List<ScpSafetyTargetStockDTO> findByBusinessKey(String businessKey) {
        List<ScpSafetyTargetStockDO> safetyTargetStockDOS = this.scpSafetyTargetStockRepo.findAllByBusinessIdIn(List.of(businessKey));
        if (CollectionUtils.isNotEmpty(safetyTargetStockDOS)) {
            return safetyTargetStockDOS.stream().map(ScpSafetyTargetStockConvert.INSTANCE::doToDto).collect(Collectors.toList());
        }
        return new ArrayList<ScpSafetyTargetStockDTO>();
    }

    @Override
    @Transactional
    public Long save(ScpSafetyTargetStockDTO dto) {
        return ((ScpSafetyTargetStockDO)this.scpSafetyTargetStockRepo.save(ScpSafetyTargetStockConvert.INSTANCE.dtoToDo(dto))).getId();
    }

    @Override
    @Transactional
    public List<ScpSafetyTargetStockDO> saveAll(List<ScpSafetyTargetStockDTO> saveList) {
        List stockDOS = saveList.stream().map(ScpSafetyTargetStockConvert.INSTANCE::dtoToDo).collect(Collectors.toList());
        return this.scpSafetyTargetStockRepo.saveAll(stockDOS);
    }

    @Override
    @Transactional
    public void delete(List<Long> ids) {
        this.scpSafetyTargetStockRepo.deleteAllById(ids);
    }

    @Override
    public List<ScpSafetyTargetStockDTO> findIdBatch(List<Long> ids) {
        List stockDOS = this.scpSafetyTargetStockRepo.findAllById(ids);
        if (CollectionUtils.isEmpty((Collection)stockDOS)) {
            return new ArrayList<ScpSafetyTargetStockDTO>();
        }
        return stockDOS.stream().map(ScpSafetyTargetStockConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    public ScpSafetyTargetStockDomainServiceImpl(ScpSafetyTargetStockRepo scpSafetyTargetStockRepo, ScpSafetyTargetStockRepoProc scpSafetyTargetStockRepoProc) {
        this.scpSafetyTargetStockRepo = scpSafetyTargetStockRepo;
        this.scpSafetyTargetStockRepoProc = scpSafetyTargetStockRepoProc;
    }
}

