package com.elitesland.scp.application.web.feedback;

import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackApproveVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackRespVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackQueryParamVO;
import com.elitesland.scp.application.facade.vo.feedback.ScpStoreFeedbackSaveVO;
import com.elitesland.scp.application.service.feedback.ScpStoreFeedbackService;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.val;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author makejava
 * @since 2025-09-23 18:07:53
 */
@RestController
@RequestMapping("/scpStoreFeedback")
@Api(value = "门店反馈", tags = {"门店反馈"})
@RequiredArgsConstructor
public class ScpStoreFeedbackController {

    private final ScpStoreFeedbackService scpStoreFeedbackService;

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("通过主键查询单条数据")
    ApiResult<ScpStoreFeedbackRespVO>  findIdOne(@PathVariable  Long id){
        return scpStoreFeedbackService.findIdOne(id).map(ApiResult::ok)
        .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }

    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/searchByApp")
    @ApiOperation("小程序分页查询")
    public  ApiResult<PagingVO<ScpStoreFeedbackRespVO>> search(@RequestBody ScpStoreFeedbackQueryParamVO param){
        val ret = scpStoreFeedbackService.search(param);
        return ApiResult.ok(ret);
    }

    @PostMapping("/searchByPc")
    @ApiOperation("PC分页查询")
    public  ApiResult<PagingVO<ScpStoreFeedbackRespVO>> searchByPc(@RequestBody ScpStoreFeedbackQueryParamVO param){
        val ret = scpStoreFeedbackService.searchByPc(param);
        return ApiResult.ok(ret);
    }

    /**
     * 批量新增数据
     *
     * @param list 对象集合
     */
    @PostMapping("/createBatch")
    @ApiOperation("批量新增数据")
    public ApiResult<Object> createBatch(@RequestBody List<ScpStoreFeedbackSaveVO> list){
        return ApiResult.ok( scpStoreFeedbackService.createOrUpdateBatch(list));
    }

    @PostMapping("/approveBatch")
    @ApiOperation("批量审批单据")
    public ApiResult<Object> approveBatch(@RequestBody ScpStoreFeedbackApproveVO params){
        scpStoreFeedbackService.approveBatch(params);
        return ApiResult.ok();
    }

}


