package com.elitesland.scp.domain.service.order;

import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPayInfoRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderRelateDTO;
import org.springframework.data.domain.Page;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public interface ScpDemandOrderDDomainService {

    /**
     * 订货订单明细保存
     *
     * @param saveVO
     * @return
     */
    Long saveDemandOrderD(ScpDemandOrderDSaveVO saveVO);

    List<ScpDemandOrderDDO> findByMasIdAndCombineItemCodeIsNotNull(ScpDemandOrderDPageParamVO paramVO);

    /**
     * 订单订单查询
     *
     * @param ids
     * @return
     */
    List<ScpDemandOrderDDTO> findDemandOrderDByIds(List<Long> ids);

    /**
     * 根据订货订单ID查询明细信息
     *
     * @param masId
     * @return
     */
    List<ScpDemandOrderDDTO> findDemandOrderDByMasId(Long masId);

    /**
     * @param spuCode
     * @return
     */
    List<ScpDemandOrderDDO> findDemandOrderDBySpuCodes(Long masId, List<String> spuCode);


    /**
     * 订单行分页查询
     *
     * @param paramVO
     * @return
     */
    Page<ScpDemandOrderDDO> pageDemandOrderDByMasId(ScpDemandOrderDPageParamVO paramVO);

    /**
     * 删除订货订单明细
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 更新订货订单明细计划数量
     *
     * @param id
     * @param planQty
     */
    void updatePlanQtyAndAmtById(Long id, BigDecimal planQty);

    /**
     * 批量保存
     *
     * @param saveVOS
     * @param lineNo
     * @param source
     */
    void batchSave(List<ScpDemandOrderDSaveVO> saveVOS, AtomicInteger lineNo, String source);

    default void batchSave(List<ScpDemandOrderDSaveVO> saveVOS, AtomicInteger lineNo) {
        batchSave(saveVOS, lineNo, null);
    }


    /**
     * 更新供应商配货的订单明细计划数量
     *
     * @param demandId
     */
    void updateSuppAllocPlanQty(Long demandId);

    void updateIsPushed(List<Long> dIds, String msg);

    /**
     * 更新订货单明细已推送
     *
     * @param dIds
     */
    default void updateIsPushed(List<Long> dIds) {
        updateIsPushed(dIds, null);
    }

    /**
     * 更新订货单明细同步其他业务域信息
     *
     * @param dIds
     */
    void updateSyncMsg(List<Long> dIds, String msg);

    void updateSrcInfo(Long srcDocId, String srcDocNo, Long dId, Integer srcDocLineNo);

    void updatePOSrcInfo(Long id, Long srcDocId, String srcDocNo, String srcLineNO);

    void clearSrcDocInfo(Long docId);

    void resetSrcDocQuantity(Long dId, BigDecimal qty);

    void updateAllocQuantity(Long dId, BigDecimal qty);

    void updateQuantity(Long dId, BigDecimal qty);

    void updateErrorMsg(Long dId, String errorMsg);

    /**
     * 删除未推送的明细行
     *
     * @param masId
     */
    void deleteUnPushedItem(Long masId);

    /**
     * 根据源单ID删除
     *
     * @param sourceIds
     */
    void deleteBySourceIds(List<Long> sourceIds);

    /**
     * 查询已推送订货单明细最大的行号
     *
     * @param masId
     * @return
     */
    BigDecimal findMaxLineNoPushedByMasId(Long masId);


    /**
     * 根据订货订单ID集合查询明细信息
     *
     * @param masIds
     * @return
     */
    List<ScpDemandOrderDDTO> findDemandOrderDByMasIds(List<Long> masIds);

    /**
     * 根据订货订单ID查询明细信息
     *
     * @param dIds
     * @return
     */
    List<Long> getMasIdByDId(List<Long> dIds);

    /**
     * 取消订货单明细
     *
     * @param dIds
     */
    void cancelOrderByDIds(List<Long> dIds);

    /**
     * 订货订单支付信息
     *
     * @param masId
     * @return
     */
    List<ScpDemandOrderPayInfoRespVO> payInfo(Long masId);

    /**
     * 更新收货数量
     *
     * @param dId
     * @param qty
     */
    void updateRecvQty(Long dId, BigDecimal qty);

    /**
     * 初始化订货单明细分配数量=计划数量
     *
     * @param masId
     */
    void initAllocQuantity(Long masId);

    /**
     * 支付回传
     */
    void updatePayStatus(List<Long> ids, String payStatus);

    /**
     * 根据源单ID查询明细信息
     *
     * @param srcDocId
     * @return
     */
    List<ScpDemandOrderDDTO> findDemandOrderDBySrcDocId(Long srcDocId);

    List<ScpDemandOrderDDTO> findDemandOrderDBySrcDocNo(String srcDocNo);

    /**
     * 根据源单ID查询单据创建时间
     *
     * @param srcDocId
     * @return
     */
    LocalDateTime findDocCreateTimeBySrcDocId(Long srcDocId);

    /**
     * 根据源单ID查询明细信息
     *
     * @param masId
     * @return
     */
    List<ScpDemandOrderRelateDTO> findRelateOrderByMasId(Long masId);
}
