package com.elitesland.scp.infr.repo.order;

import com.elitesland.scp.domain.entity.order.ScpOrderTemplateDO;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;

import javax.transaction.Transactional;
import java.util.List;
import java.util.Optional;

public interface ScpOrderTemplateRepo  extends JpaRepository<ScpOrderTemplateDO, Long>, QuerydslPredicateExecutor<ScpOrderTemplateDO> {
    @NotNull Optional<ScpOrderTemplateDO> findById(@NotNull Long id);

    void deleteById(@NotNull Long id);

    @Modifying
    @Transactional
    @Query("DELETE FROM ScpOrderTemplateDO WHERE id IN :id")
    void deleteByIdList(@Param("id") List<Long> id);

    List<ScpOrderTemplateDO> findByIsActive(@NotNull Integer isActive);


}
