/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.wechat;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.service.wechat.WechatService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u5fae\u4fe1\u767b\u5f55\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/wechat"}, produces={"application/json"})
public class WeChatLoginController {
    private static final Logger log = LoggerFactory.getLogger(WeChatLoginController.class);
    private final WechatService wechatService;

    @ApiOperation(value="oauth2\u767b\u5f55\u5730\u5740")
    @PostMapping(value={"/oauth2/url"})
    public ApiResult<String> oauth2LoginUrl() {
        return ApiResult.ok((Object)this.wechatService.oauth2LoginUrl());
    }

    @ApiOperation(value="SSO\u767b\u5f55\u5730\u5740")
    @PostMapping(value={"/sso/url"})
    public ApiResult<String> ssoLoginUrl() {
        return ApiResult.ok((Object)this.wechatService.webLoginUrl());
    }

    @ApiOperation(value="\u4f01\u4e1a\u5fae\u4fe1\u56de\u8c03")
    @GetMapping(value={"/redirect"})
    public ApiResult<String> redirect(@RequestParam(value="code") String code, @RequestParam(value="state") String state) {
        log.info("\u4f01\u4e1a\u5fae\u4fe1\u56de\u8c03code:{},state:{}", (Object)code, (Object)state);
        return ApiResult.ok((Object)code);
    }

    @ApiOperation(value="PC\u767b\u5f55")
    @GetMapping(value={"/pc/login"})
    public ApiResult<String> pcLogin(@RequestParam(value="code") String code) {
        log.info("\u4f01\u4e1a\u5fae\u4fe1PC\u767b\u5f55code:{}", (Object)code, (Object)code);
        return ApiResult.ok((Object)this.wechatService.pcLogin(code));
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u767b\u5f55")
    @GetMapping(value={"/mg/login"})
    public ApiResult<String> mgLogin(@RequestParam(value="code") String code) {
        log.info("\u4f01\u4e1a\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u767b\u5f55code:{}", (Object)code, (Object)code);
        return ApiResult.ok((Object)this.wechatService.mgLogin(code));
    }

    public WeChatLoginController(WechatService wechatService) {
        this.wechatService = wechatService;
    }
}

