package com.elitesland.scp.application.facade.vo.boh;

import com.elitesland.support.provider.item.dto.ItmItemQualifyRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemUomConvRpcDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class StoreReceiveDDetailVO implements Serializable {
    @ApiModelProperty("明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品url")
    private String imageUrl;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("单位")
    private String uom;
    private String uomName;

    @ApiModelProperty("订货数")
    private BigDecimal orderQty;

    @ApiModelProperty("已发数")
    private BigDecimal deliveryQty;

    @ApiModelProperty("实收数")
    private BigDecimal receiveQty;

    @ApiModelProperty("库存状态")
    private String limit1;
    private String limit1Name;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;


    @ApiModelProperty("生产日期")
    private LocalDateTime expireDate;

    private String manuFactory;

    private String manuFactoryName;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("订货单明细id")
    private Long orderDid;

    @ApiModelProperty("是否管理批次")
    private Boolean lotFlag;

    @ApiModelProperty("厂家")
    private String lotFlagName;

    @ApiModelProperty("证照信息")
    List<ItmItemQualifyRpcDTO> itemQualifyRpcDTOList;

    @ApiModelProperty("基本单位")
    private String uom1;
    private String uom1Name;

    @ApiModelProperty("中单位")
    private String uom3;
    private String uom3Name;

    @ApiModelProperty("大单位")
    private String uom4;
    private String uom4Name;

    @ApiModelProperty("单位转换关系")
    List<ItmItemUomConvRpcDTO> itmItemUomConvRpcDTOS;
}