package com.elitesland.scp.application.facade.vo.calendar;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.scp.application.service.scpsman.BaseScpmanAuthorityParam;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;


/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 29日 15:19
 * @version: 1.0
 */
@Data
@ApiModel(value = "ScpStoreDemandCalendarPageParamVO", description = "门店日历分页条件")
public class ScpStoreDemandCalendarPageParamVO extends AbstractOrderQueryParam implements BaseScpmanAuthorityParam, Serializable {

    @ApiModelProperty(value = "门店id")
    private Long storeId;

    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    private List<String> itemType2s;

    private String itemType2;


    @ApiModelProperty(value = "开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;

    @ApiModelProperty(value = "结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    @ApiModelProperty(value = "计划员数据权限")
    private Boolean scpmanAuthority;

    @ApiModelProperty(value = "门店集合")
    private List<String> stores;

    @ApiModelProperty(value = "仓库集合")
    private List<String> whCodes;

    @ApiModelProperty(value = "年月")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate filterDate;
}
