package com.elitesland.scp.application.facade.vo.whnet;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 20日 15:24
 * @version: 1.0
 */
@Data
@ApiModel("仓网关系详情查询")
public class ScpWhNetRelationBaseParamVO implements Serializable {

    @ApiModelProperty(value = "需求门店id/门店仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull(message = "需求门店id/门店仓库id 为空")
    private Long demandWhStId;

    @ApiModelProperty(value = "需求门店/仓库编码")
    @NotBlank(message = "需求门店/仓库编码")
    private String demandWhStCode;

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;



}

