package com.elitesland.scp.application.facade.vo.whnet;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 22日 15:37
 * @version: 1.0
 */
@Data
@ApiModel(value = "ScpWhNetRelationExportRespVO", description = "仓网关系导出")
public class ScpWhNetRelationExportRespVO implements Serializable {

    @ApiModelProperty(value = "供应仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long supplyWhId;

    @ApiModelProperty(value = "供应仓库编码")
    private String supplyWhCode;

    @ApiModelProperty(value = "供应仓库名称")
    private String supplyWhName;

    @ApiModelProperty(value = "类型")
    @SysCode(sys = "yst-suplan", mod = "DEMAND_SET_TYPE")
    private String type;

    @ApiModelProperty(value = "类型名")
    private String typeName;

    @ApiModelProperty(value = "需求门店id/门店仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long demandWhStId;

    @ApiModelProperty(value = "需求仓库编码/门店编码")
    private String demandWhStCode;

    @ApiModelProperty(value = "需求仓库名称/门店名称")
    private String demandWhStName;

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;

    @ApiModelProperty(value = "商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "转移提前期")
    private BigDecimal transferLeadTime;

    @ApiModelProperty(value = "供应百分比")
    private BigDecimal supplyPercentage;

    @ApiModelProperty(value = "供应百分比之和")
    private BigDecimal supplyPercentageSum;

    @ApiModelProperty(value = "采购提前期")
    private BigDecimal purchaseLeadTime;

    @ApiModelProperty(value = "异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    @ApiModelProperty(value = "状态")
    private Boolean status;

    @ApiModelProperty(value = "状态名称")
    private String statusName;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @ApiModelProperty("销售公司名称")
    private String ouName;
}
